/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.extras.common.LicenseException;
import com.atlassian.fecru.security.SshKeyManagerImpl;
import com.atlassian.fecru.security.SshKeySupplierImpl;
import com.atlassian.fisheye.git.client.GitProcessFactory;
import com.atlassian.fisheye.hg.client.HgProcessFactory;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryConfigFactory;
import com.cenqua.fisheye.config.RepositoryConfigFactoryImpl;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.ctl.BaseCommand;
import com.cenqua.fisheye.ctl.SvnInfoRunner;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.cenqua.fisheye.svn.SvnChangePath;
import com.cenqua.fisheye.svn.SvnClientFactory;
import com.cenqua.fisheye.svn.SvnLogMessage;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.SvnPasswordSupplier;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.util.FileSystemUtils;
import com.cenqua.fisheye.util.Throttle;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class VerifySvnSymbolicRules
extends BaseCommand {
    private static final long TIMEOUT = 600000L;
    private final String repoName;
    private final RootConfig rootConfig;
    private final PathAggregator pathAggregator;
    private RepositoryConfig repoConfig;
    private SvnScmConfig scmConfig;
    private SvnRepositoryInfo svnRepositoryInfo;
    private RepositoryConfigFactory repositoryConfigFactory;
    private static String startRevision;
    private static String endRevision;

    public static void main(String[] args) {
        VerifySvnSymbolicRules.setupLogging(true);
        Logs.APP_LOG.info((Object)"FishEye SVN Symbolic Rules Verifier");
        LinkedList argList = Lists.newLinkedList(Arrays.asList(args));
        if (!VerifySvnSymbolicRules.handleCommonArguments(argList, System.err) || !VerifySvnSymbolicRules.handleArguments(argList.iterator())) {
            return;
        }
        if (argList.size() != 1) {
            Logs.APP_LOG.error((Object)"Please enter name of the repository to check symbolic rules for.");
            return;
        }
        String repName = (String)Iterables.getOnlyElement((Iterable)argList);
        try {
            VerifySvnSymbolicRules verifier = new VerifySvnSymbolicRules(repName);
            verifier.init();
            verifier.verifyRepo(startRevision, endRevision);
        }
        catch (UserReportableException e2) {
            Logs.APP_LOG.error((Object)e2.getMessage(), e2.getCause());
        }
        catch (LicenseException e3) {
            Logs.APP_LOG.error((Object)e3.getMessage(), e3.getCause());
        }
        catch (ConfigException e4) {
            Logs.APP_LOG.error((Object)e4.getMessage(), e4.getCause());
        }
        catch (RepositoryClientException e5) {
            Logs.APP_LOG.error((Object)e5.getMessage(), e5.getCause());
        }
        catch (InterruptedException e6) {
            Logs.APP_LOG.error((Object)e6.getMessage(), e6.getCause());
        }
    }

    private static boolean handleArguments(Iterator<String> argList) {
        while (argList.hasNext()) {
            String next = argList.next();
            if ("-s".equals(next) || "--start".equals(next)) {
                argList.remove();
                if (!argList.hasNext()) {
                    Logs.APP_LOG.error((Object)"-s or --start parameter must be followed by a start revision number (or START)");
                    return false;
                }
                startRevision = argList.next();
                argList.remove();
            }
            if ("-e".equals(next) || "--end".equals(next)) {
                argList.remove();
                if (!argList.hasNext()) {
                    Logs.APP_LOG.error((Object)"-e or --end parameter must be followed by an end revision number (or HEAD)");
                    return false;
                }
                endRevision = argList.next();
                argList.remove();
            }
            if (!"-h".equals(next) && !"--help".equals(next)) continue;
            Logs.APP_LOG.error((Object)"Usage: fisheyectl.sh svnrules repname\nVerifies symbolic rules on selected svn repository.\nPlease note this command may take very long time to run.\n\nOPTIONS:\n   -s, --start         start analysis from given revision number (numeric or START), default START\n                       where START is start revision configured in Fisheye for selected repository\n                       or revision 1 if start revision is empty.\n   -e, --end           finish analysis on a given revision number (numeric or HEAD), default HEAD\n   -h, --help          this help");
            return false;
        }
        return true;
    }

    VerifySvnSymbolicRules(String repoName) {
        Preconditions.checkNotNull((Object)repoName);
        this.repoName = repoName;
        this.rootConfig = new RootConfig();
        this.pathAggregator = new PathAggregator(5);
    }

    void init() throws UserReportableException, ConfigException {
        File configFile = AppConfig.getConfigurationFile();
        try {
            this.rootConfig.load(configFile);
        }
        catch (IOException e2) {
            throw new UserReportableException("Failed to process configuration file " + configFile, e2);
        }
        catch (ConfigException e3) {
            throw new UserReportableException("Failed to process configuration file " + configFile, e3);
        }
        this.rootConfig.loadLicense();
        SvnLoader.setup(this.rootConfig.getConfig().getSvnConfig());
        SshKeyManagerImpl sshKeyManager = new SshKeyManagerImpl(this.rootConfig, new FileSystemUtils(), new SshKeySupplierImpl());
        this.repositoryConfigFactory = new RepositoryConfigFactoryImpl(this.rootConfig, sshKeyManager, new GitProcessFactory(sshKeyManager), new HgProcessFactory(sshKeyManager));
        Logs.APP_LOG.debug((Object)("About to check Symbolic Rules for SVN repo " + this.repoName));
        this.repoConfig = this.getSvnRepositoryConfig();
        this.testConnection();
        this.scmConfig = (SvnScmConfig)this.repoConfig.getScmConfig();
        this.svnRepositoryInfo = new SvnRepositoryInfo(this.repoConfig);
    }

    SvnInfoRunner setUpInfoRunner(BlockingQueue<SvnLogMessage> suspectedSvnCopyOperationsQueue, String startRevision, String endRevision) throws UserReportableException {
        NetworkRepositorySettings networkSettings = this.scmConfig.getNetworkSettings();
        SvnPasswordSupplier passwordSupplier = new SvnPasswordSupplier(networkSettings.getUsername(), networkSettings.getPassword(), this.repoConfig.getStatus());
        SvnClientFactory svnClientFactory = new SvnClientFactory(passwordSupplier, this.svnRepositoryInfo.getRepositoryURL());
        SvnThrottledClient svnClient = new SvnThrottledClient("Tester", new Throttle(), svnClientFactory, 600000L);
        return new SvnInfoRunner(suspectedSvnCopyOperationsQueue, this.svnRepositoryInfo, svnClient, startRevision, endRevision);
    }

    void verifyRepo(String startRevision, String endRevision) throws RepositoryClientException, InterruptedException, UserReportableException {
        ArrayBlockingQueue<SvnLogMessage> suspectedSvnCopyOperationsQueue = new ArrayBlockingQueue<SvnLogMessage>(500);
        SvnInfoRunner svnInfoRunner = this.setUpInfoRunner(suspectedSvnCopyOperationsQueue, startRevision, endRevision);
        svnInfoRunner.spawnSvnInfoThread();
        while (true) {
            SvnLogMessage svnLogMessage;
            if (null == (svnLogMessage = (SvnLogMessage)suspectedSvnCopyOperationsQueue.poll(5L, TimeUnit.MINUTES))) {
                continue;
            }
            if (SvnInfoRunner.SENTINEL == svnLogMessage) break;
            this.analyseChangedPaths(svnLogMessage);
        }
        this.reportSummary();
    }

    private void reportSummary() {
        int count = this.pathAggregator.getPathsAddedCount();
        Logs.APP_LOG.log((Priority)(count == 0 ? Level.INFO : Level.WARN), (Object)MessageFormat.format("Verification complete, {0,choice,0#no issues|1#1 issue|1<{0,number,0} issues} found.", count));
        if (count == 0) {
            return;
        }
        Logs.APP_LOG.warn((Object)"Most common issues:");
        for (PathOccurrences po : this.pathAggregator.getTopPaths(10)) {
            Logs.APP_LOG.warn((Object)MessageFormat.format("Path {0} reported {1,choice,1#1 time|1<{1,number,0} times}.", po.getPath(), po.getCount()));
        }
    }

    void analyseChangedPaths(SvnLogMessage svnInfoDetails) {
        SvnLogicalPathMatcher pathMatcher = this.scmConfig.getPathMatcher();
        for (SvnChangePath cp : svnInfoDetails.getChangePaths()) {
            Path p2;
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)("Analysing suspected path: " + cp.getPath()));
            }
            if (!this.svnRepositoryInfo.isPathInRepo(p2 = this.svnRepositoryInfo.getLocalPath(cp.getPath(), svnInfoDetails.getRevisionNumber()))) {
                if (!Logs.APP_LOG.isDebugEnabled()) continue;
                Logs.APP_LOG.debug((Object)("Ignoring path: " + p2.getPath()));
                continue;
            }
            String trunk = pathMatcher.getTrunk(p2);
            if (null != trunk) {
                Logs.APP_LOG.warn((Object)("Copy operation recognised as commit to trunk, if this is branch or tag creation change consider adding symbolic rule. Revision: " + svnInfoDetails.getRevision() + ", path: " + cp.getPath()));
                this.pathAggregator.addPath(p2);
                return;
            }
            String branch = pathMatcher.getBranch(p2);
            String tag = pathMatcher.getTag(p2);
            if (null != branch || null != tag) continue;
            Logs.APP_LOG.warn((Object)("Copy operation recognised as unknown commit, if this is branch or tag creation change consider adding symbolic rule. Revision: " + svnInfoDetails.getRevision() + ", path: " + cp.getPath()));
            this.pathAggregator.addPath(p2);
        }
    }

    private void testConnection() throws ConfigException {
        Logs.APP_LOG.info((Object)("Testing connection to repo " + this.repoName));
        this.repoConfig.testConnection();
        Logs.APP_LOG.info((Object)("Connected to repo " + this.repoName));
    }

    RepositoryConfig getSvnRepositoryConfig() throws UserReportableException {
        RepositoryConfig repositoryConfig = this.repositoryConfigFactory.createRepositoryConfig(this.getSvnRepositoryDefinition(), new NullLicenseEnforcer());
        ConfigException configException = repositoryConfig.getConfigException();
        if (null != configException) {
            throw new UserReportableException("Repository misconfiguration issue found", configException);
        }
        return repositoryConfig;
    }

    RepositoryType getSvnRepositoryDefinition() throws UserReportableException {
        RepositoryType repositoryDefinition = this.getRepositoryDefinition();
        if (!repositoryDefinition.isSetSvn()) {
            throw new UserReportableException("This command can only be applied to SVN repository");
        }
        return repositoryDefinition;
    }

    RepositoryType getRepositoryDefinition() throws UserReportableException {
        RepositoryType[] repEls;
        for (RepositoryType repositoryType : repEls = this.rootConfig.getConfig().getRepositoryArray()) {
            String name = repositoryType.getName();
            if (!name.equalsIgnoreCase(this.repoName)) continue;
            return repositoryType;
        }
        throw new UserReportableException("No repository found of name: " + this.repoName);
    }

    static class PathOccurrences
    implements Comparable<PathOccurrences> {
        private final Path path;
        private final String pathStr;
        private final int count;

        PathOccurrences(Path path, int count) {
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkArgument((count > 0 ? 1 : 0) != 0);
            this.path = path;
            this.pathStr = PathOccurrences.getPath(path);
            this.count = count;
        }

        public String getPath() {
            return this.pathStr;
        }

        private static String getPath(Path p2) {
            String ret = p2.getPath();
            return ret.charAt(0) == '/' ? ret : "/" + ret;
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            PathOccurrences that = (PathOccurrences)o2;
            return Objects.equal((Object)this.count, (Object)that.count) && Objects.equal((Object)this.path, (Object)that.path);
        }

        public boolean isMyParentWithSameCount(PathOccurrences o2) {
            return o2.count == this.count && o2.path.isAncestor(this.path);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.path, this.count});
        }

        public String toString() {
            return "PathOccurrences{path='" + this.getPath() + '\'' + ", count=" + this.count + '}';
        }

        @Override
        public int compareTo(PathOccurrences o2) {
            return ComparisonChain.start().compare(o2.count, this.count).compare(o2.path.numComponents(), this.path.numComponents()).compare((Comparable)this.path, (Comparable)o2.path).result();
        }
    }

    static class PathAggregator {
        private final int depth;
        private final Multiset<Path> paths;
        private int count;

        PathAggregator(int depth) {
            Preconditions.checkArgument((depth > 0 ? 1 : 0) != 0);
            this.depth = depth;
            this.paths = HashMultiset.create();
        }

        public void addPath(Path path) {
            Path[] pathComponents = path.getPathComponents();
            int lastElementExclusive = Math.min(pathComponents.length - 1, this.depth) + 1;
            if (lastElementExclusive > 1) {
                this.paths.addAll(Arrays.asList(pathComponents).subList(1, lastElementExclusive));
            }
            ++this.count;
        }

        public Collection<PathOccurrences> getTopPaths(int howMany) {
            Preconditions.checkArgument((howMany > 0 ? 1 : 0) != 0);
            TreeSet pos = Sets.newTreeSet((Iterable)Collections2.transform((Collection)this.paths.entrySet(), (Function)new Function<Multiset.Entry<Path>, PathOccurrences>(){

                public PathOccurrences apply(Multiset.Entry<Path> input) {
                    return new PathOccurrences((Path)input.getElement(), input.getCount());
                }
            }));
            ArrayList ret = Lists.newArrayListWithCapacity((int)howMany);
            for (PathOccurrences po : pos) {
                if (this.wasChildReported(ret, po)) continue;
                ret.add(po);
                if (ret.size() != howMany) continue;
                break;
            }
            return ret;
        }

        private boolean wasChildReported(Collection<PathOccurrences> ret, PathOccurrences po) {
            if (ret.isEmpty()) {
                return false;
            }
            for (PathOccurrences p2 : ret) {
                if (!p2.isMyParentWithSameCount(po)) continue;
                return true;
            }
            return false;
        }

        public int getPathsAddedCount() {
            return this.count;
        }
    }

    static class UserReportableException
    extends Exception {
        UserReportableException(String message) {
            super(message);
        }

        private UserReportableException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

