/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.crowd.support.SupportInformationService;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsConfigurationManager;
import com.cenqua.crucible.CrucibleVersionInfo;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DatabaseConfig;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.ResourcesType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.support.ModzDetectorCache;
import com.cenqua.fisheye.support.SystemResourceMonitor;
import com.cenqua.fisheye.util.LargeNumberFormatter;
import com.cenqua.fisheye.web.admin.actions.plugins.PluginDataFactory;
import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;

public class SystemInfoMessage {
    private final String lineSeparator;
    private final StringBuilder message;
    private final RootConfig rootConfig;
    private final FisheyeVersionInfo feInfo;
    private final ConfigDocument.Config config;

    public SystemInfoMessage(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
        this.config = rootConfig.getConfig();
        this.feInfo = new FisheyeVersionInfo();
        this.lineSeparator = System.getProperty("line.separator");
        this.message = new StringBuilder();
    }

    private void println(String line) {
        this.message.append(line).append(this.lineSeparator);
    }

    private void println() {
        this.message.append(this.lineSeparator);
    }

    private void printField(String name, String value) {
        this.message.append(name).append(value).append(this.lineSeparator);
    }

    private void printField(String name, boolean value) {
        this.message.append(name).append(value).append(this.lineSeparator);
    }

    private void printField(String name, int value) {
        this.message.append(name).append(value).append(this.lineSeparator);
    }

    private void printField(String name, BigInteger value) {
        this.message.append(name).append(value).append(this.lineSeparator);
    }

    private void printSeparator() {
        this.println("--------------------------");
    }

    private void printSectionHeader(String sectionName) {
        this.println();
        this.printSeparator();
        this.println(sectionName);
        this.printSeparator();
    }

    public String getMessage() {
        this.message.setLength(0);
        try {
            this.addSystemInformation();
            this.addWebServerSetup();
            this.addModzInfo();
            this.addDatabaseConfig();
            this.addSecurityInfo();
            this.addPluginInfo();
            this.addTrustedApps();
            this.addLicenseDetails();
            this.addConnectionDetails();
        }
        catch (Exception e2) {
            Logs.APP_LOG.warn((Object)"Problem getting system information", (Throwable)e2);
            this.println();
            this.println("Could not generate rest of system information");
        }
        return this.message.toString();
    }

    private void addSystemInformation() {
        this.printSectionHeader("System Information");
        this.addVersionInfo();
        this.addEnvironment();
        this.addInputArgs();
        this.addMemoryInfo();
        this.addFileDescriptorInfo();
        this.addDebugState();
        this.addSvnLibraryInfo();
        this.addP4ClientInfo();
        this.addServerThreadConfig();
    }

    private void addConnectionDetails() {
        this.printSectionHeader("Connection Details");
        this.printField("Site URL      : ", this.rootConfig.getSiteURL());
    }

    private void addLicenseDetails() {
        ProductLicense cruLicense;
        this.printSectionHeader("License Details:");
        LicenseInfo license = this.rootConfig.getLicense();
        String sid = this.feInfo.getSid();
        ProductLicense productLicense = cruLicense = license == null ? null : license.getCrucibleLicense();
        if (!Strings.isNullOrEmpty((String)sid)) {
            this.printField("Server ID     : ", sid);
        }
        if (license != null) {
            this.printField("Product       : ", license.getProductName());
            StringBuilder licenseDescription = new StringBuilder();
            licenseDescription.append(license.getFisheyeLicense().getDescription());
            if (cruLicense != null && cruLicense.getDescription() != null && !cruLicense.getDescription().equals(license.getFisheyeLicense().getDescription())) {
                licenseDescription.append(" ").append(cruLicense.getDescription());
            }
            this.printField("License       : ", licenseDescription.toString());
            this.printField("Licensed To   : ", license.getOwnerStatement());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm Z");
            try {
                if (license.expires()) {
                    this.printField("Expires       : ", format.format(license.getSoftExpiryValue()));
                } else if (license.getLatestBuildAllowedValue() != null) {
                    this.printField("Expires       : ", format.format(license.getLatestBuildAllowedValue()));
                } else {
                    this.println("Expires       : Never");
                }
            }
            catch (LicenseException e2) {
                this.printField("Expires       : ", e2.getMessage());
            }
            if (license.getFisheyeLicense() != null && !license.getFisheyeLicense().isUnlimitedNumberOfUsers()) {
                this.printField("Maximum Number of FishEye Users: ", license.getFisheyeLicense().getMaximumNumberOfUsers());
            }
            if (cruLicense != null && !cruLicense.isUnlimitedNumberOfUsers()) {
                this.printField("Maximum Number of Crucible Users: ", cruLicense.getMaximumNumberOfUsers());
            }
        }
        this.println();
    }

    private void addTrustedApps() {
        this.printSectionHeader("Trusted Applications:");
        TrustedApplicationsConfigurationManager trustedApplicationsManager = (TrustedApplicationsConfigurationManager)SpringContext.getComponent("trustedApplicationsManager");
        for (TrustedApplication app : trustedApplicationsManager.getTrustedApplications()) {
            this.println(app.getID());
        }
    }

    private void addPluginInfo() {
        this.printSectionHeader("Installed Plugins");
        PluginDataFactory pdf = (PluginDataFactory)SpringContext.getComponent("pluginDataFactory");
        pdf.getPluginData(null, null);
        this.println(String.format("  %60s|%20s|%30s|%10s", " Name ", " Version ", " Vendor ", " State "));
        for (PluginDataFactory.PluginData p2 : pdf.getPluginData(null, null)) {
            this.println(String.format("  %60s|%20s|%30s|%10s", p2.getName(), p2.getVersion(), p2.getVendor(), p2.getState()));
        }
    }

    private void addSecurityInfo() {
        this.printSectionHeader("User management");
        SupportInformationService crowdSupportService = SpringContext.getComponent(SupportInformationService.class, "crowdSupportInformationService");
        String supportInformation = crowdSupportService.getSupportInformation(null);
        this.println(supportInformation);
        this.printSeparator();
        SecurityType securityType = this.config.getSecurity();
        if (securityType.isSetCustom()) {
            this.printField("Type           : ", "Custom");
            this.printField("Classname      : ", securityType.getCustom().getClassname());
            this.printField("Auto add users : ", securityType.getCustom().getAutoAdd());
            this.printField("Cache TTL (+ve): ", securityType.getCustom().getPositiveCacheTtl());
            this.printField("Properties     : ", securityType.getCustom().getProperties());
            this.printSeparator();
        }
        if (securityType.isSetAjp()) {
            this.printField("Type           : ", "Ajp");
            this.printField("Auto add users : ", securityType.getAjp().getAutoAdd());
            this.printField("Cache TTL (+ve): ", securityType.getAjp().getPositiveCacheTtl());
            this.printSeparator();
        }
    }

    private void addDatabaseConfig() {
        this.printSectionHeader("Database Details");
        DBControlFactory factory = (DBControlFactory)SpringContext.getComponent("dbControlFactory");
        DatabaseConfig dbConfig = factory.getCurrentControl().getInfo().getConnectionInfo();
        this.printField("Database Type         : ", dbConfig.getType().getDisplayName());
        this.printField("Database Driver       : ", dbConfig.getType().getDriver());
        this.printField("Database URL          : ", dbConfig.getJdbcURL());
        this.printField("Database Version      : ", Integer.toString(factory.getCurrentControl().getInfo().currentVersion()));
        this.printField("Database Connection Pool partitions count:      ", HibernateUtil.getCfg().getProperty("bonecp.partitionCount"));
        this.printField("Database Connection Pool (min per partition):   ", HibernateUtil.getCfg().getProperty("bonecp.minConnectionsPerPartition"));
        this.printField("Database Connection Pool (max per partition):   ", HibernateUtil.getCfg().getProperty("bonecp.maxConnectionsPerPartition"));
    }

    private void addModzInfo() {
        this.printSectionHeader("Installation State");
        ModzDetectorCache modz = new ModzDetectorCache();
        try {
            Modifications modifications = modz.getModifications();
            if (modifications.modifiedFiles.isEmpty()) {
                this.printField("Modified Files:     ", "None");
            } else {
                this.println("Modified Files:     ");
                for (Object mod : modifications.modifiedFiles) {
                    this.println("* " + mod.toString());
                }
            }
            if (modifications.removedFiles.isEmpty()) {
                this.printField("Removed Files:     ", "None");
            } else {
                this.println("Removed Files:     ");
                for (Object mod : modifications.removedFiles) {
                    this.println("* " + mod.toString());
                }
            }
        }
        catch (ModzRegistryException e2) {
            this.printField("Problem checking hash registry ", e2.getMessage());
            Logs.APP_LOG.warn((Object)"Problems checking hash registry", (Throwable)e2);
        }
    }

    private void addServerThreadConfig() {
        if (this.config.isSetResources()) {
            ResourcesType resourcesType = this.config.getResources();
            if (resourcesType.isSetInitialIndexThreads()) {
                if (resourcesType.getInitialIndexThreads().isSetMax()) {
                    this.printField("Initial Index Threads: ", resourcesType.getInitialIndexThreads().getMax() + " (max)");
                }
                if (resourcesType.getInitialIndexThreads().isSetMin()) {
                    this.printField("Initial Index Threads: ", resourcesType.getInitialIndexThreads().getMin() + " (min)");
                }
            }
            if (resourcesType.isSetIncrementalIndexThreads()) {
                if (resourcesType.getIncrementalIndexThreads().isSetMax()) {
                    this.printField("Incremental Index Threads: ", resourcesType.getIncrementalIndexThreads().getMax() + " (max)");
                }
                if (resourcesType.getIncrementalIndexThreads().isSetMin()) {
                    this.printField("Incremental Index Threads: ", resourcesType.getIncrementalIndexThreads().getMin() + " (min)");
                }
            }
        }
    }

    private void addWebServerSetup() {
        this.printSectionHeader("Webserver Setup");
        WebServerType webServer = this.config.getWebServer();
        if (webServer.isSetSiteUrl()) {
            this.printField("Site Url      : ", webServer.getSiteUrl());
        }
        if (webServer.isSetContext()) {
            this.printField("Web Context   :", webServer.getContext());
        }
        if (webServer.isSetHttp()) {
            this.printField("Http Bind       :", webServer.getHttp().getBind());
            if (webServer.getHttp().isSetContext()) {
                this.printField("Http Context      :", webServer.getHttp().getContext());
            }
            if (webServer.getHttp().isSetProxyHost()) {
                this.printField("Site Proxy Host    :", webServer.getHttp().getProxyHost());
            }
            if (webServer.getHttp().isSetProxyPort()) {
                this.printField("Site Proxy Port  : ", webServer.getHttp().getProxyPort());
            }
            if (webServer.getHttp().isSetProxyScheme()) {
                this.printField("Site Proxy Scheme: ", webServer.getHttp().getProxyScheme());
            }
        }
        if (webServer.isSetSsl()) {
            this.printField("Https Bind      :", webServer.getSsl().getBind());
            if (webServer.isSetContext()) {
                this.printField("Https Context      :", webServer.getContext());
            }
            if (webServer.getSsl().isSetProxyInfo()) {
                if (webServer.getSsl().getProxyInfo().isSetProxyHost()) {
                    this.printField("Https Site Proxy Host    :", webServer.getSsl().getProxyInfo().getProxyHost());
                }
                if (webServer.getSsl().getProxyInfo().isSetProxyPort()) {
                    this.printField("Https Site Proxy Port  : ", webServer.getSsl().getProxyInfo().getProxyPort());
                }
                if (webServer.getSsl().getProxyInfo().isSetProxyScheme()) {
                    this.printField("Https Site Proxy Scheme: ", webServer.getSsl().getProxyInfo().getProxyScheme());
                }
            }
        }
        if (webServer.isSetAjp13()) {
            this.printField("Ajp13 Bind   : ", webServer.getAjp13().getBind());
        }
    }

    private void addP4ClientInfo() {
        if (this.config.isSetP4Config() && this.config.getP4Config().isSetP4Location()) {
            this.printField("P4 Client Location : ", this.config.getP4Config().getP4Location());
        }
    }

    private void addSvnLibraryInfo() {
        if (this.config.isSetSvnConfig()) {
            if (this.config.getSvnConfig().isSetJar()) {
                this.printField("Subversion Client Jar :", this.config.getSvnConfig().getJar());
            }
            if (this.config.getSvnConfig().isSetJnilib()) {
                this.printField("Subversion Client Libraries : ", this.config.getSvnConfig().getJnilib());
            }
        }
    }

    private void addDebugState() {
        this.printField("Debug Enabled   : ", Logs.APP_LOG.isDebugEnabled());
    }

    private void addFileDescriptorInfo() {
        SystemResourceMonitor systemResourceMonitor = SpringContext.getComponent(SystemResourceMonitor.class, "SystemResourceMonitor");
        Long maxFileDescriptors = systemResourceMonitor.getMaxFileDescriptorCount();
        this.printField("Max file descriptors  : ", maxFileDescriptors == null ? "unavailable" : maxFileDescriptors.toString());
        Long openFileDescriptors = systemResourceMonitor.getOpenFileDescriptorCount();
        this.printField("Open file descriptors : ", openFileDescriptors == null ? "unavailable" : openFileDescriptors.toString());
    }

    private void addMemoryInfo() {
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        this.printField("Total Memory    : ", LargeNumberFormatter.formatValue(new DecimalFormat("###"), totalMemory));
        this.printField("Free Memory     : ", LargeNumberFormatter.formatValue(new DecimalFormat("###"), freeMemory));
        if (totalMemory == 0L) {
            this.printField("Memory Usage    : ", "100%");
        } else {
            DecimalFormat pcf = new DecimalFormat("###%");
            this.printField("Memory Usage    : ", pcf.format((float)(totalMemory - freeMemory) / (float)totalMemory));
        }
    }

    private void addInputArgs() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeMXBean != null) {
            this.printField("JVM input args  : ", String.join((CharSequence)" ", runtimeMXBean.getInputArguments()));
        } else {
            this.printField("JVM input args  : ", "unknown");
        }
    }

    private void addEnvironment() {
        this.printField("FISHEYE_HOME    : ", AppConfig.getAppHome().getAbsolutePath());
        this.printField("FISHEYE_INST    : ", AppConfig.getInstanceDir().getAbsolutePath());
        this.printField("Java Version    : ", System.getProperty("java.version"));
        this.printField("Java Vendor     : ", System.getProperty("java.vendor"));
        this.printField("JVM Version     : ", System.getProperty("java.vm.specification.version"));
        this.printField("JVM Vendor      : ", System.getProperty("java.vm.specification.vendor"));
        this.printField("JVM Impl        : ", System.getProperty("java.vm.version"));
        this.printField("Java Runtime    : ", System.getProperty("java.runtime.name"));
        this.printField("Operating System: ", System.getProperty("os.name") + " " + System.getProperty("os.version"));
        this.printField("OS Architecture : ", System.getProperty("os.arch"));
        this.printField("User Timezone   : ", System.getProperty("user.timezone"));
    }

    private FisheyeVersionInfo addVersionInfo() {
        if (AppConfig.isFishEye()) {
            this.printField("FishEye ", this.feInfo.getReleaseNum() + " " + this.feInfo.getBuildNumber());
        }
        if (AppConfig.isCrucible()) {
            CrucibleVersionInfo cruInfo = new CrucibleVersionInfo();
            this.printField("Crucible ", cruInfo.getReleaseNum() + " " + this.feInfo.getBuildNumber());
        }
        if (this.feInfo.getLicense() != null && this.feInfo.getLicense().isJspSourceEdition()) {
            this.println(" JSP source edition");
        }
        if (this.feInfo.getLicense() == null) {
            this.println(" No license configured");
        }
        return this.feInfo;
    }
}

