/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.fisheye.svn.Svn2Utils;
import com.cenqua.fisheye.ctl.VerifySvnSymbolicRules;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnConstants;
import com.cenqua.fisheye.svn.SvnLogMessage;
import com.cenqua.fisheye.svn.SvnRepositoryInfo;
import com.cenqua.fisheye.svn.SvnThrottledClient;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import org.apache.subversion.javahl.callback.LogMessageCallback;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;

class SvnInfoRunner {
    private final BlockingQueue<SvnLogMessage> suspectedSvnCopyOperationsQueue;
    private final SvnRepositoryInfo svnRepositoryInfo;
    private final SvnThrottledClient svnClient;
    private final Revision startRevision;
    private final Revision endRevision;
    private static final String NL = System.getProperty("line.separator");
    public static final SvnLogMessage SENTINEL = new SvnLogMessage(-1L, null);

    SvnInfoRunner(BlockingQueue<SvnLogMessage> suspectedSvnCopyOperationsQueue, SvnRepositoryInfo svnRepositoryInfo, SvnThrottledClient svnClient, String startRevision, String endRevision) throws VerifySvnSymbolicRules.UserReportableException {
        this.suspectedSvnCopyOperationsQueue = suspectedSvnCopyOperationsQueue;
        this.svnRepositoryInfo = svnRepositoryInfo;
        this.svnClient = svnClient;
        this.startRevision = this.parseRevision(startRevision, "START", Revision.getInstance((long)svnRepositoryInfo.getStartRev()));
        this.endRevision = this.parseRevision(endRevision, "HEAD", Revision.HEAD);
    }

    private Revision parseRevision(String revisionStr, String symbolic, Revision symbolicValue) throws VerifySvnSymbolicRules.UserReportableException {
        if (Strings.isNullOrEmpty((String)revisionStr) || symbolic.equalsIgnoreCase(revisionStr)) {
            return symbolicValue;
        }
        try {
            return Revision.getInstance((long)Long.parseLong(revisionStr));
        }
        catch (NumberFormatException nfe) {
            throw new VerifySvnSymbolicRules.UserReportableException("Failed to parse revision number: " + revisionStr);
        }
    }

    void spawnSvnInfoThread() throws RepositoryClientException {
        Logs.APP_LOG.info((Object)("Processing svn log for a revision range: " + this.toString(this.startRevision) + " ... " + this.toString(this.endRevision)));
        Thread workerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    List<RevisionRange> revRanges = Svn2Utils.createRevisionRange(SvnInfoRunner.this.startRevision, SvnInfoRunner.this.endRevision);
                    SvnInfoRunner.this.svnClient.logMessages(SvnInfoRunner.this.svnRepositoryInfo.getLatestRepositoryRoot(), SvnInfoRunner.this.endRevision, revRanges, !SvnInfoRunner.this.svnRepositoryInfo.isFollowBaseHistory(), true, false, SvnConstants.STD_REVPROPS, 0L, new Callback());
                    SvnInfoRunner.this.sendPoison();
                }
                catch (RepositoryClientException e2) {
                    Logs.APP_LOG.error((Object)e2.getMessage(), e2.getCause());
                    throw new RuntimeException("Failed to run svn command", e2);
                }
                catch (InterruptedException e3) {
                    throw new RuntimeException("Interrupted on poison message", e3);
                }
            }
        }, SvnInfoRunner.class.getSimpleName());
        workerThread.setDaemon(true);
        workerThread.start();
    }

    private String toString(Revision revision) {
        if (revision == Revision.START) {
            return "START";
        }
        return revision.toString();
    }

    private void sendPoison() throws InterruptedException {
        this.suspectedSvnCopyOperationsQueue.put(SENTINEL);
    }

    private class Callback
    implements LogMessageCallback {
        private final StringBuilder sb = new StringBuilder();

        private Callback() {
        }

        public void singleMessage(Set<ChangePath> changePaths, long revision, Map<String, byte[]> revprops, boolean hasChildren) {
            if (Logs.APP_LOG.isDebugEnabled()) {
                this.sb.setLength(0);
                this.sb.append("svn info out: rev=").append(revision).append(", hasChildren=").append(hasChildren).append(", paths=");
                this.dumpPaths(changePaths);
                Logs.APP_LOG.debug((Object)this.sb.toString());
            }
            if (null == changePaths) {
                return;
            }
            LinkedHashSet suspectedPaths = Sets.newLinkedHashSet();
            for (ChangePath cp : changePaths) {
                if (null == cp.getCopySrcPath()) continue;
                suspectedPaths.add(cp);
            }
            if (!suspectedPaths.isEmpty()) {
                try {
                    SvnInfoRunner.this.suspectedSvnCopyOperationsQueue.put(new SvnLogMessage(suspectedPaths, revision, null));
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException("Interrupted", e2);
                }
            }
        }

        private void dumpPaths(Set<ChangePath> changedPaths) {
            if (null == changedPaths) {
                return;
            }
            for (ChangePath cp : changedPaths) {
                this.sb.append(NL).append("  ").append(cp.getAction()).append(" ").append(cp.getPath()).append(" ").append(cp.getNodeKind().toString());
                if (null == cp.getCopySrcPath()) continue;
                this.sb.append(" (copied from ").append(cp.getCopySrcPath()).append('@').append(cp.getCopySrcRevision()).append(')');
            }
        }
    }
}

