/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.crucible.maintenance.MaintenanceManager;
import com.atlassian.crucible.migration.BackupManager;
import com.atlassian.crucible.migration.WriterProgressMonitor;
import com.atlassian.fisheye.web.NetworkLocation;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.ctl.InstanceLock;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.WebServer;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class ShutdownService {
    public static final int DEFAULT_LINGER_SECONDS = 20;
    private final NetworkLocation mBind;
    private final InstanceLock mLock;
    private boolean mStopping = false;
    private String mControlKey = "cenqua";
    private static final int FAILURE_CODE = 1;
    private ServerSocket mSvr;
    private WebServer mWS;
    private static final int REINDEX_CHECK_DELAY = 100;
    private static final int REINDEX_FEEDBACK_DELAY = 60000;
    private final Thread shutdownHookThread = new Thread(){

        @Override
        public void run() {
            ShutdownService.this.stopImpl();
        }
    };

    public ShutdownService(NetworkLocation bind, InstanceLock lock) {
        this.mBind = bind;
        this.mLock = lock;
    }

    public void start() throws IOException {
        this.mSvr = new ServerSocket(this.mBind.getPort(), 0, this.mBind.getInetAddress());
        Runnable srvRunner = new Runnable(){

            @Override
            public void run() {
                ShutdownService.this.runServer();
            }
        };
        Thread srvThread = new Thread(srvRunner, "FishEye Shutdown Service");
        srvThread.setDaemon(true);
        srvThread.start();
        Runtime.getRuntime().addShutdownHook(this.shutdownHookThread);
    }

    private void runServer() {
        Logs.APP_LOG.debug((Object)("listening on " + this.mBind));
        block5: while (true) {
            try {
                while (!this.mStopping) {
                    final Socket socket = this.mSvr.accept();
                    Logs.APP_LOG.debug((Object)("Socket timeout is " + socket.getSoTimeout()));
                    try {
                        Thread commandThread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ShutdownService.this.handleClient(socket);
                            }
                        });
                        commandThread.start();
                        continue block5;
                    }
                    catch (RuntimeException e2) {
                        Logs.APP_LOG.error((Object)"unexpected exception", (Throwable)e2);
                    }
                    catch (Error e3) {
                        Logs.APP_LOG.error((Object)"unexpected error", (Throwable)e3);
                    }
                }
                break;
            }
            catch (IOException e4) {
                if (this.mStopping) break;
                Logs.APP_LOG.warn((Object)"shutdown socket disabled", (Throwable)e4);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClient(Socket socket) {
        block28: {
            try {
                socket.setTcpNoDelay(true);
                socket.setSoLinger(true, 20);
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(socket.getInputStream()));
                OutputStream out = socket.getOutputStream();
                String key = lin.readLine();
                if (!this.mControlKey.equals(key)) {
                    Logs.APP_LOG.warn((Object)("invalid control key from " + socket.getInetAddress()));
                    return;
                }
                String cmd = lin.readLine();
                try {
                    if ("stop".equals(cmd)) {
                        try {
                            this.handleStop(out);
                            ShutdownService.close(socket);
                            ShutdownService.close(this.mSvr);
                            break block28;
                        }
                        finally {
                            System.exit(0);
                        }
                    }
                    if ("fullscan".equals(cmd)) {
                        this.fullscan(lin, out);
                        break block28;
                    }
                    if ("reindex".equals(cmd)) {
                        this.reindex(lin, out, false);
                        break block28;
                    }
                    if ("reindexsync".equals(cmd)) {
                        this.reindex(lin, out, true);
                        break block28;
                    }
                    if ("rescan".equals(cmd)) {
                        this.rescan(lin, out);
                        break block28;
                    }
                    if ("scannow".equals(cmd)) {
                        this.scannow(lin, out, false);
                        break block28;
                    }
                    if ("scansync".equals(cmd)) {
                        this.scannow(lin, out, true);
                        break block28;
                    }
                    if ("backup".equals(cmd)) {
                        this.backup(lin, out);
                        break block28;
                    }
                    Logs.APP_LOG.warn((Object)("unknown command " + cmd + " from " + socket.getInetAddress()));
                    this.sendStatus(out, 1);
                }
                catch (IOException e2) {
                    Logs.APP_LOG.warn((Object)("Problem with command: " + cmd + "."), (Throwable)e2);
                    this.sendOutput(out, e2.getMessage());
                    this.sendStatus(out, 1);
                }
            }
            catch (IOException e3) {
                Logs.APP_LOG.warn((Object)("problem on control socket from " + socket.getInetAddress()), (Throwable)e3);
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException e4) {
                    Logs.APP_LOG.error((Object)"Unable to close socket");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescan(LineNumberReader lin, OutputStream out) throws IOException {
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        String repname = lin.readLine();
        String start = lin.readLine();
        String end = lin.readLine();
        RepositoryHandle h2 = rm.getRepository(repname);
        if (h2 == null) {
            this.sendOutput(out, "The repository " + repname + " could not be found");
            this.sendStatus(out, 1);
        } else {
            Disposer.pushThreadInstance();
            try {
                h2.rescan(start, end);
                this.sendOutput(out, "Rescan requested");
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)("Problem requesting rescan: " + e2.getMessage()), (Throwable)e2);
                this.sendOutput(out, e2.getClass().getName() + ":" + e2.getMessage());
                this.sendStatus(out, 1);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    private void scannow(LineNumberReader lin, OutputStream out, boolean synchronous) throws IOException {
        List<RepositoryHandle> reps = this.parseRepositoriesFromArgs(lin, out);
        for (RepositoryHandle h2 : reps) {
            if (h2.isRunning()) {
                if (synchronous) {
                    this.sendOutput(out, "Scan started: " + h2.getName());
                } else {
                    this.sendOutput(out, "Scan requested: " + h2.getName());
                }
                try {
                    h2.oneOffScan(synchronous);
                }
                catch (RepositoryHandle.StateException e2) {
                    this.sendOutput(out, "Repository " + h2.getName() + " is no longer running - scan request ignored");
                }
                continue;
            }
            this.sendOutput(out, "Repository " + h2.getName() + " is not running");
            Logs.APP_LOG.warn((Object)("cannot scan stopped repository " + h2.getName()));
        }
        if (synchronous) {
            this.sendOutput(out, "Done");
        }
    }

    private void backup(LineNumberReader lin, OutputStream out) throws IOException {
        String line;
        Logs.APP_LOG.info((Object)"Creating backup.");
        HashMap<String, String> params = new HashMap<String, String>();
        while ((line = lin.readLine()) != null && !"".equals(line)) {
            String[] param = line.split(":", 2);
            params.put(param[0].trim(), param.length == 2 ? param[1].trim() : null);
        }
        OutputStreamWriter writer = new OutputStreamWriter(out);
        WriterProgressMonitor monitor = new WriterProgressMonitor(writer);
        File f2 = params.containsKey("file") ? new File((String)params.get("file")) : null;
        List<String> include = params.containsKey("include") ? Arrays.asList(((String)params.get("include")).trim().split("(\\s*,\\s*)|\\s+")) : Collections.emptyList();
        SpringContext.getComponentByClass(BackupManager.class).createBackupAtLocation(f2, include, params, monitor);
        ((Writer)writer).flush();
    }

    private void sendStatus(OutputStream out, int status) throws IOException {
        this.sendOutput(out, this.mControlKey);
        this.sendOutput(out, status + "");
    }

    private void sendOutput(OutputStream out, String message) throws IOException {
        out.write((message + "\r\n").getBytes());
        out.flush();
    }

    private void handleStop(OutputStream out) throws IOException {
        this.stopImpl();
        this.sendOutput(out, "FishEye Shutdown successfully");
    }

    private void stopImpl() {
        this.mStopping = true;
        Logs.APP_LOG.info((Object)"Shutdown requested");
        try {
            if (Thread.currentThread() != this.shutdownHookThread) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
            }
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Failed to remove shutdown hook", (Throwable)e2);
        }
        AppConfig.getsConfig().shutDownRepositories();
        if (SpringContext.isSetup()) {
            MaintenanceManager maintenanceManager = (MaintenanceManager)SpringContext.getComponent("maintenanceManager");
            maintenanceManager.setMessage("Shutdown in progress");
            maintenanceManager.setDownForMaintenance(true);
            if (this.mWS != null) {
                this.mWS.stop();
            }
        }
        AppConfig.getsConfig().closeDB();
        this.mLock.release();
    }

    public void stop() {
        this.stopImpl();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullscan(LineNumberReader lin, OutputStream out) throws IOException {
        List<RepositoryHandle> reps = this.parseRepositoriesFromArgs(lin, out);
        Disposer.pushThreadInstance();
        try {
            for (RepositoryHandle h2 : reps) {
                if (h2.isRunning()) {
                    try {
                        h2.acquireEngine().requestFullscan();
                    }
                    catch (RepositoryHandle.StateException e2) {
                        Logs.APP_LOG.warn((Object)("cannot fullscan stopped repository " + h2.getName()), (Throwable)((Object)e2));
                        this.sendStatus(out, 1);
                    }
                    continue;
                }
                Logs.APP_LOG.warn((Object)("cannot fullscan stopped repository " + h2.getName()));
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex(LineNumberReader lin, OutputStream out, boolean synchronous) throws IOException {
        List<RepositoryHandle> reps = this.parseRepositoriesFromArgs(lin, out);
        Disposer.pushThreadInstance();
        try {
            for (RepositoryHandle rh : reps) {
                String msg;
                boolean wasRunning = rh.isRunning();
                if (!rh.tryStop(20000L)) {
                    String msg2 = "Could not stop repository '" + rh.getName() + "' within 20 seconds. Re-index aborted.";
                    Logs.APP_LOG.error((Object)msg2);
                    this.sendOutput(out, msg2);
                    this.sendStatus(out, 1);
                    continue;
                }
                try {
                    rh.deleteIndex();
                }
                catch (RepositoryHandle.StateException e2) {
                    msg = "Could not delete cache for repository '" + rh.getName() + "': " + e2.getMessage();
                    Logs.APP_LOG.error((Object)msg);
                    this.sendOutput(out, msg);
                    this.sendStatus(out, 1);
                    continue;
                }
                if (wasRunning) {
                    try {
                        AppConfig.getsConfig().getRepositoryManager().runRepository(rh.getName());
                    }
                    catch (Exception e3) {
                        msg = "Could not restart repository '" + rh.getName() + "': " + e3.getMessage();
                        Logs.APP_LOG.warn((Object)msg);
                        this.sendOutput(out, msg);
                        this.sendStatus(out, 1);
                    }
                }
                if (!synchronous) continue;
                this.sendOutput(out, "Reindex started: " + rh.getName());
                int feedbackIt = 600;
                int i2 = 0;
                while (!rh.getStatus().isInitialCrucibleIndexingComplete()) {
                    try {
                        Thread.sleep(100L);
                        if (++i2 <= feedbackIt) continue;
                        String msg3 = rh.getStatus().getMessage();
                        if (msg3.length() > 0) {
                            this.sendOutput(out, msg3);
                        }
                        i2 = 0;
                    }
                    catch (InterruptedException e4) {
                        // empty catch block
                        break;
                    }
                }
                this.sendOutput(out, "Done");
            }
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private List<RepositoryHandle> parseRepositoriesFromArgs(LineNumberReader lin, OutputStream out) throws IOException {
        String repname;
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        List<RepositoryHandle> reps = new LinkedList<RepositoryHandle>();
        boolean zeroArgs = true;
        while (null != (repname = lin.readLine()) && !repname.trim().equals("")) {
            RepositoryHandle h2 = rm.getRepository(repname);
            zeroArgs = false;
            if (h2 != null) {
                reps.add(h2);
                continue;
            }
            String msg = "could not find repository '" + repname + "' specified as argument";
            Logs.APP_LOG.warn((Object)msg);
            this.sendOutput(out, msg);
            this.sendStatus(out, 1);
        }
        if (zeroArgs) {
            reps = rm.getHandles();
        }
        return reps;
    }

    private static void close(ServerSocket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void close(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setWebServer(WebServer ws) {
        this.mWS = ws;
    }
}

