/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.crucible.activity.lucene.DefaultReviewItemIndexer;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.fecru.upgrade.DefaultUpgradeManager;
import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.event.ApplicationStartedEventImpl;
import com.atlassian.fisheye.quartz.QuartzManager;
import com.atlassian.fisheye.web.NetworkLocation;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.IndexingOptions;
import com.cenqua.fisheye.ctl.BaseCommand;
import com.cenqua.fisheye.ctl.InstanceLock;
import com.cenqua.fisheye.ctl.NativeLibrarySetup;
import com.cenqua.fisheye.ctl.OptimizeIndexes;
import com.cenqua.fisheye.ctl.ShutdownService;
import com.cenqua.fisheye.ctl.SystemInfoMessage;
import com.cenqua.fisheye.infinitydb.InfinityDbUtil;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.WebServer;
import com.cenqua.obfuscate.idb.m;
import com.cenqua.obfuscate.idb.y;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.velocity.app.Velocity;
import org.eclipse.jetty.util.MultiException;

public class Run
extends BaseCommand {
    private static final Pattern SUPPORTED_JVMS = Pattern.compile("1\\.[8].*");
    private static final String SUPPORTED_JVMS_DESCRIPTION = "1.8";
    private static final List<String> earlyLog = new LinkedList<String>();

    public static void main(String[] args) {
        int rc = Run.mainImpl(args);
        if (rc != 0) {
            System.exit(rc);
        }
    }

    public static int mainImpl(String[] args) {
        WebServer ws;
        ShutdownService controlService;
        Run.initJVM();
        Run.setupLogging(false);
        InstanceLock lock = InstanceLock.acquireLock();
        if (lock == null) {
            Logs.APP_LOG.error((Object)("Another instance of " + AppConfig.getProductName() + " seems to be running"));
            return 1;
        }
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        if (!Run.handleCommonArguments(argList, System.err)) {
            return 1;
        }
        Run.sysinfo();
        NativeLibrarySetup.setup();
        InfinityDbUtil.logLicensingMessage();
        UpgradeManager upgradeManager = DefaultUpgradeManager.getInstance();
        RootConfig rootConfig = AppConfig.getsConfig();
        if (!AppConfig.getConfigurationFile().isFile()) {
            Logs.APP_LOG.info((Object)String.format("Configuration file not found: %s. Creating default configuration.", AppConfig.getConfigurationFile()));
            File defaultConfig = new File(AppConfig.getAppHome(), "config.xml");
            String msg = "config file from " + defaultConfig.getAbsolutePath() + " to " + AppConfig.getConfigurationFile().getAbsolutePath();
            try {
                FileUtils.copyFile((File)defaultConfig, (File)AppConfig.getConfigurationFile());
                if (!AppConfig.getConfigurationFile().isFile()) {
                    Logs.APP_LOG.error((Object)("Failed to copy " + msg));
                    return 1;
                }
                Logs.APP_LOG.info((Object)("Successfully copied " + msg));
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)("Failed to copy " + msg), (Throwable)e2);
                return 1;
            }
        }
        try {
            rootConfig.load(AppConfig.getConfigurationFile());
        }
        catch (IOException e3) {
            Logs.APP_LOG.error((Object)("Problem reading config file: " + e3.getMessage()), (Throwable)e3);
            return 1;
        }
        catch (ConfigException e4) {
            Logs.APP_LOG.error((Object)("Problem with config file: " + e4.getMessage()), (Throwable)e4);
            return 1;
        }
        if (!upgradeManager.preUpgradeCheck(rootConfig)) {
            return 1;
        }
        upgradeManager.upgradeRootConfig(rootConfig);
        String sid = rootConfig.getConfig().getLicense().getSID();
        Run.loadAndLogLicense();
        LicenseInfo license = rootConfig.getLicense();
        if (license != null) {
            Logs.APP_LOG.info((Object)license.getOwnerStatement());
            if (license.isFishEye()) {
                Logs.APP_LOG.debug((Object)("FishEye SEN: " + license.getFisheyeLicense().getSupportEntitlementNumber()));
            }
            if (license.isCrucible()) {
                Logs.APP_LOG.debug((Object)("Crucible SEN: " + license.getCrucibleLicense().getSupportEntitlementNumber()));
            }
            if (license.isGracePeriodExpired()) {
                Logs.APP_LOG.info((Object)("Your license has been terminated (" + DateHelper.toGmtString(license.getSoftExpiryValue()) + ")."));
                Logs.APP_LOG.info((Object)("Please visit http://my.atlassian.com and quote " + sid + " to obtain a valid license."));
            } else if (license.isExpired()) {
                Logs.APP_LOG.info((Object)("Your license has expired (" + DateHelper.toGmtString(license.getSoftExpiryValue()) + ")."));
                Logs.APP_LOG.info((Object)("Please visit http://my.atlassian.com and quote " + sid + " to obtain a valid license."));
            } else if (license.expires()) {
                Logs.APP_LOG.info((Object)("Your license expires in " + DateHelper.age(license.getSoftExpiry(), System.currentTimeMillis())));
            }
        }
        if (Run.optimizeIndexesOnStart()) {
            new OptimizeIndexes().run();
        }
        try {
            rootConfig.start();
        }
        catch (IOException e5) {
            Logs.APP_LOG.error((Object)("Problem reading config file: " + e5.getMessage()));
            Logs.APP_LOG.info((Object)"IOE", (Throwable)e5);
            return 1;
        }
        catch (ConfigException e6) {
            Logs.APP_LOG.error((Object)("Problem with config file: " + e6.getMessage()));
            Logs.APP_LOG.info((Object)"CE", (Throwable)e6);
            return 1;
        }
        catch (DbException e7) {
            Logs.APP_LOG.error((Object)("Problem starting " + AppConfig.getProductName() + ": " + e7.getMessage()));
            Logs.APP_LOG.info((Object)"DBE", (Throwable)e7);
            return 1;
        }
        upgradeManager.upgradeRootData(rootConfig);
        if (AppConfig.noSlurp) {
            RepositoryManager repositoryManager = rootConfig.getRepositoryManager();
            for (RepositoryHandle rep : repositoryManager.getHandles()) {
                rep.setDisableBackgroundUpdaterOnInit(AppConfig.noSlurp);
            }
        }
        String ctlBind = rootConfig.getControlBind();
        try {
            controlService = new ShutdownService(new NetworkLocation(ctlBind), lock);
        }
        catch (IOException e8) {
            Logs.APP_LOG.error((Object)("Unknown host error binding control port: " + e8.getMessage()));
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e8);
            return 1;
        }
        catch (IllegalArgumentException e9) {
            Logs.APP_LOG.error((Object)("Invalid host/port when binding control port: " + e9.getMessage()));
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e9);
            return 1;
        }
        AppConfig.setShutdown(controlService);
        try {
            ws = new WebServer();
        }
        catch (UnknownHostException e10) {
            Logs.APP_LOG.error((Object)("Unknown host error binding web port: " + e10.getMessage()));
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e10);
            return 1;
        }
        catch (Exception e11) {
            Logs.APP_LOG.error((Object)("Could not create webserver: " + e11.getMessage()));
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e11);
            return 1;
        }
        AppConfig.setWebServer(ws);
        controlService.setWebServer(ws);
        try {
            Logs.APP_LOG.debug((Object)"starting control server...");
            controlService.start();
        }
        catch (BindException e12) {
            Logs.APP_LOG.error((Object)("Could not bind control port '" + ctlBind + "' :  " + e12.getMessage()));
            return 1;
        }
        catch (Exception e13) {
            Logs.APP_LOG.error((Object)("Could not create control server: " + e13.getMessage()));
            return 1;
        }
        try {
            Logs.APP_LOG.debug((Object)"starting server...");
            ws.start();
        }
        catch (BindException e14) {
            Logs.APP_LOG.error((Object)("Could not start server, one of the ports is taken: " + ws.getDesc() + ": " + e14.getMessage()), (Throwable)e14);
            return 1;
        }
        catch (Exception e15) {
            Logs.APP_LOG.debug((Object)"startup stacktrace", (Throwable)e15);
            Run.logStartupException(e15);
            return 1;
        }
        if (!SpringContext.isSetup()) {
            Logs.APP_LOG.debug((Object)"The Spring context could not start. Aborting.");
            return 1;
        }
        Logs.APP_LOG.info((Object)("Server started on " + ws.getDesc() + " (control port on " + ctlBind + ")"));
        Logs.setConsoleLevel((Priority)Level.WARN);
        Run.printSystemInfo(rootConfig);
        DefaultReviewItemIndexer.doStart();
        upgradeManager.startBackgroundTasks();
        rootConfig.startRepositories(false);
        try {
            QuartzManager quartzManager = (QuartzManager)SpringContext.getComponent("quartzManager");
            quartzManager.start();
        }
        catch (Exception e16) {
            Logs.APP_LOG.error((Object)("Could not start quartz schedule: " + e16.getMessage()), (Throwable)e16);
            return 1;
        }
        EventPublisher eventPublisher = (EventPublisher)SpringContext.getComponent("eventPublisher");
        eventPublisher.publish((Object)new ApplicationStartedEventImpl());
        return 0;
    }

    private static void loadAndLogLicense() {
        RootConfig rootConfig = AppConfig.getsConfig();
        String sid = rootConfig.getConfig().getLicense().getSID();
        if (!rootConfig.getAdminConfig().haveDoneInitialSetup()) {
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)"=======================================================");
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)("Welcome to " + AppConfig.getDownloadProductName() + "!"));
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)"You need to configure an admin password and enter your");
            Logs.APP_LOG.info((Object)"license key. You can do this by accessing FishEye through");
            Logs.APP_LOG.info((Object)"a web browser, once the server has started:");
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)rootConfig.getSiteURL());
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)("Refer to the " + AppConfig.getDownloadProductName() + " administration guide"));
            Logs.APP_LOG.info((Object)"for more information:");
            Logs.APP_LOG.info((Object)"");
            if (AppConfig.isFisheyeDownload()) {
                Logs.APP_LOG.info((Object)"https://confluence.atlassian.com/display/FISHEYE/Starting+to+use+FishEye");
            } else {
                Logs.APP_LOG.info((Object)"https://confluence.atlassian.com/display/CRUCIBLE/Starting+to+use+Crucible");
            }
            Logs.APP_LOG.info((Object)"");
            Logs.APP_LOG.info((Object)"=======================================================");
            Logs.APP_LOG.info((Object)"");
        }
        try {
            rootConfig.loadLicense();
        }
        catch (LicenseException e2) {
            if (rootConfig.getAdminConfig().haveDoneInitialSetup()) {
                Logs.APP_LOG.error((Object)e2.getMessage());
                Logs.APP_LOG.error((Object)"Please visit http://my.atlassian.com to retrieve an existing");
                Logs.APP_LOG.error((Object)("license quote " + sid + " to obtain a new license"));
                Logs.APP_LOG.error((Object)"or visit http://www.atlassian.com/fisheye/renew to renew ");
                Logs.APP_LOG.error((Object)"your license.");
                Logs.APP_LOG.info((Object)"Exception loading license", (Throwable)e2);
            }
            Logs.APP_LOG.info((Object)("Your Server ID is " + sid));
            Logs.APP_LOG.debug((Object)"Exception loading license", (Throwable)e2);
        }
    }

    private static boolean optimizeIndexesOnStart() {
        IndexingOptions indexes;
        ConfigDocument.Config config = AppConfig.getsConfig().getConfig();
        if (config.isSetIndexingOptions() && (indexes = config.getIndexingOptions()).isSetOptimizeIndexesOnNextStartup()) {
            indexes.unsetOptimizeIndexesOnNextStartup();
            Run.saveConfig();
            return true;
        }
        return false;
    }

    public static void printSystemInfo(RootConfig rootConfig) {
        SystemInfoMessage sysInfo = new SystemInfoMessage(rootConfig);
        Logs.APP_LOG.info((Object)sysInfo.getMessage());
    }

    private static void saveConfig() {
        try {
            AppConfig.getsConfig().saveConfig();
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Could not save config", (Throwable)e2);
        }
    }

    private static void logStartupException(Throwable e2) {
        if (e2 instanceof MultiException) {
            MultiException me = (MultiException)e2;
            for (Object o2 : me.getThrowables()) {
                Throwable ne = (Throwable)o2;
                Run.logStartupException(ne);
            }
        } else {
            Logs.APP_LOG.error((Object)("Could not start server: " + e2.getMessage()), e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initJVM() {
        Run.setLibraryProperties();
        File f2 = new File(AppConfig.getInstanceDir(), "system.properties");
        if (f2.isFile()) {
            earlyLog.add("Loading custom system.properties " + f2);
            FileInputStream in = null;
            try {
                in = new FileInputStream(f2);
                System.getProperties().load(in);
            }
            catch (Exception e2) {
                try {
                    String msg = "WARN: problem loading custom system properties " + f2 + " : " + e2.getMessage();
                    earlyLog.add(msg);
                    System.err.println(msg);
                    e2.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOHelper.close(in);
                    throw throwable;
                }
                IOHelper.close(in);
            }
            IOHelper.close(in);
        }
    }

    public static void setLibraryProperties() {
        System.setProperty("net.sf.ehcache.skipUpdateCheck", "true");
        System.setProperty("com.bluecast.xml.ValidatingSAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        try {
            Toolkit.getDefaultToolkit();
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (Throwable e2) {
            Logs.APP_LOG.warn((Object)"Problem initing graphics environment, images may not render", e2);
        }
        Velocity.setProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
        y.c(0);
        m.a(false);
        System.setProperty("events.remote.ratelimit.maxTokens", "100");
        System.setProperty("org.apache.jasper.compiler.disablejsr199", "true");
        System.setProperty("atlassian.darkfeature.atlassian.rest.xsrf.legacy.enabled", "true");
    }

    private static void sysinfo() {
        Logs.APP_LOG.info((Object)"FishEye/Crucible 4.0.4 (20160506105158), Built on 2016-05-06");
        if (!earlyLog.isEmpty()) {
            for (String msg : earlyLog) {
                Logs.APP_LOG.info((Object)("earlier: " + msg));
            }
            earlyLog.clear();
        }
        long maxmem = Runtime.getRuntime().maxMemory();
        Logs.APP_LOG.info((Object)("Logging started (" + System.getProperty("java.vm.vendor", "-") + "|" + System.getProperty("java.vm.version", "-") + "|" + System.getProperty("java.home", "-") + "|" + System.getProperty("os.name", "-") + "|" + System.getProperty("os.arch", "-") + "|" + System.getProperty("os.version", "-") + "|" + "maxmem=" + (maxmem == Long.MAX_VALUE ? "nolimit" : maxmem / 1024L / 1024L + "MB") + ")"));
        Run.warnOnUnsupportedJavaVersion();
    }

    protected static void warnOnUnsupportedJavaVersion() {
        String version = System.getProperty("java.version");
        if (!SUPPORTED_JVMS.matcher(version).matches()) {
            Logs.APP_LOG.warn((Object)("Unsupported java version detected: " + version));
            Logs.APP_LOG.warn((Object)"Currently supported versions: 1.8");
            Logs.APP_LOG.warn((Object)"Running with your current version may be unstable.");
        }
    }
}

