/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.ConnectionType;
import com.cenqua.fisheye.config1.DatabaseType;
import com.cenqua.fisheye.config1.DriverSource;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.xmlbeans.XmlOptions;

public class RestoreConfig {
    private final ZipFile backupZip;
    private final Map<String, String> properties;
    private final ProgressMonitor monitor;
    private boolean dbConfigOverriden;

    public RestoreConfig(ZipFile backupZip, Map<String, String> properties, ProgressMonitor monitor) {
        this.backupZip = backupZip;
        this.properties = properties;
        this.monitor = monitor;
    }

    public ConfigDocument getConfigFromBackup() throws IOException, FileNotFoundException {
        ZipEntry entry;
        String separator = this.properties.get("restorer.file.separator");
        if (separator == null) {
            separator = "/";
        }
        if ((entry = this.backupZip.getEntry("config" + separator + "config.xml")) != null) {
            try (InputStream in = this.backupZip.getInputStream(entry);){
                ConfigDocument extracted = RootConfig.parseDocument(in, new XmlOptions());
                this.overrideDatabaseConfig(extracted);
                ConfigDocument configDocument = extracted;
                return configDocument;
            }
        }
        this.monitor.update(Message.newWarning("config.xml not found in archive."));
        throw new FileNotFoundException("config.xml not found in archive.");
    }

    private void overrideDatabaseConfig(ConfigDocument config) throws MalformedURLException {
        if (this.properties.containsKey("sql.dbtype")) {
            this.dbConfigOverriden = true;
            String jdbcType = this.properties.get("sql.dbtype");
            if (DBType.HSQL.getConfigEnumName().equals(jdbcType)) {
                if (config.getConfig().isSetDatabase()) {
                    config.getConfig().unsetDatabase();
                }
            } else {
                DatabaseType.Type.Enum databaseType = DatabaseType.Type.Enum.forString(jdbcType);
                ConnectionType conn = ConnectionType.Factory.newInstance();
                if (this.properties.containsKey("sql.jdbcurl")) {
                    conn.setJdbcurl(this.properties.get("sql.jdbcurl"));
                }
                if (this.properties.containsKey("sql.driver")) {
                    conn.setDriver(this.properties.get("sql.driver"));
                } else {
                    conn.setDriver(DBType.getForDatabaseType(databaseType).getDriver());
                }
                if (config.getConfig().isSetDatabase() && config.getConfig().getDatabase().getConnection().isSetDialect() && databaseType == config.getConfig().getDatabase().getType()) {
                    conn.setDialect(config.getConfig().getDatabase().getConnection().getDialect());
                }
                if (this.properties.containsKey("sql.driversource")) {
                    conn.setDriverSource(DriverSource.Enum.forString(this.properties.get("sql.driversource")));
                } else {
                    conn.setDriverSource(DriverSource.BUNDLED);
                }
                if (!config.getConfig().isSetDatabase()) {
                    config.getConfig().addNewDatabase();
                }
                config.getConfig().getDatabase().setType(databaseType);
                config.getConfig().getDatabase().setConnection(conn);
            }
        }
        if (config.getConfig().isSetDatabase()) {
            ConnectionType conn = config.getConfig().getDatabase().getConnection();
            if (this.properties.containsKey("sql.username")) {
                this.dbConfigOverriden = true;
                conn.setUsername(this.properties.get("sql.username"));
            }
            if (this.properties.containsKey("sql.password")) {
                this.dbConfigOverriden = true;
                conn.setPassword(this.properties.get("sql.password"));
            }
        }
    }

    public boolean isDbConfigOverriden() {
        return this.dbConfigOverriden;
    }
}

