/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.crucible.migration.AbstractBackupManager;
import com.atlassian.crucible.migration.BackupException;
import com.atlassian.crucible.migration.BackupItem;
import com.atlassian.crucible.migration.NoOpProgressMonitor;
import com.atlassian.crucible.migration.PrintStreamProgressMonitor;
import com.atlassian.crucible.migration.ProgressMonitor;
import com.atlassian.crucible.migration.Restorer;
import com.atlassian.crucible.migration.item.Message;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.DatabaseType;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.ctl.BaseCommand;
import com.cenqua.fisheye.ctl.InstanceLock;
import com.cenqua.fisheye.ctl.RestoreConfig;
import com.google.common.base.Strings;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class Restore
extends BaseCommand {
    private static final String USAGE = "Usage: fisheyectl.sh restore -f FILE [OPTIONS] [BACKUP ITEMS]\n\nRestores a FishEye/Crucible backup instance.\nWhen using an external database, make sure the JDBC driver file is present in\nthe FISHEYE_INST/lib directory when running restore.\nThis command supports partial restores (e.g. use --cache to only restore the\ncaches). When no items are specified, everything is restored.\n\nOPTIONS:\n   -l, --list            list the contents of this backup and exit\n   -q, --quiet           suppress output\n   -f, --file FILE       restore the backup in FILE (required)\n   -h, --help            display this help and exit\n   -t, --dbtype          database type [" + Arrays.stream(DBType.values()).map(dbType -> dbType.getConfigEnumName()).collect(Collectors.joining("|")) + "]\n" + "                         (if specified the commandline jdbcurl, driver and driver-source params will be used instead of the backed up ones)\n" + "                         (if --dbtype=hsql, the following are ignored: --jdbcurl, --driver, --driver-source, --username, --password)\n" + "   -j, --jdbcurl         JDBC URL of the SQL database (requires --dbtype)\n" + "   -u, --username        JDBC username of the SQL database\n" + "   -p, --password        JDBC password of the SQL database\n" + "   -d, --driver          optional JDBC driver class of the SQL database (requires --dbtype)\n" + "   -s, --driver-source   optional JDBC driver source (requires --dbtype)\n" + "                         Either 'bundled' (default, use the bundled driver) or 'user' (use the driver from FISHEYE_INST/lib)\n" + "   --no-batch-sql        do not batch SQL inserts (can assist when diagnosing errors)\n" + "   --force               overwrite existing database without warning\n" + "\n" + "BACKUP ITEMS:\n" + AbstractBackupManager.items.entrySet().stream().filter(item -> !((BackupItem)item.getValue()).isMandatory()).map(item -> String.format("   --%-19s restore %s\n", item.getKey(), ((BackupItem)item.getValue()).getDescription())).collect(Collectors.joining());
    private boolean quiet = false;
    private String filename = null;
    private boolean list = false;
    private Set<String> includes = new HashSet<String>();
    private final Map<String, String> params = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int run(String ... args) {
        LinkedList<String> argsCopy = new LinkedList<String>(Arrays.asList(args));
        if (!Restore.overrideFishEyeInst(argsCopy, System.err)) {
            System.err.println(USAGE);
            return 1;
        }
        Restore.setupLogging(true);
        if (!Restore.handleCommonArguments(argsCopy, System.err) || !this.processArgs(argsCopy)) {
            System.err.println(USAGE);
            return 1;
        }
        try {
            ZipFile zip = new ZipFile(this.filename);
            if (this.list) {
                return this.list(zip);
            }
            InstanceLock lock = InstanceLock.acquireLock();
            if (lock == null) {
                System.err.println("FishEye appears to be running. Shutdown before running restore.");
                return 1;
            }
            FileSystemXmlApplicationContext applicationContext = null;
            boolean quiet = this.quiet;
            ProgressMonitor monitor = quiet ? NoOpProgressMonitor.INSTANCE : new PrintStreamProgressMonitor(System.out);
            try {
                ConfigDocument configFromBackup;
                Collection<String> itemsPresent = this.getItems(zip);
                this.params.put("restorer.file.separator", this.useBackslashSeparator(zip) ? "\\" : "/");
                if (this.includes.isEmpty()) {
                    this.includes = new HashSet<String>(itemsPresent);
                } else {
                    HashSet<String> tmp = new HashSet<String>();
                    for (String name : this.includes) {
                        if (!itemsPresent.contains(name)) {
                            System.err.println("Item not found in backup archive: " + name);
                            int n2 = 1;
                            return n2;
                        }
                        tmp.add(name);
                    }
                    this.includes = tmp;
                }
                monitor.update(new Message("Starting Spring Context..."));
                RootConfig rootConfig = AppConfig.getsConfig();
                try {
                    configFromBackup = new RestoreConfig(zip, this.params, monitor).getConfigFromBackup();
                }
                catch (FileNotFoundException e2) {
                    e2.printStackTrace();
                    System.err.println(String.format("Restore failed - no config.xml was found in the file backup file specified " + this.filename, new Object[0]));
                    int n3 = 1;
                    Restore.destroyApplicationContext();
                    lock.release();
                    return n3;
                }
                rootConfig.load(configFromBackup);
                rootConfig.setupDBDriver();
                applicationContext = Restore.createApplicationContext();
                monitor.update(new Message("Spring Context started"));
                ArrayList<Restorer> restorers = new ArrayList<Restorer>();
                boolean fail = false;
                for (Map.Entry<String, BackupItem> entry : AbstractBackupManager.items.entrySet()) {
                    String name = entry.getKey();
                    BackupItem item = entry.getValue();
                    try {
                        if (!item.isMandatory() && !this.includes.contains(name)) continue;
                        restorers.add(item.getRestorer(zip, monitor, this.params));
                    }
                    catch (BackupException be) {
                        monitor.update(Message.newWarning(be));
                        fail = true;
                    }
                }
                if (restorers.size() == 0) {
                    fail = true;
                    monitor.update(new Message("Nothing found to restore in file '" + this.filename + "'"));
                }
                if (!fail) {
                    Iterator<Map.Entry<String, BackupItem>> iterator = restorers.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            monitor.update(new Message("Backup restored successfully."));
                            int n4 = 0;
                            return n4;
                        }
                        Restorer r2 = (Restorer)((Object)iterator.next());
                        r2.restore();
                    }
                }
                int n5 = 1;
                return n5;
            }
            catch (ConfigException e3) {
                monitor.update(Message.newWarning("Invalid configuration file found in zip file"));
                int n6 = 1;
                return n6;
            }
            finally {
                Restore.destroyApplicationContext();
                lock.release();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.err.println(String.format("Restore failed. This may leave your target FISHEYE_INST directory (%s) in an inconsistent state.", AppConfig.getInstanceDir().getAbsolutePath()));
            return 1;
        }
    }

    private boolean useBackslashSeparator(ZipFile zip) {
        Enumeration en = zip.entries();
        while (en.hasMoreElements()) {
            String entry = ((ZipEntry)en.nextElement()).getName();
            if (!"config/config.xml".equals(entry) && !"config\\config.xml".equals(entry)) continue;
            return entry.indexOf(92) > 0;
        }
        return false;
    }

    private Collection<String> getItems(ZipFile zip) {
        HashSet<String> items = new HashSet<String>();
        Enumeration en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)en.nextElement();
            String base = new Path(entry.getName()).getComponent(0);
            if (Strings.isNullOrEmpty((String)base) || "backup.properties".equals(base)) continue;
            items.add(base);
        }
        return items;
    }

    private int list(ZipFile zip) throws IOException {
        ZipEntry meta = zip.getEntry("backup.properties");
        if (meta == null) {
            System.err.println("Not a valid " + AppConfig.getProductName() + " backup archive.");
            return 1;
        }
        Properties props = new Properties();
        props.load(zip.getInputStream(meta));
        for (Object key : props.keySet()) {
            System.out.println(key.toString() + ": " + props.get(key));
        }
        System.out.println("items: " + String.join((CharSequence)", ", this.getItems(zip)));
        return 0;
    }

    public static void main(String[] args) {
        System.exit(new Restore().run(args));
    }

    private boolean processArgs(List<String> args) {
        boolean exit = false;
        String key = null;
        try {
            while (!exit && args.size() > 0) {
                key = args.remove(0);
                if ("-q".equals(key) || "--quiet".equals(key)) {
                    this.quiet = true;
                    continue;
                }
                if ("-f".equals(key) || "--file".equals(key)) {
                    this.filename = args.remove(0);
                    continue;
                }
                if ("-j".equals(key) || "--jdbcurl".equals(key)) {
                    this.params.put("sql.jdbcurl", args.remove(0));
                    continue;
                }
                if ("-u".equals(key) || "--username".equals(key)) {
                    this.params.put("sql.username", args.remove(0));
                    continue;
                }
                if ("-p".equals(key) || "--password".equals(key)) {
                    this.params.put("sql.password", args.remove(0));
                    continue;
                }
                if ("-d".equals(key) || "--driver".equals(key)) {
                    this.params.put("sql.driver", args.remove(0));
                    continue;
                }
                if ("-s".equals(key) || "--driver-source".equals(key)) {
                    String driverSource = args.remove(0).toLowerCase();
                    if (DriverSource.Enum.forString(driverSource) == null) {
                        System.err.println("Invalid driver source '" + driverSource + "'.");
                        exit = true;
                        continue;
                    }
                    this.params.put("sql.driversource", driverSource);
                    continue;
                }
                if ("-t".equals(key) || "--dbtype".equals(key)) {
                    String type = args.remove(0).toLowerCase();
                    if ("built-in".equalsIgnoreCase(type)) {
                        this.params.put("sql.dbtype", DBType.HSQL.getConfigEnumName());
                        continue;
                    }
                    if (DatabaseType.Type.Enum.forString(type) == null) {
                        System.err.println("Invalid dbtype '" + type + "'.");
                        exit = true;
                        continue;
                    }
                    this.params.put("sql.dbtype", type);
                    continue;
                }
                if ("--no-batch-sql".equals(key)) {
                    this.params.put("nobatch", "nobatch");
                    continue;
                }
                if ("--force".equals(key)) {
                    this.params.put("force", String.valueOf(true));
                    continue;
                }
                if ("-l".equals(key) || "--list".equals(key)) {
                    this.list = true;
                    continue;
                }
                if (key.startsWith("--")) {
                    String name = key.substring("--".length());
                    BackupItem item = AbstractBackupManager.items.get(name);
                    if (item != null && !item.isMandatory()) {
                        this.includes.add(name);
                        continue;
                    }
                    exit = true;
                    continue;
                }
                exit = true;
            }
        }
        catch (RuntimeException re) {
            exit = true;
        }
        if (this.filename == null || exit) {
            if (exit && key != null) {
                args.add(key);
            }
            if (exit) {
                this.reportBadArgument(args);
            }
            return false;
        }
        return true;
    }

    public static FileSystemXmlApplicationContext createApplicationContext() {
        AppConfig.getsConfig().initCrossRepLuceneIndex();
        return new RestoreApplicationContext();
    }

    public static void destroyApplicationContext() {
        AppConfig.getsConfig().fullShutdown();
        ((FileSystemXmlApplicationContext)SpringContext.getApplicationContext()).close();
    }

    public static class RestoreApplicationContext
    extends FileSystemXmlApplicationContext {
        private RestoreApplicationContext() {
            super(RestoreApplicationContext.createUrl("WEB-INF/restoreApplicationContext.xml"));
        }

        private static String createUrl(String path) {
            File base = AppConfig.getWebAppLocation();
            return new File(base, path).toURI().toString();
        }
    }
}

