/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.ctl.Optimize;
import com.cenqua.fisheye.logging.Logs;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.LinkedList;

public final class OptimizeIndexes
implements Runnable {
    private static final String INDEX_NAME_PATTERN = "idx\\d";
    private static final String CROSS_REPOSITORY_ROOT = "globalfe";
    private static final String CRUCIBLE_ROOT = "cruidx";

    @Override
    public void run() {
        Logs.APP_LOG.info((Object)"Optimizing indexes as directed upon last shutdown ... ");
        this.optimize(" * repository indexes ...", this.getRepositoryIndexes());
        this.optimize(" * cross-repository indexes ...", this.getCrossRepositoryIndexes());
        if (this.isCrucible()) {
            this.optimize(" * Crucible index ...", this.getCrucibleIndex());
        }
        Logs.APP_LOG.info((Object)"Done optimising indexes");
    }

    private void optimize(String logEntry, String ... indexes) {
        if (indexes.length > 0) {
            Logs.APP_LOG.info((Object)logEntry);
            new Optimize(indexes, false).run();
        }
    }

    private String[] getCrossRepositoryIndexes() {
        File indexRoot = new File(this.getCacheDir(), CROSS_REPOSITORY_ROOT);
        return this.getIndexes(indexRoot);
    }

    private String[] getCrucibleIndex() {
        File indexRoot = new File(this.getCacheDir(), CRUCIBLE_ROOT);
        return this.getIndexes(indexRoot);
    }

    private String[] getRepositoryIndexes() {
        LinkedList indexes = new LinkedList();
        for (RepositoryType repositoryType : AppConfig.getsConfig().getConfig().getRepositoryArray()) {
            if (!repositoryType.getEnabled()) continue;
            File indexRoot = new File(AppConfig.getRepositoriesDir(), repositoryType.getName());
            Collections.addAll(indexes, this.getIndexes(indexRoot));
        }
        return indexes.toArray(new String[indexes.size()]);
    }

    private String[] getIndexes(File indexRoot) {
        File[] files = indexRoot.listFiles((FilenameFilter)new PatternFilenameFilter(INDEX_NAME_PATTERN));
        if (files == null) {
            return new String[0];
        }
        String[] indexes = new String[files.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            indexes[i2] = files[i2].getAbsolutePath();
        }
        return indexes;
    }

    protected File getCacheDir() {
        return AppConfig.getCacheDir();
    }

    protected boolean isCrucible() {
        return AppConfig.isCrucible();
    }
}

