/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.ctl.BaseCommand;
import com.cenqua.fisheye.ctl.InstanceLock;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.writer.DefaultIndexWriterFactory;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Level;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class Optimize
extends BaseCommand {
    private static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"H:mm:ss");
    private final String[] indexPaths;
    private final boolean verbose;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Optimize.setupLogging(true);
        Logs.APP_LOG.setLevel(Level.INFO);
        Logs.APP_LOG.info((Object)"FishEye Lucene Optimizer");
        InstanceLock lock = null;
        try {
            lock = InstanceLock.acquireLock();
            if (lock == null) {
                Logs.APP_LOG.error((Object)"FishEye appears to be running. Shutdown before running optimize.");
                return;
            }
            if (args == null || args.length == 0) {
                Logs.APP_LOG.error((Object)"Please enter the index(es) to optimize, separated by a space");
                Logs.APP_LOG.error((Object)"Example: optimize /path/to/firstindex /path/to/secondindex");
            } else {
                Logs.APP_LOG.info((Object)"Indexes to optimize: ");
                for (String indexPath : args) {
                    Logs.APP_LOG.info((Object)("  " + indexPath));
                }
                new Optimize(args, true).run();
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    public Optimize(String[] indexPaths, boolean verbose) {
        this.indexPaths = indexPaths;
        this.verbose = verbose;
    }

    public void run() {
        for (String indexPath : this.indexPaths) {
            this.optimize(indexPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optimize(String indexPath) {
        try {
            File path = new File(indexPath);
            if (!path.isDirectory()) {
                Logs.APP_LOG.error((Object)("Path " + indexPath + " is not a directory"));
                return;
            }
            Directory index = null;
            try {
                index = this.openIndex(path);
                if (IndexReader.indexExists((Directory)index)) {
                    this.info(index);
                    this.optimize(index);
                } else {
                    Logs.APP_LOG.error((Object)("No index was found at " + indexPath));
                }
            }
            finally {
                this.close(index);
            }
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)("Error while accessing the index on " + indexPath), (Throwable)e2);
        }
    }

    private Directory openIndex(File path) throws IOException {
        Logs.APP_LOG.info((Object)("Opening index ... (" + path + ')'));
        return FSDirectory.open((File)path);
    }

    private void info(Directory index) throws IOException {
        IndexReader indexReader = IndexReader.open((Directory)index);
        if (this.verbose) {
            Logs.APP_LOG.info((Object)"Index:");
            Logs.APP_LOG.info((Object)("  number of documents: " + indexReader.numDocs()));
            Logs.APP_LOG.info((Object)("  number of deleted documents: " + indexReader.numDeletedDocs()));
            Logs.APP_LOG.info((Object)("  is already optimized: " + (indexReader.isOptimized() ? "yes" : "no")));
        }
        indexReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void optimize(Directory index) throws IOException {
        IndexWriter indexWriter = new DefaultIndexWriterFactory().create(index, null, false);
        try {
            long startTime = System.currentTimeMillis();
            if (this.verbose) {
                Logs.APP_LOG.info((Object)("Started to optimize at: " + DATE_FORMATTER.format(new Date(startTime))));
            }
            try {
                indexWriter.forceMerge(1, true);
            }
            finally {
                indexWriter.close();
            }
            if (this.verbose) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                Logs.APP_LOG.info((Object)("Done optimizing at: " + DATE_FORMATTER.format(new Date()) + " (it took: " + elapsedTime / 60000L + " minutes, " + elapsedTime % 60000L / 1000L + " seconds)"));
            }
        }
        finally {
            if (IndexWriter.isLocked((Directory)index)) {
                IndexWriter.unlock((Directory)index);
            }
        }
    }

    private void close(Directory index) {
        if (index != null) {
            try {
                index.close();
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"Could not close the index", (Throwable)e2);
            }
        }
    }
}

