/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.ctl.BaseCommand;
import com.google.common.annotations.VisibleForTesting;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class CheckClassLoader
extends BaseCommand {
    private final Category log;

    @VisibleForTesting
    CheckClassLoader(Category log) {
        this.log = log;
    }

    public static void main(String[] args) {
        CheckClassLoader.setupLogging(true);
        new CheckClassLoader((Category)Logger.getLogger(CheckClassLoader.class)).mainImpl(args);
    }

    @VisibleForTesting
    void mainImpl(String[] args) {
        this.log.info((Object)"FishEye class checker");
        if (args.length != 1) {
            this.usage("Expected 1 argument with fully qualified class name (FQCN) but got " + Arrays.asList(args));
            return;
        }
        if (Arrays.asList("-h", "--help").contains(args[0])) {
            this.usage(null);
            return;
        }
        String className = args[0];
        this.log.info((Object)("Checking class '" + className + "'"));
        this.checkClass("defaultCL", this.getClass().getClassLoader(), className);
        this.checkClass("threadContextCL", Thread.currentThread().getContextClassLoader(), className);
    }

    private void checkClass(String checkClassType, ClassLoader classLoader, String className) {
        try {
            this.log.info((Object)("Check class type: '" + checkClassType + "'"));
            this.log.info((Object)("Check class loader: " + this.objectToString(classLoader)));
            if (classLoader != null) {
                Class<?> clazz = classLoader.loadClass(className);
                this.log.info((Object)("Class loader of loaded class " + clazz.getName() + ": " + this.objectToString(clazz.getClassLoader())));
                ProtectionDomain protectionDomain = clazz.getProtectionDomain();
                if (protectionDomain != null) {
                    CodeSource codeSource = protectionDomain.getCodeSource();
                    if (codeSource != null) {
                        this.log.info((Object)("Loaded class code source location: " + codeSource.getLocation()));
                    } else {
                        this.log.info((Object)("Code source wasn't found for protection domain " + this.objectToString(protectionDomain)));
                    }
                } else {
                    this.log.info((Object)"Protection domain wasn't found");
                }
            } else {
                this.log.info((Object)"Class loader is null");
            }
        }
        catch (ClassNotFoundException e2) {
            this.log.error((Object)("Error loading class (ClassNotFoundException): " + e2.getMessage()));
        }
        catch (Exception e3) {
            this.log.error((Object)"Error loading class info", (Throwable)e3);
        }
    }

    private void usage(String message) {
        if (message != null) {
            this.log.error((Object)message);
        }
        this.log.error((Object)"Usage: fisheyectl.sh checkclass FQCN\nload class and print out class .jar path.\n\nOPTIONS:\n   -h, --help          this help");
    }

    private String objectToString(Object o2) {
        return o2 + (o2 != null ? " instance of " + o2.getClass() : "");
    }
}

