/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.ctl.Run;
import com.cenqua.fisheye.logging.Logs;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.LogManager;
import org.apache.log4j.xml.SubstitutingDOMConfigurator;

public class BaseCommand {
    private static final String SERVER_LOG4J_XML = "log4j.xml";
    private static final String CLIENT_LOG4J_XML = "log4j-client.xml";
    private static final Pattern systemPropertyPattern = Pattern.compile("-D([^=]+)=(.+)");
    public static final int FAILURE = 1;
    public static final int SUCCESS = 0;

    protected static boolean overrideFishEyeInst(List<String> args, PrintStream err) {
        for (int i2 = 0; i2 < args.size(); ++i2) {
            if (!args.get(i2).equals("--fisheye-inst")) continue;
            if (i2 == args.size() - 1) {
                err.println("No argument provided to --fisheye-inst parameter");
                return false;
            }
            String fisheyeInstPath = args.get(i2 + 1);
            File fishEyeInst = new File(fisheyeInstPath);
            if (!fishEyeInst.exists()) {
                err.println("--fisheye-inst argument '" + fisheyeInstPath + "' does not exist");
                return false;
            }
            AppConfig.setInstanceDir(fishEyeInst);
            args.remove(i2 + 1);
            args.remove(i2);
            break;
        }
        return true;
    }

    static boolean handleCommonArguments(List<String> argList, PrintStream err) {
        Logs.APP_LOG.info((Object)("FishEye arguments: " + argList));
        Iterator<String> argIterator = argList.iterator();
        while (argIterator.hasNext()) {
            String s2 = argIterator.next();
            if (s2.equals("--config") && argIterator.hasNext()) {
                argIterator.remove();
                File cfgFile = new File(argIterator.next()).getAbsoluteFile();
                argIterator.remove();
                if (!cfgFile.isFile()) {
                    err.println("Could not read config file " + cfgFile.getAbsolutePath());
                    return false;
                }
                AppConfig.setConfigurationFile(cfgFile);
                continue;
            }
            if (s2.equals("--Xno-slurp")) {
                argIterator.remove();
                Logs.APP_LOG.info((Object)"Starting with --Xno-slurp");
                AppConfig.noSlurp = true;
                continue;
            }
            if (s2.equals("--Xdisable-content-indexing")) {
                argIterator.remove();
                Logs.APP_LOG.info((Object)"Starting with --Xdisable-content-indexing");
                AppConfig.Hacks.DISABLE_CONTENT_INDEXING = true;
                continue;
            }
            if (s2.equals("--Xdisable-dirtree-empty-checks")) {
                argIterator.remove();
                Logs.APP_LOG.info((Object)"Starting with --Xdisable-dirtree-empty-checks. Will not check for empty directories.");
                AppConfig.Hacks.DISABLE_DIRTREE_EMPTY_CHECKS = true;
                continue;
            }
            if (s2.equals("--Xenable-git-content-hash-resolving-heuristic")) {
                argIterator.remove();
                Logs.APP_LOG.info((Object)"Starting with  --Xenable-git-content-hash-resolving-heuristic. Revisions in file tab of repository browser may be incorrect.");
                AppConfig.Hacks.ENABLE_GIT_CONTENT_HASH_RESOLVING_HEURISTIC = true;
                continue;
            }
            if (s2.equals("--Xtab-width") && argIterator.hasNext()) {
                argIterator.remove();
                String tw = argIterator.next();
                argIterator.remove();
                Logs.APP_LOG.info((Object)("Starting with --Xtab-width and width of " + tw + "."));
                AppConfig.DEFAULT_TAB_WIDTH = Integer.parseInt(tw);
                continue;
            }
            if (s2.equals("--Xdisable-head-detection")) {
                argIterator.remove();
                Logs.APP_LOG.info((Object)"Starting with --Xdisable-head-detection. Will not determine branch heads in DVCS.");
                AppConfig.Hacks.DISABLE_HEAD_DETECION = true;
                continue;
            }
            if (s2.equals("--Xdisable-tags")) {
                argIterator.remove();
                Logs.APP_LOG.info((Object)"Starting with --Xdisable-tags. Will not record tags on commits in DVCS.");
                AppConfig.Hacks.DISABLE_TAGS = true;
                continue;
            }
            if (s2.equals("--Xlenient-patches")) {
                argIterator.remove();
                Logs.APP_LOG.info((Object)"Starting with --Xlenient-patches.  Non-standard patches will be processed and not rejected");
                AppConfig.Hacks.LENIENT_PATCHES = true;
            }
            if ("--quiet".equals(s2)) {
                argIterator.remove();
                Logs.setupQuietMode();
                Logs.APP_LOG.info((Object)"Starting with --quiet. Nothing will be printed to console.");
            }
            if ("--debug".equals(s2) || "--debug-perf".equals(s2)) {
                argIterator.remove();
                Logs.setupDebugMode();
                Logs.APP_LOG.info((Object)"Starting with --debug. Logging will be at debug level.");
            }
            if (!s2.startsWith("-D") || s2.length() <= 2) continue;
            String key = null;
            String value = null;
            Matcher matcher = systemPropertyPattern.matcher(s2);
            if (matcher.matches()) {
                key = matcher.group(1);
                value = matcher.group(2);
            } else if (argIterator.hasNext()) {
                key = s2.substring(2);
                value = argIterator.next();
            }
            if (key == null || value == null) continue;
            Logs.APP_LOG.info((Object)("Setting system property " + key + "=" + value));
            System.setProperty(key, value);
        }
        Run.setLibraryProperties();
        return true;
    }

    static void setupLogging(boolean isClient) {
        File logCfgFile;
        LogManager.resetConfiguration();
        File logDir = AppConfig.getLogDir();
        if (!logDir.isDirectory()) {
            logDir.mkdirs();
        }
        if (!logDir.isDirectory()) {
            Logs.APP_LOG.warn((Object)("could not create logs directory: " + logDir.getAbsolutePath()));
        }
        String log4jFilename = isClient ? CLIENT_LOG4J_XML : SERVER_LOG4J_XML;
        File logCfgFile1 = new File(AppConfig.getInstanceDir(), log4jFilename);
        File logCfgFile2 = new File(AppConfig.getAppHome(), log4jFilename);
        if (logCfgFile1.isFile()) {
            logCfgFile = logCfgFile1;
        } else if (logCfgFile2.isFile()) {
            logCfgFile = logCfgFile2;
        } else {
            Logs.APP_LOG.warn((Object)("Could not find log configuration file, tried " + logCfgFile1 + " and " + logCfgFile2));
            return;
        }
        LogManager.resetConfiguration();
        Properties props = new Properties();
        props.setProperty("fisheye.home", AppConfig.getAppHome().getAbsolutePath());
        props.setProperty("fisheye.inst", AppConfig.getInstanceDir().getAbsolutePath());
        SubstitutingDOMConfigurator cfg = new SubstitutingDOMConfigurator(props);
        cfg.doConfigure(logCfgFile.getAbsolutePath(), LogManager.getLoggerRepository());
        Logs.APP_LOG.info((Object)("Using log4j configuration file: " + logCfgFile.getAbsolutePath()));
        Logs.init();
    }

    protected void reportBadArgument(List<String> args) {
        if (args.isEmpty()) {
            System.err.println("Bad arguments");
        } else {
            System.err.println("Bad argument: " + args.get(0));
        }
    }
}

