/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.ctl;

import com.atlassian.crucible.migration.AbstractBackupManager;
import com.atlassian.crucible.migration.BackupItem;
import com.cenqua.fisheye.ctl.BaseRemoteCommand;
import com.cenqua.fisheye.web.JspUtils;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Backup
extends BaseRemoteCommand {
    private static final String name = "backup";
    private final String USAGE;
    private String filename = null;
    private final Set<String> includes = new HashSet<String>();
    private boolean quiet = false;
    private boolean anonymise = false;
    private Integer compressionLevel = null;

    public Backup() {
        StringBuilder buf = new StringBuilder("Usage: backup [OPTIONS]\n\nCreates a backup of this " + new JspUtils().getAppName() + " instance.\n" + "\n" + "OPTIONS:\n" + "   -q, --quiet         suppress output\n" + "   -f, --file FILE     write the backup to FILE\n" + "   -c, --compression   ZIP compression level [0-9] (default is 6)\n" + "   -a, --anonymise     anonymise the SQL database (replace all text with 'x')\n" + "   -h, --help          display this help and exit\n");
        for (Map.Entry<String, BackupItem> item : AbstractBackupManager.items.entrySet()) {
            if (item.getValue().isMandatory()) continue;
            buf.append(String.format(item.getValue().isDefault() ? "   --no-%-14s exclude %s (included when omitted)\n" : "   --%-17s include %s (excluded when omitted)\n", item.getKey(), item.getValue().getDescription()));
            if (!item.getValue().isDefault()) continue;
            this.includes.add(item.getKey());
        }
        this.USAGE = buf.toString();
    }

    public static void main(String[] args) {
        LinkedList<String> argsCopy = new LinkedList<String>(Arrays.asList(args));
        if (!Backup.overrideFishEyeInst(argsCopy, System.err)) {
            System.exit(1);
        }
        Backup main = new Backup();
        System.exit(main.mainImpl(argsCopy.toArray(new String[argsCopy.size()])));
    }

    @Override
    protected boolean processArgs() {
        boolean exit = false;
        String key = null;
        try {
            while (!exit && this.args.size() > 0) {
                BackupItem item;
                String name;
                key = (String)this.args.remove(0);
                if ("-q".equals(key) || "--quiet".equals(key)) {
                    this.quiet = true;
                    continue;
                }
                if ("-a".equals(key) || "--anonymise".equals(key) || "--anonymize".equals(key)) {
                    this.anonymise = true;
                    continue;
                }
                if ("-f".equals(key) || "--file".equals(key)) {
                    this.filename = (String)this.args.remove(0);
                    continue;
                }
                if ("-c".equals(key) || "--compression".equals(key)) {
                    this.compressionLevel = Integer.parseInt((String)this.args.remove(0));
                    exit = this.compressionLevel < 0 || this.compressionLevel > 9;
                    continue;
                }
                if ("-h".equals(key) || "--help".equals(key)) {
                    System.err.println(this.USAGE);
                    System.exit(0);
                    continue;
                }
                if (key.startsWith("--no-")) {
                    name = key.substring("--no-".length());
                    item = AbstractBackupManager.items.get(name);
                    if (item != null && !item.isMandatory() && item.isDefault()) {
                        this.includes.remove(name);
                        continue;
                    }
                    exit = true;
                    continue;
                }
                if (key.startsWith("--")) {
                    name = key.substring("--".length());
                    item = AbstractBackupManager.items.get(name);
                    if (item != null && !item.isMandatory() && !item.isDefault()) {
                        this.includes.add(name);
                        continue;
                    }
                    exit = true;
                    continue;
                }
                exit = true;
            }
        }
        catch (RuntimeException re) {
            exit = true;
        }
        if (exit) {
            if (key != null) {
                this.args.add(key);
            }
            System.err.println(this.USAGE);
            return false;
        }
        return true;
    }

    @Override
    protected void sendCommand(OutputStream out) throws IOException {
        out.write(String.format("%s\r\n", name).getBytes());
        out.write(String.format("%s: %s\r\n", "anonymise", Boolean.toString(this.anonymise)).getBytes());
        out.write(String.format("%s: %s\r\n", "quiet", Boolean.toString(this.quiet)).getBytes());
        out.write(String.format("%s: %s\r\n", "include", Joiner.on((String)",").join(this.includes)).getBytes());
        if (this.filename != null) {
            out.write(String.format("%s: %s\r\n", "file", this.filename).getBytes());
        }
        if (this.compressionLevel != null) {
            out.write(String.format("%s: %d\r\n", "compression", this.compressionLevel).getBytes());
        }
    }
}

