/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import java.awt.Color;

public class Util {
    public static String getInterpolatedColour(Color light, Color dark, float ratio) {
        float[] l2 = Color.RGBtoHSB(light.getRed(), light.getGreen(), light.getBlue(), new float[3]);
        float[] d2 = Color.RGBtoHSB(dark.getRed(), dark.getGreen(), dark.getBlue(), new float[3]);
        Color color = Color.getHSBColor(l2[0] + (d2[0] - l2[0]) * ratio, l2[1] + (d2[1] - l2[1]) * ratio, l2[2] + (d2[2] - l2[2]) * ratio);
        return Util.toHexString(color);
    }

    private static String toHexString(int value) {
        String s2 = Integer.toHexString(value);
        if (s2.length() == 1) {
            s2 = "0" + s2;
        }
        return s2;
    }

    public static String toHexString(Color color) {
        return "#" + Util.toHexString(color.getRed()) + Util.toHexString(color.getGreen()) + Util.toHexString(color.getBlue());
    }

    public static Color fromHexString(String hexString) {
        if (hexString.length() == 6) {
            int r2 = Integer.valueOf(hexString.substring(0, 2), 16);
            int g2 = Integer.valueOf(hexString.substring(2, 4), 16);
            int b2 = Integer.valueOf(hexString.substring(4, 6), 16);
            return new Color(r2, g2, b2);
        }
        return null;
    }
}

