/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.atlassian.crucible.spi.impl.SPIUtils;
import com.atlassian.fisheye.spi.data.ChangesetDataFE;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.csindex.BaseRecentChangesSearcher2;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.perforce.P4ChangeSet;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.SortedList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SpiRecentChangesSearcher2
extends BaseRecentChangesSearcher2<ChangesetDataFE> {
    private RevisionCache cache;
    private SPIUtils spiUtils;
    private static final Comparator<ChangesetDataFE> COMPARE_TOWARDS_FUTURE = new Comparator<ChangesetDataFE>(){

        @Override
        public int compare(ChangesetDataFE a2, ChangesetDataFE b2) {
            return CompareUtil.compare(a2.getDate(), b2.getDate());
        }
    };
    private static final Comparator<ChangesetDataFE> COMPARE_TOWARDS_PAST = new Comparator<ChangesetDataFE>(){

        @Override
        public int compare(ChangesetDataFE a2, ChangesetDataFE b2) {
            return -CompareUtil.compare(a2.getDate(), b2.getDate());
        }
    };

    public SpiRecentChangesSearcher2(RevisionCache cache, LuceneConnection<CrossRepLuceneIndexes> conn, SPIUtils spiUtils) {
        super(conn);
        this.cache = cache;
        this.spiUtils = spiUtils;
    }

    @Override
    protected Comparator<ChangesetDataFE> getComparator(boolean towardsFuture) {
        return towardsFuture ? COMPARE_TOWARDS_FUTURE : COMPARE_TOWARDS_PAST;
    }

    @Override
    protected ChangesetDataFE transformResult(ChangeSet cs) throws DbException {
        ChangesetDataFE.ChangesetDataFEBuilder builder = ChangesetDataFE.newBuilder().setRepositoryName(cs.getRepName()).setCsid(cs.getId()).setDisplayId(cs.getDisplayId()).setDate(cs.getDateValue()).setBranches(cs.getBranch() != null ? Collections.singleton(cs.getBranch()) : null).setAuthor(cs.getAuthor()).setComment(cs.getComment()).setFileRevisions(this.spiUtils.createFileRevisionKeyDataIterator(cs), cs.getRevisionInfosCount()).setFileRevisionsData(this.spiUtils.createFileRevisionDataIterator(cs));
        if (cs instanceof P4ChangeSet) {
            builder.setP4JobIds(((P4ChangeSet)cs).getFixes());
        }
        return builder.build();
    }

    @Override
    protected Long getDateOfLastItem(SortedList<ChangesetDataFE> results) {
        return results.getLast().getDate().getTime();
    }

    @Override
    protected RevisionCache getCache(String rep) {
        return this.cache;
    }

    public List<ChangesetDataFE> findRecentChangeSets(RecentChangesParams2 params) throws DbException {
        return super.findRecentChangeSets(this.cache.getRepositoryName(), params);
    }
}

