/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.csindex.BaseRecentChangesSearcher2;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.SortedList;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class CrossRepRecentChangesSearcher2
extends BaseRecentChangesSearcher2<ChangeSetHolder> {
    private Map<String, RepositoryHandle> repoHandles;
    private Map<String, RevisionCache> revCaches = new HashMap<String, RevisionCache>();
    private CommitterUserMappingManager committerUserMappingManager;

    public CrossRepRecentChangesSearcher2(LuceneConnection<CrossRepLuceneIndexes> conn, Map<String, RepositoryHandle> reps, CommitterUserMappingManager committerUserMappingManager) {
        super(conn);
        this.repoHandles = reps;
        this.committerUserMappingManager = committerUserMappingManager;
    }

    @Override
    protected Comparator<ChangeSetHolder> getComparator(boolean towardsFuture) {
        return ChangeSetHolder.getChangesetComparator(towardsFuture);
    }

    @Override
    protected ChangeSetHolder transformResult(ChangeSet cs) {
        String repName = cs.getRepName();
        if (!this.repoHandles.containsKey(repName)) {
            return null;
        }
        RepositoryHandle handle = this.repoHandles.get(repName);
        RevisionCache revisionCache = this.getCache(repName);
        String defaultBranch = revisionCache.getDefaultBranch();
        RepositoryConfig repositoryConfig = handle.getCfg();
        ChangeSetHolder.Context c2 = new ChangeSetHolder.Context(new WaybackSpec(), revisionCache.isCaseSensitive(), 5, Path.ROOT, repName, repositoryConfig.getRepositoryType(), defaultBranch);
        boolean supportsBranchFilter = repositoryConfig.isSupportsBranchFilter();
        return new ChangeSetHolder(cs, c2, supportsBranchFilter, this.committerUserMappingManager);
    }

    @Override
    protected Long getDateOfLastItem(SortedList<ChangeSetHolder> results) {
        return results.getLast().getChangeset().getDate();
    }

    @Override
    protected RevisionCache getCache(String rep) {
        if (this.revCaches.containsKey(rep)) {
            return this.revCaches.get(rep);
        }
        if (this.repoHandles.containsKey(rep)) {
            try {
                RepositoryHandle handle = this.repoHandles.get(rep);
                if (handle != null && handle.isRunning()) {
                    RevisionCache<? extends ChangeSet> cache = handle.acquireEngine().getRevisionCache();
                    this.revCaches.put(rep, cache);
                    return cache;
                }
            }
            catch (RepositoryHandle.StateException e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }
}

