/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.crossrepo.ChangesetCannedQueries;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.csindex.ActivityCalendar;
import com.cenqua.fisheye.csindex.RecentChangesSearcher2;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.util.SumMap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ChangesetStatsCalculator {
    private static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] HOURS = new String[24];
    private final Query query;

    public ChangesetStatsCalculator(Query query) {
        this.query = query;
    }

    public ChangesetStatsCalculator(String rep, String branch, List<String> committers, Path path) {
        this.query = ChangesetCannedQueries.comittersOnPathQuery(rep, branch, committers, path);
    }

    public ChangesetStatsCalculator(String rep, String branch, String committer, Path path) {
        this.query = ChangesetCannedQueries.comittersOnPathQuery(rep, branch, committer == null ? null : Collections.singletonList(committer), path);
    }

    public ChangesetStatsCalculator(ActivityItemSearchParams params) {
        this.query = ChangesetCannedQueries.activityItemQuery(params);
    }

    public ChangesetStatsCalculator(Multimap<String, String> committers) {
        this.query = ChangesetCannedQueries.commiterMappingsQuery(committers);
    }

    private int countHits(Query q2, IndexSearcher s2) throws DbException {
        try {
            return LuceneHelper.countMatchingDocuments(s2, q2);
        }
        catch (IOException e2) {
            throw new DbException("Error searching lucene index", e2);
        }
    }

    public static List<VolumeData> calculateMostActiveCommitters(RepositoryEngine engine, Path lpath, TimeZone tz, int numDays, int maxCommitters) throws DbException {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setBasePath(lpath);
        params.setMaxReturn(2000);
        if (numDays != 0) {
            Calendar cal = Calendar.getInstance(tz);
            cal.add(6, -Math.abs(numDays));
            params.setMinDate(cal.getTime().getTime());
        }
        RecentChangesSearcher2 searcher = new RecentChangesSearcher2(engine);
        List<ChangeSet> changesets = searcher.findRecentChangeSets(params);
        Iterator<ChangeSet> it = changesets.iterator();
        HashMap<String, VolumeData> committerVolumeMap = new HashMap<String, VolumeData>();
        CommitterUserMappingManager committerUserMappingManager = (CommitterUserMappingManager)SpringContext.getComponent("committerUserMappingManager");
        String repname = engine.getName();
        while (it.hasNext()) {
            ChangeSet cs = it.next();
            it.remove();
            String author = cs.getAuthor();
            VolumeData committerVolume = (VolumeData)committerVolumeMap.get(author);
            if (committerVolume == null) {
                FecruUser user = committerUserMappingManager.getUserForCommitter(repname, author);
                if (user == null) {
                    committerVolume = new VolumeData(null, author, 0);
                    committerVolumeMap.put(author, committerVolume);
                } else {
                    committerVolume = (VolumeData)committerVolumeMap.get(user.getUsername());
                    if (committerVolume == null) {
                        committerVolume = new VolumeData(user, user.getUsername(), 0);
                        committerVolumeMap.put(user.getUsername(), committerVolume);
                    }
                }
            }
            committerVolume.incrementNumCommits();
        }
        TreeSet sortedVolume = new TreeSet(committerVolumeMap.values());
        int numResults = Math.min(sortedVolume.size(), maxCommitters);
        ArrayList<VolumeData> result = new ArrayList<VolumeData>(numResults);
        for (VolumeData item : sortedVolume) {
            result.add(item);
            if (result.size() != numResults) continue;
            break;
        }
        return result;
    }

    public Object2IntMap<String> getCommitCount(LuceneConnection<CrossRepLuceneIndexes> connection, final Collection<String> committers) throws DbException {
        final SumMap sumMap = SumMap.getInstance();
        connection.withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Void>(){

            @Override
            public Void perform(IndexSearcher indexSearcher) throws IOException, DbException {
                for (String committer : committers) {
                    Term t2 = new Term("author", committer.toLowerCase(Locale.US));
                    ChangesetStatsCalculator.this.countTermHits(indexSearcher, t2, new CountVisitor(){

                        @Override
                        public void visit(Term t2, int hits) {
                            sumMap.addValue(t2.text(), hits);
                        }
                    });
                }
                return null;
            }
        });
        return sumMap.getMap();
    }

    private void visitTerm(final String field, LuceneConnection<CrossRepLuceneIndexes> luceneConnection, final CountVisitor v2) throws DbException {
        luceneConnection.withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Void>(){

            @Override
            public Void perform(IndexSearcher indexSearcher) throws IOException, DbException {
                Term t2;
                TermEnum te = indexSearcher.getIndexReader().terms(new Term(field, ""));
                while ((t2 = te.term()) != null && t2.field().equals(field)) {
                    ChangesetStatsCalculator.this.countTermHits(indexSearcher, t2, v2);
                    if (te.next()) continue;
                }
                return null;
            }
        });
    }

    private void countTermHits(IndexSearcher s2, Term t2, CountVisitor v2) throws DbException {
        BooleanQuery bq = new BooleanQuery(true);
        if (this.query != null) {
            bq.add(this.query, BooleanClause.Occur.MUST);
        }
        bq.add((Query)new TermQuery(t2), BooleanClause.Occur.MUST);
        v2.visit(t2, this.countHits((Query)bq, s2));
    }

    public long count(LuceneConnection<CrossRepLuceneIndexes> luceneConnection) throws DbException {
        final AtomicLong count = new AtomicLong(0L);
        luceneConnection.withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Void>(){

            @Override
            public Void perform(IndexSearcher indexSearcher) throws IOException, DbException {
                count.addAndGet(ChangesetStatsCalculator.this.countHits(ChangesetStatsCalculator.this.query, indexSearcher));
                return null;
            }
        });
        return count.get();
    }

    public ActivityCalendar activityCalendar(LuceneConnection<CrossRepLuceneIndexes> luceneConnection, final ActivityCalendar result) throws DbException {
        this.visitTerm("dYearMonth", luceneConnection, new CountVisitor(){

            @Override
            public void visit(Term t2, int hits) {
                if (hits > 0) {
                    result.addResult(t2.text(), hits);
                }
            }
        });
        return result;
    }

    private Object2IntMap<String> getTermSet(String field, LuceneConnection<CrossRepLuceneIndexes> luceneConnection, final SumMap<String> terms) throws DbException {
        this.visitTerm(field, luceneConnection, new CountVisitor(){

            @Override
            public void visit(Term t2, int hits) {
                terms.addValue(t2.text(), hits);
            }
        });
        return terms.getMap();
    }

    private Object2IntMap<String> getTermSetForTimeZone(LuceneConnection<CrossRepLuceneIndexes> luceneConnection, final SumMap<String> terms, final double offset) throws DbException {
        this.visitTerm("dHourOfDay", luceneConnection, new CountVisitor(){

            @Override
            public void visit(Term t2, int hits) {
                terms.addValue(ChangesetStatsCalculator.this.computeShiftedHour(t2.text(), offset), hits);
            }
        });
        return terms.getMap();
    }

    private String computeShiftedHour(String column, double offset) {
        String offsetColumn = column;
        if (offset != 0.0) {
            int intColumn = Integer.parseInt(column);
            intColumn = (int)((long)intColumn + Math.round(offset));
            intColumn = (intColumn + 24) % 24;
            offsetColumn = String.format("%1$02d", intColumn);
        }
        return offsetColumn;
    }

    public Object2IntMap<String> activityByDay(LuceneConnection<CrossRepLuceneIndexes> luceneConnection) throws DbException {
        SumMap<String> map = new SumMap<String>((Object2IntMap<String>)new Object2IntLinkedOpenHashMap());
        for (String key : DAYS) {
            map.put(key, 0);
        }
        return this.getTermSet("dDayOfWeek", luceneConnection, map);
    }

    public Object2IntMap<String> activityByHour(LuceneConnection<CrossRepLuceneIndexes> luceneConnection) throws DbException {
        return this.getActivityByHour(luceneConnection, 0.0);
    }

    public Object2IntMap<String> activityByHour(LuceneConnection<CrossRepLuceneIndexes> luceneConnection, double offset) throws DbException {
        return this.getActivityByHour(luceneConnection, offset);
    }

    private Object2IntMap<String> getActivityByHour(LuceneConnection<CrossRepLuceneIndexes> luceneConnection, double offset) throws DbException {
        SumMap<String> map = new SumMap<String>((Object2IntMap<String>)new Object2IntLinkedOpenHashMap());
        for (String key : HOURS) {
            map.put(key, 0);
        }
        return this.getTermSetForTimeZone(luceneConnection, map, offset);
    }

    public Object2IntMap<String> getCommitVolumeForPastYearByWeek(LuceneConnection<CrossRepLuceneIndexes> connection, final SumMap<String> map) throws DbException {
        final Calendar cal = Calendar.getInstance();
        connection.withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Void>(){

            @Override
            public Void perform(IndexSearcher indexSearcher) throws IOException, DbException {
                for (String key : map.keySet()) {
                    ChangesetStatsCalculator.this.countTermHits(indexSearcher, new Term("dYearWeek", key), new CountVisitor(){

                        @Override
                        public void visit(Term t2, int hits) {
                            map.addValue(t2.text(), hits);
                        }
                    });
                    cal.add(3, -1);
                }
                return null;
            }
        });
        return map.getMap();
    }

    public static boolean committerExists(LuceneConnection<CrossRepLuceneIndexes> connection, final String rep, final String committer) throws DbException {
        return connection.withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Boolean>(){

            @Override
            public Boolean perform(IndexSearcher searcher) throws IOException, DbException {
                return LuceneHelper.existsMatchingDocuments(searcher, ((ChangesetQueryBuilder)((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(rep).withCommitter(committer)).changesetsOnly()).build());
            }
        });
    }

    static {
        for (int i2 = 0; i2 < 24; ++i2) {
            String key = String.valueOf(i2);
            if (key.length() == 1) {
                key = "0" + key;
            }
            ChangesetStatsCalculator.HOURS[i2] = key;
        }
    }

    public static class VolumeData
    implements Comparable<VolumeData> {
        @Nonnull
        private final String name;
        @Nullable
        private final FecruUser user;
        private int numCommits;

        private VolumeData(FecruUser user, String name, int numCommits) {
            this.name = name;
            this.user = user;
            this.numCommits = numCommits;
        }

        public String getName() {
            return this.name;
        }

        public int getNumCommits() {
            return this.numCommits;
        }

        public FecruUser getUser() {
            return this.user;
        }

        void incrementNumCommits() {
            ++this.numCommits;
        }

        @Override
        public int compareTo(VolumeData o2) {
            int compare = o2.numCommits - this.numCommits;
            if (compare == 0) {
                compare = this.name.compareTo(o2.name);
            }
            return compare;
        }
    }

    public static interface CountVisitor {
        public void visit(Term var1, int var2);
    }
}

