/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fisheye.model.ChangesetComment;
import com.cenqua.fisheye.crossrepo.AuthorDocInfo;
import com.cenqua.fisheye.crossrepo.BatchableDoc;
import com.cenqua.fisheye.crossrepo.ChangesetCommentDoc;
import com.cenqua.fisheye.crossrepo.ChangesetCommentDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.crossrepo.DocBatch;
import com.cenqua.fisheye.crossrepo.IndexingUtils;
import com.cenqua.fisheye.csindex.ChangesetIndexDateFormatter;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Function;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.index.IndexWriter;

public class ChangesetIndexer {
    public static SumMap<String> getEmptyWeekMapForLastYear() {
        SumMap<String> map = new SumMap<String>((Object2IntMap<String>)new Object2IntAVLTreeMap());
        Calendar cal = Calendar.getInstance();
        for (int i2 = 0; i2 < 52; ++i2) {
            String key = ChangesetIndexDateFormatter.formatYearWeek(cal.getTime());
            map.put(key, 0);
            cal.add(3, -1);
        }
        return map;
    }

    public void indexChangesetComment(IndexWriter writer, ChangesetCommentDoc csComment) {
        DocInfoManager<ChangesetCommentDocInfo> docInfoManager = new DocInfoManager<ChangesetCommentDocInfo>(writer, null);
        ChangesetCommentDocInfo changesetDoc = new ChangesetCommentDocInfo(csComment);
        try {
            docInfoManager.updateDoc(changesetDoc);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void indexChangesetComments(LuceneConnection<CrossRepLuceneIndexes> crossRepLuceneConnection, final ChangeSetResolver csResolver, Iterator<? extends ChangesetComment.Info> changesetComments, RepositoryStatus status) {
        if (!changesetComments.hasNext()) {
            return;
        }
        Timer timer = new Timer("indexChangesetComments");
        LuceneIndexer<ChangesetCommentDoc> indexer = new LuceneIndexer<ChangesetCommentDoc>(){

            @Override
            public void index(IndexWriter writer, ChangesetCommentDoc csCommentDoc) {
                ChangesetIndexer.this.indexChangesetComment(writer, csCommentDoc);
            }
        };
        this.writeInBatches(crossRepLuceneConnection, changesetComments, new Function<ChangesetComment.Info, ChangesetCommentDoc>(){

            public ChangesetCommentDoc apply(ChangesetComment.Info comment) {
                Object cs = csResolver.getChangeSet(comment.getCsid());
                return null == cs ? null : ChangesetCommentDoc.fromChangeSetComment(cs, comment);
            }
        }, status, indexer, timer);
        timer.end();
    }

    private void indexChangesetAndAuthor(IndexWriter writer, ChangesetDoc changeset, boolean isUpdate, boolean hasPre24Changesets) {
        DocInfoManager<CrossRepoDocInfo> docInfoManager = new DocInfoManager<CrossRepoDocInfo>(writer, null);
        ChangesetDocInfo changesetDoc = new ChangesetDocInfo(changeset, isUpdate);
        AuthorDocInfo authorDoc = new AuthorDocInfo(changeset.getAuthor(), changeset.getRepName());
        try {
            if (hasPre24Changesets) {
                writer.deleteDocuments(((ChangesetQueryBuilder)((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(changeset.getRepName()).changesetsOnly()).changesetId(changeset.getId())).build());
            }
            docInfoManager.updateDoc(changesetDoc);
            docInfoManager.updateDoc(authorDoc);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void indexChangesetsAndAuthors(LuceneConnection<CrossRepLuceneIndexes> crossRepLuceneConnection, ChangeSetResolver csResolver, Iterable<String> csidIterator, RepositoryStatus status, boolean isUpdate, Collection<String> indexedChangeSets, boolean hasPre24Changesets) {
        Iterable<ChangeSet> changeSets = IndexingUtils.csidsToNotNullChangeSets(csidIterator, csResolver);
        this.indexChangesetsAndAuthors(crossRepLuceneConnection, changeSets.iterator(), status, isUpdate, indexedChangeSets, hasPre24Changesets);
    }

    public void indexChangesetsAndAuthors(LuceneConnection<CrossRepLuceneIndexes> crossRepLuceneConnection, Iterator<? extends ChangeSet> changeSets, RepositoryStatus status, final boolean isUpdate, final Collection<String> indexedChangeSets, final boolean hasPre24Changesets) {
        if (!changeSets.hasNext()) {
            return;
        }
        Timer timer = new Timer("indexChangesetsAndAuthors");
        LuceneIndexer<ChangesetDoc> indexer = new LuceneIndexer<ChangesetDoc>(){

            @Override
            public void index(IndexWriter writer, ChangesetDoc csDoc) {
                ChangesetIndexer.this.indexChangesetAndAuthor(writer, csDoc, isUpdate, hasPre24Changesets);
                if (null != indexedChangeSets) {
                    indexedChangeSets.add(csDoc.getId());
                }
            }
        };
        this.writeInBatches(crossRepLuceneConnection, changeSets, new Function<ChangeSet, ChangesetDoc>(){

            public ChangesetDoc apply(ChangeSet cs) {
                return ChangesetDoc.fromChangeSet(cs);
            }
        }, status, indexer, timer);
        timer.end();
    }

    private <D extends BatchableDoc, T> void writeInBatches(LuceneConnection<CrossRepLuceneIndexes> crossRepLuceneConnection, Iterator<? extends T> iterator, Function<T, D> lookUpFunction, RepositoryStatus status, LuceneIndexer<D> indexer, Timer timer) {
        DocBatch<BatchableDoc> batch = new DocBatch<BatchableDoc>();
        while (iterator.hasNext()) {
            ChangesetIndexer.throwOnStopRequestedIfStatusProvided(status);
            T next = iterator.next();
            BatchableDoc doc = (BatchableDoc)lookUpFunction.apply(next);
            if (null == doc) continue;
            batch.addDoc(doc);
            if (!batch.isFull()) continue;
            this.writeBatch(crossRepLuceneConnection, batch, status, indexer, timer);
        }
        this.writeBatch(crossRepLuceneConnection, batch, status, indexer, timer);
    }

    private <D extends BatchableDoc> void writeBatch(LuceneConnection<CrossRepLuceneIndexes> crossRepLuceneConnection, final DocBatch<D> batch, final RepositoryStatus status, final LuceneIndexer<D> indexer, Timer timer) {
        if (batch.isEmpty()) {
            return;
        }
        ChangesetIndexer.throwOnStopRequestedIfStatusProvided(status);
        timer.mark("About to write batch of " + batch.getDocCount() + " documents and weight of " + batch.getWeight() + " to Lucene");
        crossRepLuceneConnection.withWriter(CrossRepLuceneIndexes.METADATA, new LuceneConnection.WriterAction<Void>(){

            @Override
            public Void perform(IndexWriter writer) throws IOException, DbException {
                for (BatchableDoc csDoc : batch) {
                    ChangesetIndexer.throwOnStopRequestedIfStatusProvided(status);
                    indexer.index(writer, csDoc);
                }
                return null;
            }
        });
        timer.mark("Lucene write done for batch");
        batch.clear();
    }

    private static void throwOnStopRequestedIfStatusProvided(RepositoryStatus status) throws StopRequestedException {
        if (null != status) {
            status.throwOnStopRequested();
        }
    }

    private static interface LuceneIndexer<D extends BatchableDoc> {
        public void index(IndexWriter var1, D var2);
    }
}

