/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.util.DateHelper;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;

public class ChangesetIndexDateFormatter {
    private final Format yearMonthFmt = IndexedDateFormat.YEAR_MONTH.getDateFormat();
    private final Format dayOfMonthFmt = IndexedDateFormat.DAY_OF_MONTH.getDateFormat();
    private final Format dayOfWeekFmt = IndexedDateFormat.DAY_OF_WEEK.getDateFormat();
    private final Format hourOfDayFmt = IndexedDateFormat.HOUR.getDateFormat();

    public String formatTimestamp(Date date) {
        return LuceneHelper.formatTimestamp(date);
    }

    public String formatDayOfMonth(Date date) {
        return this.dayOfMonthFmt.format(date);
    }

    public String formatYearMonth(Date date) {
        return this.yearMonthFmt.format(date);
    }

    public String formatDayOfWeek(Date date) {
        return this.dayOfWeekFmt.format(date);
    }

    public String formatHourOfDay(Date date) {
        return this.hourOfDayFmt.format(date);
    }

    public static String formatYearWeek(Date date) {
        Calendar cal = Calendar.getInstance(DateHelper.GMT);
        cal.setTime(date);
        int year = cal.get(1);
        int week = cal.get(3);
        int month = cal.get(2);
        if (week == 1 && month == cal.getMaximum(2)) {
            ++year;
        }
        return String.format("%1$04d%2$02d", year, week);
    }

    public static enum IndexedDateFormat {
        YEAR_MONTH("yyyyMM"),
        DAY_OF_MONTH("dd"),
        HOUR("HH"),
        DAY_OF_WEEK("E");

        private final String format;

        private IndexedDateFormat(String format) {
            this.format = format;
        }

        public FastDateFormat getDateFormat() {
            return FastDateFormat.getInstance((String)this.format, (TimeZone)DateHelper.GMT);
        }

        public String getFormat() {
            return this.format;
        }
    }
}

