/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.atlassian.fisheye.model.ChangesetComment;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.crossrepo.ChangesetCommentDoc;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexWriter;

public class ChangesetCommentIndexer {
    public static final int REINDEXING_BATCH_SIZE = 1000;
    private final ChangesetCommentManager ccm;

    public ChangesetCommentIndexer(ChangesetCommentManager ccm) {
        this.ccm = ccm;
    }

    public void reindexRep(final InternalRevisionCache revCache, RepositoryStatus status, boolean removeExisting) throws DbException {
        List<ChangesetComment.Info> csComments;
        ChangesetIndexer csIndexer = new ChangesetIndexer();
        if (removeExisting) {
            Logs.APP_LOG.debug((Object)"Clearing the changeset discussions index");
            revCache.getCrossRepLuceneConnection().withWriter(CrossRepLuceneIndexes.METADATA, new LuceneConnection.WriterAction(){

                public Void perform(IndexWriter writer) throws IOException, DbException {
                    writer.deleteDocuments(((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(revCache.getRepositoryName()).changesetCommentsOnly()).build());
                    return null;
                }
            });
        }
        int startId = -1;
        do {
            if ((csComments = this.ccm.getCommentsForRep(revCache.getRepositoryName(), startId, 1000)).isEmpty()) {
                return;
            }
            csIndexer.indexChangesetComments(revCache.getCrossRepLuceneConnection(), revCache, csComments.iterator(), status);
            startId = csComments.get(csComments.size() - 1).getId();
        } while (csComments.size() == 1000);
    }

    public void indexComment(ChangesetComment.Info csComment) throws DbException {
        RepositoryHandle rep = AppConfig.getsConfig().getRepositoryManager().getRepository(csComment.getRepository());
        if (rep.isRunning()) {
            try {
                InternalRevisionCache revCache = (InternalRevisionCache)rep.acquireEngine().getRevisionCache();
                Object cs = revCache.getChangeSet(csComment.getCsid());
                if (null == cs) {
                    return;
                }
                final ChangesetCommentDoc commentDoc = ChangesetCommentDoc.fromChangeSetComment(cs, csComment);
                revCache.getCrossRepLuceneConnection().withWriter(CrossRepLuceneIndexes.METADATA, new LuceneConnection.WriterAction<Void>(){

                    @Override
                    public Void perform(IndexWriter writer) throws IOException, DbException {
                        ChangesetIndexer csIndexer = new ChangesetIndexer();
                        csIndexer.indexChangesetComment(writer, commentDoc);
                        return null;
                    }
                });
            }
            catch (RepositoryHandle.StateException e2) {
                throw new DbException("Error indexing comment " + csComment, (Throwable)((Object)e2));
            }
        }
    }
}

