/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.crossrepo.ChangesetCannedQueries;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.SortedList;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;

public abstract class BaseRecentChangesSearcher2<T> {
    private final LuceneConnection<CrossRepLuceneIndexes> conn;

    public BaseRecentChangesSearcher2(LuceneConnection<CrossRepLuceneIndexes> conn) {
        this.conn = conn;
    }

    public List<T> findRecentChangeSets(String repname, RecentChangesParams2 params) throws DbException {
        HashMap<String, RecentChangesParams2> map = new HashMap<String, RecentChangesParams2>();
        map.put(repname, params);
        return this.findRecentChangeSets(map, params.computeEffectiveMinDate(), params.computeEffectiveMaxDate(), params.isTowardsFuture() ? SearchSortOrder.TOWARDS_FUTURE : SearchSortOrder.TOWARDS_PAST, params.getMaxReturn(), params.getChangesetIncludePredicate());
    }

    public List<T> findRecentChangeSets(Map<String, RecentChangesParams2> repsToSearch, Date minDate, Date maxDate, SearchSortOrder searchSortOrder, int maxReturn, @Nullable Predicate<ChangeSet> includePredicate) throws DbException {
        RevisionCache revCache = repsToSearch.size() == 1 ? this.getCache((String)Iterables.getOnlyElement(repsToSearch.keySet())) : null;
        Pair<Query, Option<Predicate<ChangeSet>>> queryParams = ChangesetCannedQueries.recentChangesQuery(repsToSearch, revCache, minDate, maxDate);
        Predicate<ChangeSet> changesetPredicate = this.mergePredicates(includePredicate, (Option<Predicate<ChangeSet>>)((Option)queryParams.right()));
        return this.doSearch((Query)queryParams.left(), searchSortOrder, maxReturn, changesetPredicate);
    }

    @Nullable
    private Predicate<ChangeSet> mergePredicates(@Nullable Predicate<ChangeSet> includePredicate, Option<Predicate<ChangeSet>> searchPredicate) {
        if (searchPredicate.isDefined()) {
            Predicate filterPredicate = (Predicate)searchPredicate.get();
            if (includePredicate == null) {
                return filterPredicate;
            }
            return Predicates.and(includePredicate, (Predicate)filterPredicate);
        }
        return includePredicate;
    }

    public List<T> findChangesets(SearchSortOrder searchSortOrder, int maxReturn, Query q2) {
        return this.doSearch(q2, searchSortOrder, maxReturn, null);
    }

    private List<T> doSearch(final Query q2, final SearchSortOrder searchSortOrder, final int maxReturn, final @Nullable Predicate<ChangeSet> includePredicate) {
        Logs.APP_LOG.debug((Object)("Changeset query = " + q2 + ", dir = " + (Object)((Object)searchSortOrder)));
        final ArrayList changesets = new ArrayList();
        if (maxReturn == 0) {
            return changesets;
        }
        this.conn.withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Void>(){

            @Override
            public Void perform(IndexSearcher indexSearcher) throws IOException, DbException {
                int batchSize;
                Integer limit;
                Sort sort = searchSortOrder.getLuceneSort();
                final List<Object> results = searchSortOrder == SearchSortOrder.BY_SCORE ? Lists.newArrayListWithExpectedSize((int)maxReturn) : new SortedList(BaseRecentChangesSearcher2.this.getComparator(searchSortOrder == SearchSortOrder.TOWARDS_FUTURE));
                if (includePredicate == null) {
                    limit = maxReturn;
                    batchSize = maxReturn;
                } else {
                    limit = null;
                    batchSize = Math.min(0x7FFFFFFE, maxReturn) + 1;
                }
                LuceneHelper.collectSearchResultsInBatches(indexSearcher, q2, sort, limit, batchSize, new LuceneHelper.BatchCollector(){
                    private Long last;

                    @Override
                    public boolean collect(IndexSearcher indexSearcher, ScoreDoc scoreDoc) throws IOException {
                        Object cs;
                        ChangesetDocInfo doc = ChangesetDocInfo.fromSearchHitRepCsidOnly(indexSearcher, scoreDoc);
                        RevisionCache cache = BaseRecentChangesSearcher2.this.getCache(doc.getRepository());
                        if (cache != null && (cs = cache.getChangeSet(doc.getChangesetId())) != null && (includePredicate == null || includePredicate.apply(cs))) {
                            Object transformedResult = BaseRecentChangesSearcher2.this.transformResult((ChangeSet)cs);
                            if (transformedResult != null) {
                                results.add(transformedResult);
                            }
                            if (results.size() >= maxReturn) {
                                if (searchSortOrder != SearchSortOrder.BY_SCORE && includePredicate != null) {
                                    if (this.last == null) {
                                        this.last = BaseRecentChangesSearcher2.this.getDateOfLastItem((SortedList)results);
                                    }
                                    return this.last.longValue() == cs.getDate();
                                }
                                return false;
                            }
                        }
                        return true;
                    }
                });
                if (results.size() > maxReturn) {
                    results.subList(maxReturn, results.size()).clear();
                }
                changesets.addAll(results);
                return null;
            }
        });
        return changesets;
    }

    protected abstract Comparator<T> getComparator(boolean var1);

    protected abstract T transformResult(ChangeSet var1) throws DbException;

    protected abstract Long getDateOfLastItem(SortedList<T> var1);

    protected abstract RevisionCache getCache(String var1);
}

