/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.csindex;

import com.cenqua.fisheye.csindex.Util;
import com.cenqua.fisheye.util.NaturalComparator;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActivityCalendar {
    private int max = 0;
    private final Color LIGHT = Color.decode("#DFECF2");
    private final Color DARK = Color.decode("#0267AA");
    private final Int2ObjectSortedMap<Year> years = new Int2ObjectRBTreeMap(new NaturalComparator(true));
    private final Matcher ymMatcher = Pattern.compile("(\\d\\d\\d\\d)(\\d\\d)").matcher("");

    public void addResult(String ym, int count) {
        this.ymMatcher.reset(ym).matches();
        int year = Integer.parseInt(this.ymMatcher.group(1));
        int month = Integer.parseInt(this.ymMatcher.group(2));
        Year y2 = (Year)this.years.get(year);
        if (y2 == null) {
            y2 = new Year(year);
            this.years.put(year, (Object)y2);
        }
        int newTotal = y2.add(month, count);
        this.max = Math.max(this.max, newTotal);
    }

    public Collection<Year> getYears() {
        return this.years.values();
    }

    public int getMax() {
        return this.max;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof ActivityCalendar)) {
            return false;
        }
        ActivityCalendar other = (ActivityCalendar)o2;
        return this.years.equals(other.years);
    }

    public int hashCode() {
        return this.years.hashCode();
    }

    public String toString() {
        return this.years.toString();
    }

    public final class Year {
        private int year;
        private final ArrayList<Month> months = new ArrayList();

        public Year(int year) {
            this.months.add(new Month("Jan"));
            this.months.add(new Month("Feb"));
            this.months.add(new Month("Mar"));
            this.months.add(new Month("Apr"));
            this.months.add(new Month("May"));
            this.months.add(new Month("Jun"));
            this.months.add(new Month("Jul"));
            this.months.add(new Month("Aug"));
            this.months.add(new Month("Sep"));
            this.months.add(new Month("Oct"));
            this.months.add(new Month("Nov"));
            this.months.add(new Month("Dec"));
            this.year = year;
        }

        public int getYear() {
            return this.year;
        }

        public ArrayList<Month> getMonths() {
            return this.months;
        }

        int add(int month, int count) {
            return this.months.get(month - 1).add(count);
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof Year)) {
                return false;
            }
            Year other = (Year)o2;
            return this.year == other.year && this.months.equals(other.months);
        }

        public int hashCode() {
            return this.year + 23 * this.months.hashCode();
        }

        public String toString() {
            return this.months.toString();
        }
    }

    public final class Month {
        private final String name;
        private int count;

        public Month(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        int add(int count) {
            this.count += count;
            return this.count;
        }

        public int getCount() {
            return this.count;
        }

        public String getColor() {
            if (ActivityCalendar.this.max == 0) {
                return Util.toHexString(ActivityCalendar.this.LIGHT);
            }
            return Util.getInterpolatedColour(ActivityCalendar.this.LIGHT, ActivityCalendar.this.DARK, (float)this.count / (float)ActivityCalendar.this.max);
        }

        public String getTextColor() {
            return this.count > ActivityCalendar.this.max / 2 ? "#FFFFFF" : "#000000";
        }

        public String toString() {
            return this.name + ": " + this.count;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof Month)) {
                return false;
            }
            Month other = (Month)o2;
            return this.count == other.count && this.name.equals(other.name);
        }

        public int hashCode() {
            return this.count + 23 * this.name.hashCode();
        }
    }
}

