/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.lucene.AntGlobQuery;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.common.lucene.PrefixPhraseQuery;
import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.atlassian.fecru.search.common.lucene.TokenStreamVisitor;
import com.atlassian.fecru.search.filepaths.FilePathUtils;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.crossrepo.AbstractRepositoryQueryBuilder;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class PathQueryBuilder<T extends PathQueryBuilder>
extends AbstractRepositoryQueryBuilder<T> {
    private static final float DATE_BOOST_FACTOR = 2.0f;

    public PathQueryBuilder() {
        this.setDocType((Query)new TermQuery(new Term("doctype", CrossRepoDocInfo.DocType.PATH.getId())));
    }

    public static PathQueryBuilder<PathQueryBuilder> newPathCrossRepoQueryBuilder() {
        return new PathQueryBuilder<PathQueryBuilder>();
    }

    public T lastModifiedIn(QuickSearchTimeBucket timeBucket) {
        if (timeBucket != QuickSearchTimeBucket.ANY_DATE) {
            int hoursSinceEpoch = TimeZoneVariables.reduceMillisToHours(timeBucket.getStartTime().getMillis());
            this.query.add((Query)NumericRangeQuery.newIntRange((String)"lastModifiedHrs", (Integer)hoursSinceEpoch, null, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        return (T)((PathQueryBuilder)this.getThis());
    }

    public T queryByPath(String userText) throws IOException {
        Object query;
        if (Strings.isNullOrEmpty((String)userText)) {
            query = new MatchAllDocsQuery();
        } else if (FilePathUtils.isAntGlob(userText)) {
            query = PathQueryBuilder.queryAntGlob(userText);
        } else {
            Query query1 = PathQueryBuilder.generateFilenameQuery(userText);
            PrefixPhraseQuery query2 = PathQueryBuilder.generateCamelCaseQuery(userText);
            query2.setBoost(2.0f);
            query = query2.hasNoPrefixes() ? query1 : new DisjunctionMaxQuery(Arrays.asList(new Query[]{query1, query2}), 0.0f);
        }
        this.getQuery().add((Query)PathQueryBuilder.queryWithRecencyBoost((Query)query), BooleanClause.Occur.MUST);
        return (T)((PathQueryBuilder)this.getThis());
    }

    private static Query queryAntGlob(String userText) {
        if ((userText = FilePathUtils.formatAntGlob(userText)).length() > 0 && userText.charAt(userText.length() - 1) != '*' && userText.charAt(userText.length() - 1) != '?') {
            userText = userText + '*';
        }
        return new AntGlobQuery(new Term("path", userText));
    }

    protected static Query generateFilenameQuery(String userText) {
        userText = FilePathUtils.removeNonAlphaNumeric(userText, true, false).toLowerCase();
        String filename0 = "camelCasedFileName";
        if (userText.indexOf(42) > 0 || userText.indexOf(63) > 0) {
            return new WildcardQuery(new Term("camelCasedFileName", userText));
        }
        return new PrefixQuery(new Term("camelCasedFileName", userText));
    }

    private static PrefixPhraseQuery generateCamelCaseQuery(String userText) {
        userText = FilePathUtils.breakCamelCases(userText);
        String filename1 = "fileName";
        Analyzer analyser1 = PathDocInfo.ANALYZER_MAP.get("fileName");
        final PrefixPhraseQuery phraseQuery = new PrefixPhraseQuery("fileName");
        LuceneUtils.visitTokens(userText, "fileName", analyser1, new TokenStreamVisitor(){

            @Override
            public void visit(String term) {
                phraseQuery.addPrefix(term);
            }
        });
        return phraseQuery;
    }

    public static RecencyBoostingQuery queryWithRecencyBoost(Query query) {
        return new RecencyBoostingQuery(query, 2.0f, "lastModifiedHrs");
    }
}

