/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fisheye.event.RepositoryDeletedEvent;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.config.SpringContext;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pathIndexerCache")
public class PathIndexerCache {
    private final LoadingCache<String, Option<Integer>> cache = CacheBuilder.newBuilder().maximumSize((long)FishEyeSysProps.PATH_INDEXER_CACHE_SIZE).expireAfterAccess(2L, TimeUnit.HOURS).build(CacheLoader.from((Supplier)new Supplier<Option<Integer>>(){

        public Option<Integer> get() {
            return Option.none();
        }
    }));

    @Autowired
    public PathIndexerCache(EventPublisher eventPublisher) {
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.invalidateAll();
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public Option<Integer> get(String docKey) {
        return (Option)this.cache.getUnchecked((Object)docKey);
    }

    public CacheStats stats() {
        return this.cache.stats();
    }

    public Option<Integer> put(String docKey, Option<Integer> timestamp) {
        return this.cache.asMap().put(docKey, timestamp);
    }

    public static PathIndexerCache getInstance() {
        return SpringContext.getComponent(PathIndexerCache.class, "pathIndexerCache");
    }
}

