/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.IndexingUtils;
import com.cenqua.fisheye.crossrepo.PathDoc;
import com.cenqua.fisheye.crossrepo.PathDocInfo;
import com.cenqua.fisheye.crossrepo.PathIndexerCache;
import com.cenqua.fisheye.crossrepo.PathQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import com.cenqua.fisheye.util.Timer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

public class PathIndexer {
    private final CrossRepLuceneIndex crossRepLuceneIndex;
    private final PathIndexerCache pathCache;

    public PathIndexer(CrossRepLuceneIndex crossRepLuceneIndex, PathIndexerCache pathCache) {
        Preconditions.checkNotNull((Object)pathCache);
        this.crossRepLuceneIndex = crossRepLuceneIndex;
        this.pathCache = pathCache;
    }

    public final <C extends ChangeSet> void indexPathsForChangeSetIds(String repositoryName, ChangeSetService<C> cache, Iterable<String> changeSetsIds, LogicalPathMatcher logicalPathMatcher, RepositoryStatus status) throws DbException {
        Iterable<ChangeSet> changeSets = IndexingUtils.csidsToNotNullChangeSets(changeSetsIds, cache);
        this.indexPathsForChangeSets(repositoryName, changeSets, logicalPathMatcher, status);
    }

    public final void indexPathsForChangeSets(String repositoryName, Iterable<? extends ChangeSet> changeSets, LogicalPathMatcher logicalPathMatcher, final RepositoryStatus status) throws DbException {
        Timer t2 = new Timer("Preprocessing changesets for crossRepoMeta");
        final PathDocBatch batch = new PathDocBatch(repositoryName, logicalPathMatcher);
        final AtomicInteger changesetRevisionsCount = new AtomicInteger(0);
        for (final ChangeSet changeSet : changeSets) {
            PathIndexer.throwOnStopRequestedIfStatusProvided(status);
            changesetRevisionsCount.set(0);
            changeSet.visitRevisions(new StoppableVisitor<FileRevision>(){

                @Override
                public boolean visit(FileRevision revision) {
                    PathIndexer.throwOnStopRequestedIfStatusProvided(status);
                    batch.addFileRevision(revision, changeSet);
                    changesetRevisionsCount.incrementAndGet();
                    if (batch.getSize() >= FishEyeSysProps.PATH_DOCS_PER_BATCH) {
                        PathIndexer.this.sendAndClearBatch(batch, status);
                    }
                    if (changesetRevisionsCount.get() >= FishEyeSysProps.CHANGESET_PATHS_LIMIT) {
                        Logs.APP_LOG.info((Object)("Changeset " + changeSet.getId() + ": indexed paths truncated at " + changesetRevisionsCount.get()));
                        return false;
                    }
                    return true;
                }
            });
        }
        if (null == status || !status.isStopRequested()) {
            this.sendAndClearBatch(batch, status);
        }
        t2.end();
    }

    private static void throwOnStopRequestedIfStatusProvided(RepositoryStatus status) throws StopRequestedException {
        if (null != status) {
            status.throwOnStopRequested();
        }
    }

    private void sendAndClearBatch(PathDocBatch batch, RepositoryStatus status) {
        if (batch.isEmpty()) {
            return;
        }
        Logs.APP_LOG.debug((Object)String.format("About to store %d preprocessed paths in crossRepoMeta index. Dedup'ed %d (%.2f%%).", batch.getSize(), batch.getDeduplicatedCount(), 100.0 * (double)batch.getDeduplicatedCount() / (double)(batch.getSize() + batch.getDeduplicatedCount())));
        this.sendBatch(batch, status);
        Logs.APP_LOG.debug((Object)("PathCache: " + this.pathCache.stats()));
        batch.clear();
    }

    protected CrossRepLuceneIndex getCrossRepLuceneIndex() {
        return this.crossRepLuceneIndex;
    }

    public void sendBatch(PathDocBatch batch, RepositoryStatus status) {
        try {
            this.getCrossRepLuceneIndex().getConnection().withWriter(CrossRepLuceneIndexes.METADATA, new PathDocBatchWriterAction(batch, status, this.pathCache));
        }
        catch (RuntimeException e2) {
            this.pathCache.invalidateAll();
            throw e2;
        }
    }

    static class PathDocBatch
    implements Iterable<PathDocInfo> {
        private final String repositoryName;
        private final Map<String, PathDoc> paths = Maps.newHashMap();
        private final LogicalPathMatcher logicalPathMatcher;
        private int deduplicatedCount;

        PathDocBatch(String repositoryName, LogicalPathMatcher logicalPathMatcher) {
            this.repositoryName = repositoryName;
            this.logicalPathMatcher = logicalPathMatcher;
        }

        public void addFileRevision(FileRevision revision, ChangeSet changeSet) {
            this.addIfNewer(this.fromFileRevision(revision, changeSet.getDateValue()));
            Path logicalParentPath = this.extractLogicalPath(revision.getPath()).getParent();
            if (!logicalParentPath.isRoot()) {
                this.addIfNewer(this.fromLogicalPath(logicalParentPath, PathDoc.Type.DIR, changeSet.getDateValue()));
            }
        }

        public int getSize() {
            return this.paths.size();
        }

        public boolean isEmpty() {
            return this.paths.isEmpty();
        }

        public void clear() {
            this.paths.clear();
            this.deduplicatedCount = 0;
        }

        @Override
        public Iterator<PathDocInfo> iterator() {
            return Iterators.transform(this.paths.values().iterator(), (Function)new Function<PathDoc, PathDocInfo>(){

                public PathDocInfo apply(@Nullable PathDoc pathDoc) {
                    return PathDocInfo.fromPathDoc(pathDoc, repositoryName);
                }
            });
        }

        public int getDeduplicatedCount() {
            return this.deduplicatedCount;
        }

        private void addIfNewer(PathDoc pathDoc) {
            String pathStr = pathDoc.getPath();
            PathDoc existing = this.paths.get(pathStr);
            if (null == existing) {
                this.paths.put(pathStr, pathDoc);
            } else {
                if (pathDoc.isNewerThan(existing)) {
                    this.paths.put(pathStr, pathDoc);
                }
                ++this.deduplicatedCount;
            }
        }

        private Path extractLogicalPath(Path path) {
            Path logicalPath = this.logicalPathMatcher.getLogicalPath(path);
            if (logicalPath == null || StringUtils.isEmpty((String)logicalPath.getPath())) {
                if (Logs.APP_LOG.isDebugEnabled()) {
                    Logs.APP_LOG.debug((Object)("Can not find logical path for physical path: '" + path + "'. " + "This may not appear correctly in search results."));
                }
                logicalPath = path;
            }
            return logicalPath;
        }

        private PathDoc fromLogicalPath(Path logicalPath, PathDoc.Type type, Date lastModified) {
            return new PathDoc(logicalPath, type, lastModified);
        }

        private PathDoc fromFileRevision(FileRevision fileRevision, Date lastModified) {
            Path effectiveLogicalPath;
            Path physicalPath = fileRevision.getPath();
            Path logicalPath = this.logicalPathMatcher.getLogicalPath(physicalPath);
            Path path = effectiveLogicalPath = this.isPathEmpty(logicalPath) ? physicalPath : logicalPath;
            PathDoc.Type type = fileRevision.isDir() ? PathDoc.Type.DIR : (fileRevision.isFile() ? PathDoc.Type.FILE : PathDoc.Type.UNKNONWN);
            return this.fromLogicalPath(effectiveLogicalPath, type, lastModified);
        }

        private boolean isPathEmpty(Path path) {
            return null == path || path.getNumComponents() == 0;
        }

        public String toString() {
            return "PathDocBatch{paths=" + this.paths.values() + '}';
        }
    }

    static class PathDocBatchWriterAction
    implements LuceneConnection.WriterAction<Void> {
        private final PathDocBatch batch;
        private final RepositoryStatus status;
        private final PathIndexerCache pathCache;

        PathDocBatchWriterAction(PathDocBatch batch, RepositoryStatus status, PathIndexerCache pathCache) {
            this.batch = batch;
            this.status = status;
            this.pathCache = pathCache;
        }

        @Override
        public Void perform(IndexWriter writer) throws IOException, DbException {
            DocInfoManager<PathDocInfo> pathDao = new DocInfoManager<PathDocInfo>(writer, IndexReader.open((IndexWriter)writer, (boolean)true));
            try {
                for (PathDocInfo pathDocInfo : this.batch) {
                    PathIndexer.throwOnStopRequestedIfStatusProvided(this.status);
                    this.storeDocIfNewest(pathDao, pathDocInfo);
                }
            }
            catch (IOException e2) {
                throw new DbException("Error indexing paths", e2);
            }
            finally {
                pathDao.closeReader();
            }
            return null;
        }

        private void storeDocIfNewest(DocInfoManager<PathDocInfo> pathDao, PathDocInfo pathDocInfo) throws IOException {
            boolean isNewest;
            String docKey = pathDocInfo.getKeyTerm().text();
            int docDate = pathDocInfo.getLastModifiedHrs();
            Option<Integer> lastModifiedDate = this.pathCache.get(docKey);
            if (lastModifiedDate.isEmpty()) {
                Integer lastModified = pathDao.findDoc(((PathQueryBuilder)PathQueryBuilder.newPathCrossRepoQueryBuilder().byKeyTerm(pathDocInfo.getKeyTerm())).build(), PathDocInfo.LAST_MODIFIED_CONVERTER);
                if (lastModified == null) {
                    isNewest = true;
                } else {
                    boolean bl = isNewest = lastModified <= docDate;
                    if (!isNewest) {
                        this.pathCache.put(docKey, (Option<Integer>)Option.some((Object)lastModified));
                    }
                }
            } else {
                boolean bl = isNewest = (Integer)lastModifiedDate.get() <= docDate;
            }
            if (isNewest) {
                this.pathCache.put(docKey, (Option<Integer>)Option.some((Object)docDate));
                pathDao.updateDoc(pathDocInfo);
            }
        }
    }
}

