/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.crossrepo.PathDoc;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.camelcases.CamelCaseAnalyser;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

public class PathDocInfo
extends CrossRepoDocInfo {
    public static final String FLD_PATH = "path";
    public static final String FLD_FILENAME = "fileName";
    public static final String FLD_CAMEL_CASED_FILENAME = "camelCasedFileName";
    public static final String FLD_LAST_MODIFIED_HRS = "lastModifiedHrs";
    public static final String FLD_TYPE = "type";
    @FieldInfo
    private final Fieldable key;
    @FieldInfo
    private final Fieldable path;
    @FieldInfo
    private final Fieldable fileName;
    @FieldInfo
    private final Fieldable camelCasedFileName;
    @FieldInfo
    private final NumericField lastModifiedHrs;
    @FieldInfo
    private final Fieldable type;
    protected static final Map<String, Analyzer> ANALYZER_MAP = ImmutableMap.of((Object)"fileName", (Object)((Object)new CamelCaseAnalyser(false)), (Object)"camelCasedFileName", (Object)((Object)new CamelCaseAnalyser(true)), (Object)"path", (Object)new KeywordAnalyzer());
    public static final DocConverter<Integer> LAST_MODIFIED_CONVERTER = new DocConverter<Integer>(){
        private final FieldSelector LAST_MODIFIED_SELECTOR = LuceneUtils.singleFieldSelector("lastModifiedHrs");

        @Override
        public Integer convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.LAST_MODIFIED_SELECTOR);
            String fieldValue = doc.get(PathDocInfo.FLD_LAST_MODIFIED_HRS);
            return fieldValue == null ? null : Integer.valueOf(fieldValue);
        }
    };
    public static final DocConverter<PathDocInfo> CONVERTER = new DocConverter<PathDocInfo>(){
        private final FieldSelector RESULT_SELECTOR = LuceneUtils.multipleFieldsSelector("rep", "path", "type");

        @Override
        public PathDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.RESULT_SELECTOR);
            Fieldable pathField = doc.getFieldable(PathDocInfo.FLD_PATH);
            if (null == pathField || Strings.isNullOrEmpty((String)pathField.stringValue())) {
                Logs.APP_LOG.debug((Object)("Could not find field 'path' in document: " + doc.getFields() + ". Result will not appear in search results."));
                return null;
            }
            return new PathDocInfo(pathField, null, null, null, doc.getFieldable(PathDocInfo.FLD_TYPE), doc.getFieldable("rep"));
        }
    };

    private PathDocInfo(Fieldable path, Fieldable fileName, Fieldable camelCasedFileName, NumericField lastModifiedTsHrs, Fieldable type, Fieldable repository) {
        super(CrossRepoDocInfo.DocType.PATH, repository);
        this.key = new Field("key", this.makeCrossRepoPathId(path.stringValue()), Field.Store.NO, Field.Index.NOT_ANALYZED);
        this.path = path;
        this.fileName = fileName;
        this.camelCasedFileName = camelCasedFileName;
        this.lastModifiedHrs = lastModifiedTsHrs;
        this.type = type;
    }

    public static PathDocInfo fromPathDoc(PathDoc pathDoc, String repName) {
        Field pathField = new Field(FLD_PATH, pathDoc.getPath(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
        Field fileNameField = new Field(FLD_FILENAME, pathDoc.getName(), Field.Store.NO, Field.Index.ANALYZED);
        Field camelCasedFileNameField = new Field(FLD_CAMEL_CASED_FILENAME, pathDoc.getName(), Field.Store.NO, Field.Index.ANALYZED);
        NumericField lastModifiedHrsField = PathDocInfo.makeLastModifiedHrsField(pathDoc.getDate().getTime());
        Field typeField = new Field(FLD_TYPE, pathDoc.getType().getCode(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        return new PathDocInfo((Fieldable)pathField, (Fieldable)fileNameField, (Fieldable)camelCasedFileNameField, lastModifiedHrsField, (Fieldable)typeField, PathDocInfo.makeRepositoryField(repName));
    }

    private static NumericField makeLastModifiedHrsField(long lastModifiedTsMs) {
        NumericField lastModifiedField = new NumericField(FLD_LAST_MODIFIED_HRS, Field.Store.YES, true);
        lastModifiedField.setIntValue(TimeZoneVariables.reduceMillisToHours(lastModifiedTsMs));
        return lastModifiedField;
    }

    private String makeCrossRepoPathId(String path) {
        return this.doctype.stringValue() + "_" + this.repository.stringValue() + ":" + path;
    }

    @Override
    public Term getKeyTerm() {
        return new Term(this.key.name(), this.key.stringValue());
    }

    @Override
    public Analyzer getAnalyzer() {
        return LuceneUtils.createPerFieldAnalyzer((Analyzer)new KeywordAnalyzer(), ANALYZER_MAP);
    }

    public Date getLastModifiedDate() {
        Integer lastModifiedHrs = this.getLastModifiedHrs();
        return lastModifiedHrs == null ? null : TimeZoneVariables.hoursToDate(lastModifiedHrs);
    }

    @Nullable
    public String getType() {
        return null == this.type ? null : this.type.stringValue();
    }

    public Integer getLastModifiedHrs() {
        return this.lastModifiedHrs == null ? null : Integer.valueOf(this.lastModifiedHrs.getNumericValue().intValue());
    }

    public static PathDocInfo fromSearchHit(IndexSearcher searcher, ScoreDoc hit) throws IOException {
        return CONVERTER.convert(searcher, hit);
    }

    public String getPath() {
        return this.path.stringValue();
    }

    public String toString() {
        return "PathCrossRepoDocInfo{path=" + (null == this.path ? "null" : this.path.stringValue()) + ", key=" + (null == this.key ? "null" : this.key.stringValue()) + '}';
    }

    public boolean isDir() {
        return PathDoc.Type.DIR.getCode().equals(this.getType());
    }
}

