/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.cenqua.fisheye.Path;
import java.util.Date;

public class PathDoc {
    private final String path;
    private final String name;
    private final Type type;
    private final Date date;

    public PathDoc(Path path, Type type, Date date) {
        this.path = path.getPath();
        this.name = path.getName();
        this.type = type;
        this.date = date;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isNewerThan(PathDoc other) {
        return this.getDate().after(other.getDate());
    }

    public String toString() {
        return "PathDoc{path='" + this.path + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", date=" + this.date + '}';
    }

    public static enum Type {
        FILE("F"),
        DIR("D"),
        UNKNONWN("");

        private final String code;

        private Type(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

