/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;

public class IndexingUtils {
    public static Iterable<ChangeSet> csidsToNotNullChangeSets(Iterable<String> csidIterator, final ChangeSetResolver<?> csResolver) {
        Iterable changesets = Iterables.transform(csidIterator, (Function)new Function<String, ChangeSet>(){

            @Nullable
            public ChangeSet apply(String csid) {
                Object changeSet = csResolver.getChangeSet(csid);
                if (changeSet == null) {
                    Logs.APP_LOG.debug((Object)("No ChangeSet found for csid " + csid + ". The changeset will be excluded."));
                }
                return changeSet;
            }
        });
        return Iterables.filter((Iterable)changesets, (Predicate)Predicates.notNull());
    }
}

