/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.crossrepo.BatchableDoc;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;

public class DocBatch<D extends BatchableDoc>
implements Iterable<D> {
    final Collection<D> docs = Lists.newArrayList();
    final int maxWeight;
    int weight = 0;

    public DocBatch(int maxWeight) {
        this.maxWeight = maxWeight;
    }

    public DocBatch() {
        this(FishEyeSysProps.WEIGHTED_CHANGESET_DOCS_PER_BATCH);
    }

    public void clear() {
        this.docs.clear();
        this.weight = 0;
    }

    public void addDoc(D d2) {
        this.docs.add(d2);
        this.weight += d2.getWeight();
    }

    public int getWeight() {
        return this.weight;
    }

    public int getDocCount() {
        return this.docs.size();
    }

    @Override
    public Iterator<D> iterator() {
        return this.docs.iterator();
    }

    public boolean isEmpty() {
        return this.docs.isEmpty();
    }

    public boolean isFull() {
        return this.getWeight() >= this.maxWeight;
    }

    public int getMaxWeight() {
        return this.maxWeight;
    }
}

