/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.fecru.search.index.service.NonScoringCollector;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fisheye.spi.services.RepositoryService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetSearcher;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultChangesetSearcher
implements ChangesetSearcher {
    private final CrossRepLuceneIndex index;
    private final RepositoryService repositoryService;

    @Autowired
    public DefaultChangesetSearcher(CrossRepLuceneIndex index, RepositoryService repositoryService) {
        this.index = index;
        this.repositoryService = repositoryService;
    }

    @Override
    public List<ChangeSetPair> getChangesetsForQuery(final ChangesetQueryBuilder queryBuilder) {
        return this.index.getConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<List<ChangeSetPair>>(){

            @Override
            public List<ChangeSetPair> perform(IndexSearcher indexSearcher) throws IOException, DbException {
                final ImmutableList.Builder changesets = ImmutableList.builder();
                indexSearcher.search(queryBuilder.build(), (Collector)new NonScoringCollector(){

                    public void collect(int doc) throws IOException {
                        changesets.add((Object)ChangesetDocInfo.changesetId(this.currentReader, doc));
                    }
                });
                return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)changesets.build(), (Predicate)DefaultChangesetSearcher.this.isInAccessibleRepository()));
            }
        });
    }

    @Override
    public List<ChangeSetPair> getChangesetsForQuery(final ChangesetQueryBuilder queryBuilder, final int maxDocs) {
        return this.index.getConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<List<ChangeSetPair>>(){

            @Override
            public List<ChangeSetPair> perform(IndexSearcher indexSearcher) throws IOException, DbException {
                TopDocs docs = indexSearcher.search(queryBuilder.build(), maxDocs);
                return DefaultChangesetSearcher.this.getChangeSetPairs(indexSearcher, docs);
            }
        });
    }

    @Override
    public List<ChangeSetPair> getChangesetsForQuery(final ChangesetQueryBuilder queryBuilder, final int maxDocs, final SearchSortOrder sortOrder) {
        return this.index.getConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<List<ChangeSetPair>>(){

            @Override
            public List<ChangeSetPair> perform(IndexSearcher indexSearcher) throws IOException, DbException {
                TopFieldDocs docs = indexSearcher.search(queryBuilder.build(), null, maxDocs, sortOrder.getLuceneSort());
                return DefaultChangesetSearcher.this.getChangeSetPairs(indexSearcher, (TopDocs)docs);
            }
        });
    }

    private List<ChangeSetPair> getChangeSetPairs(IndexSearcher indexSearcher, TopDocs docs) {
        final IndexReader indexReader = indexSearcher.getIndexReader();
        Iterable changeSets = Iterables.transform(Arrays.asList(docs.scoreDocs), (Function)new Function<ScoreDoc, ChangeSetPair>(){

            public ChangeSetPair apply(ScoreDoc doc) {
                try {
                    return ChangesetDocInfo.changesetId(indexReader, doc.doc);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        });
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)changeSets, this.isInAccessibleRepository()));
    }

    private Predicate<ChangeSetPair> isInAccessibleRepository() {
        return new Predicate<ChangeSetPair>(){

            public boolean apply(ChangeSetPair cs) {
                return DefaultChangesetSearcher.this.repositoryService.isRepositoryAccessible(cs.getRepository());
            }
        };
    }
}

