/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.model.FieldInfo;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public abstract class CrossRepoDocInfo
implements DocInfo {
    public static final String REP = "rep";
    @FieldInfo
    protected final Fieldable doctype;
    @FieldInfo
    protected final Fieldable repository;

    protected CrossRepoDocInfo(DocType docType, String repName) {
        this(docType, CrossRepoDocInfo.makeRepositoryField(repName));
    }

    protected static Fieldable makeRepositoryField(String repName) {
        return new Field(REP, repName, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    protected CrossRepoDocInfo(DocType docType, Fieldable repository) {
        this.doctype = new Field("doctype", docType.getId(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository.stringValue();
    }

    public static enum DocType {
        CHANGESET("1"),
        COMMENT("2"),
        AUTHOR("3"),
        PATH("4"),
        BRANCH("5");

        private String id;

        private DocType(String i2) {
            this.id = i2;
        }

        public String getId() {
            return this.id;
        }
    }
}

