/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.api.QuickSearchTimeBucket;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.common.lucene.RecencyBoostingQuery;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.bucket.TimeZoneVariables;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.AbstractRepositoryQueryBuilder;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.HasTermFilter;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanFilter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class ChangesetQueryBuilder<T extends ChangesetQueryBuilder>
extends AbstractRepositoryQueryBuilder<T> {
    protected boolean changesetCommentsOnly;
    private Date minDate;
    private Date maxDate;
    private static final Pattern WORD_BOUNDARY = Pattern.compile("\\s");

    public static Query queryChangesetsIndexedBetween(String repoName, long minIndexingTime, long maxIndexingTime) {
        return ((ChangesetQueryBuilder)((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder(repoName).changesetsOnly()).indexedBetween(minIndexingTime, maxIndexingTime)).build();
    }

    public static TermQuery getCommentDocTypeQuery() {
        return new TermQuery(new Term("doctype", CrossRepoDocInfo.DocType.COMMENT.getId()));
    }

    public T indexedBetween(long minIndexingTime, long maxIndexingTime) {
        this.query.add((Query)NumericRangeQuery.newLongRange((String)"indexTimestamp", (int)4, (Long)minIndexingTime, (Long)maxIndexingTime, (boolean)false, (boolean)true), BooleanClause.Occur.MUST);
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T withCommitter(String committerName) {
        if (Strings.emptyToNull((String)committerName) != null) {
            this.query.add(new BooleanClause((Query)new TermQuery(new Term("author", committerName.toLowerCase(Locale.US))), BooleanClause.Occur.MUST));
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public static TermQuery queryChangesetsDoctype() {
        return new TermQuery(new Term("doctype", CrossRepoDocInfo.DocType.CHANGESET.getId()));
    }

    public static ChangesetQueryBuilder newBuilder(String rep) {
        return new ChangesetQueryBuilder().fromRep(rep);
    }

    public static QueryBuilder newCrossRepoBuilder() {
        return new QueryBuilder();
    }

    public T fromRep(String rep) {
        this.query.add((Query)new TermQuery(new Term("rep", rep)), BooleanClause.Occur.MUST);
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T inDateRange(long minDate, long maxDate) {
        return this.inDateRange(new Date(minDate), new Date(maxDate));
    }

    public T inDateRange(Date minDate, Date maxDate) {
        this.minDate = minDate;
        this.maxDate = maxDate;
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    @Override
    public Query build() {
        BooleanQuery query = (BooleanQuery)super.build();
        LuceneHelper.addDateClause(query, this.minDate, this.maxDate);
        return query;
    }

    public T changesetsOnly() {
        this.setDocType((Query)ChangesetQueryBuilder.queryChangesetsDoctype());
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T changesetCommentsOnly() {
        this.changesetCommentsOnly = true;
        this.setDocType((Query)ChangesetQueryBuilder.getCommentDocTypeQuery());
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T commentsByUser(String username) {
        if (username != null) {
            this.query.add((Query)new TermQuery(new Term("cscommentauthor", username)), BooleanClause.Occur.MUST);
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T onPath(Path path) {
        if (path != null && !path.isRoot()) {
            this.query.add((Query)new TermQuery(new Term("pathcomponents", path.getPath())), BooleanClause.Occur.MUST);
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T changesetId(String csid) {
        if (Strings.emptyToNull((String)csid) != null) {
            this.query.add((Query)new TermQuery(new Term("csid", csid)), BooleanClause.Occur.MUST);
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T onAnyPath(List<Path> paths) {
        if (paths != null && !paths.isEmpty()) {
            if (paths.size() == 1) {
                return this.onPath(paths.get(0));
            }
            BooleanQuery bq = new BooleanQuery(true);
            for (Path path : paths) {
                if (path.isRoot()) continue;
                bq.add((Query)new TermQuery(new Term("pathcomponents", path.getPath())), BooleanClause.Occur.SHOULD);
            }
            if (!bq.clauses().isEmpty()) {
                this.query.add((Query)bq, BooleanClause.Occur.MUST);
            }
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T withComment(String comment) {
        if (!Strings.isNullOrEmpty((String)comment)) {
            BooleanQuery commentQuery = new BooleanQuery();
            ChangesetQueryBuilder.addCommentClause(commentQuery, comment);
            this.query.add((Query)commentQuery, BooleanClause.Occur.MUST);
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public T onBranch(String branch) {
        if (branch != null) {
            this.query.add((Query)new TermQuery(new Term("branch", branch.toLowerCase(Locale.US))), BooleanClause.Occur.MUST);
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    public static Filter noCrossRepoIdFilter() {
        BooleanFilter pre24filter = new BooleanFilter();
        pre24filter.add(new FilterClause((Filter)new HasTermFilter("crossid"), BooleanClause.Occur.MUST_NOT));
        return pre24filter;
    }

    public T lastModifiedIn(QuickSearchTimeBucket timeBucket) {
        if (timeBucket != QuickSearchTimeBucket.ANY_DATE) {
            int hoursSinceEpoch = TimeZoneVariables.reduceMillisToHours(timeBucket.getStartTime().getMillis());
            this.query.add((Query)NumericRangeQuery.newIntRange((String)"lastUpdateHours", (Integer)hoursSinceEpoch, null, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        return (T)((ChangesetQueryBuilder)this.getThis());
    }

    static TermQuery addTermClause(BooleanQuery bq, String value, String field, BooleanClause.Occur occur, boolean forceLowerCase) {
        if (value != null) {
            value = forceLowerCase ? value.toLowerCase(Locale.US) : value;
            TermQuery termQuery = new TermQuery(new Term(field, value));
            bq.add((Query)termQuery, occur);
            return termQuery;
        }
        return null;
    }

    static void addPrefixClause(BooleanQuery bq, String value, String field, BooleanClause.Occur occur, boolean forceLowerCase) {
        if (value != null) {
            value = forceLowerCase ? value.toLowerCase(Locale.US) : value;
            bq.add((Query)new PrefixQuery(new Term(field, value)), occur);
        }
    }

    static void addCommentClause(BooleanQuery bq, String comment) {
        ChangesetQueryBuilder.addCommentClause(bq, comment, BooleanClause.Occur.MUST, false);
    }

    static void addCommentClause(BooleanQuery bq, String comment, BooleanClause.Occur occur, boolean allowNonPhraseMatch) {
        if (comment != null) {
            WildcardQuery commentQuery;
            if (comment.startsWith("*") || comment.startsWith("?")) {
                comment = comment.substring(1);
            }
            if (comment.isEmpty()) {
                return;
            }
            if (comment.endsWith("*")) {
                commentQuery = new WildcardQuery(new Term("comment", comment));
            } else {
                FreeTextAnalyzer analyzer = new FreeTextAnalyzer();
                PhraseQuery wholePhraseQuery = LuceneUtils.parsePhrase(comment, "comment", analyzer);
                Iterable subPhrases = Splitter.on((Pattern)WORD_BOUNDARY).omitEmptyStrings().split((CharSequence)comment);
                if (allowNonPhraseMatch && !Iterables.isEmpty((Iterable)subPhrases)) {
                    BooleanQuery phraseOrWordsQuery = new BooleanQuery();
                    phraseOrWordsQuery.add(new BooleanClause((Query)wholePhraseQuery, BooleanClause.Occur.SHOULD));
                    wholePhraseQuery.setBoost(10.0f);
                    BooleanQuery wordsQuery = new BooleanQuery();
                    wordsQuery.setBoost(5.0f);
                    BooleanQuery someWordsQuery = new BooleanQuery();
                    for (String subPhrase : subPhrases) {
                        PhraseQuery subPhraseQuery = LuceneUtils.parsePhrase(subPhrase, "comment", analyzer);
                        wordsQuery.add(new BooleanClause((Query)subPhraseQuery, BooleanClause.Occur.MUST));
                        someWordsQuery.add(new BooleanClause((Query)subPhraseQuery, BooleanClause.Occur.SHOULD));
                    }
                    phraseOrWordsQuery.add(new BooleanClause((Query)wordsQuery, BooleanClause.Occur.SHOULD));
                    phraseOrWordsQuery.add(new BooleanClause((Query)someWordsQuery, BooleanClause.Occur.SHOULD));
                    commentQuery = phraseOrWordsQuery;
                } else {
                    commentQuery = wholePhraseQuery;
                }
            }
            bq.add((Query)commentQuery, occur);
        }
    }

    public static class QueryBuilder
    extends ChangesetQueryBuilder<QueryBuilder> {
        private static final float CHANGESET_ID_BOOST = 5.0f;
        private static final float EXACT_CHANGESET_ID_BOOST = 10.0f;
        private static final float RECENCY_BOOST_MULTIPLIER = 10.0f;
        private RepositoryConstraints constraints;

        @Override
        public QueryBuilder onPath(Path path) {
            throw new IllegalStateException("This builder does not support a single cross-repository path constraint. Use withConstraints() instead");
        }

        @Override
        public QueryBuilder onBranch(String branch) {
            throw new IllegalStateException("This builder does not support branch constraints.");
        }

        public QueryBuilder withCommentMatching(String commentSearchText, boolean allowNonPhraseCommentMatches) {
            if (!Strings.isNullOrEmpty((String)commentSearchText)) {
                BooleanQuery commentQuery = this.buildCommentQuery(commentSearchText, allowNonPhraseCommentMatches);
                if (commentQuery != null) {
                    this.query.add((Query)commentQuery, BooleanClause.Occur.MUST);
                }
                return this;
            }
            return this;
        }

        public QueryBuilder withAnyIssueKey(Iterable<String> issues) {
            BooleanQuery issueQuery = new BooleanQuery(true);
            for (String issue : issues) {
                QueryBuilder.addCommentClause(issueQuery, issue, BooleanClause.Occur.SHOULD, false);
                QueryBuilder.addCommentClause(issueQuery, "-" + issue, BooleanClause.Occur.MUST_NOT, false);
                QueryBuilder.addTermClause(issueQuery, issue, "p4.job", BooleanClause.Occur.SHOULD, true);
            }
            this.query.add((Query)issueQuery, BooleanClause.Occur.MUST);
            return this;
        }

        public QueryBuilder withCommitters(Multimap<String, String> repoCommiterMappings) {
            if (!repoCommiterMappings.isEmpty()) {
                BooleanQuery bq = new BooleanQuery();
                for (Map.Entry mapping : repoCommiterMappings.asMap().entrySet()) {
                    BooleanQuery repoQuery = new BooleanQuery();
                    String repo = (String)mapping.getKey();
                    QueryBuilder.addTermClause(repoQuery, repo, "rep", BooleanClause.Occur.MUST, false);
                    for (String committer : (Collection)mapping.getValue()) {
                        QueryBuilder.addTermClause(repoQuery, committer, "author", BooleanClause.Occur.SHOULD, true);
                    }
                    repoQuery.setMinimumNumberShouldMatch(1);
                    bq.add((Query)repoQuery, BooleanClause.Occur.SHOULD);
                }
                this.query.add((Query)bq, BooleanClause.Occur.MUST);
            }
            return this;
        }

        private BooleanQuery buildCommentQuery(String commentSearchText, boolean allowNonPhraseCommentMatches) {
            if (Strings.isNullOrEmpty((String)commentSearchText)) {
                return null;
            }
            BooleanQuery bq = new BooleanQuery(true);
            BooleanQuery commentOrJobFixed = new BooleanQuery();
            QueryBuilder.addCommentClause(commentOrJobFixed, commentSearchText, BooleanClause.Occur.SHOULD, allowNonPhraseCommentMatches);
            if (commentSearchText.contains("-")) {
                QueryBuilder.addTermClause(commentOrJobFixed, commentSearchText, "p4.job", BooleanClause.Occur.SHOULD, true);
            } else {
                QueryBuilder.addPrefixClause(commentOrJobFixed, commentSearchText, "p4.job", BooleanClause.Occur.SHOULD, true);
            }
            commentOrJobFixed.setMinimumNumberShouldMatch(1);
            bq.add((Query)commentOrJobFixed, BooleanClause.Occur.MUST);
            return bq;
        }

        public QueryBuilder withChangeSetId(String changeSetId) {
            if (!Strings.isNullOrEmpty((String)changeSetId)) {
                this.query.add((Query)this.buildChangeSetQuery(changeSetId), BooleanClause.Occur.MUST);
            }
            return this;
        }

        private BooleanQuery buildChangeSetQuery(String changeSetId) {
            BooleanQuery bq = new BooleanQuery(true);
            TermQuery exactChangesetQuery = QueryBuilder.addTermClause(bq, changeSetId, "csid", BooleanClause.Occur.SHOULD, false);
            exactChangesetQuery.setBoost(10.0f);
            QueryBuilder.addPrefixClause(bq, changeSetId, "csid", BooleanClause.Occur.SHOULD, false);
            return bq;
        }

        public QueryBuilder withChangeSetIdOrCommentMatching(String csid, String comment, boolean allowNonPhraseCommentMatches) {
            boolean isSetComment;
            boolean isSetCsid = !Strings.isNullOrEmpty((String)csid);
            boolean bl = isSetComment = !Strings.isNullOrEmpty((String)comment);
            if (isSetComment && !isSetCsid) {
                this.withCommentMatching(comment, allowNonPhraseCommentMatches);
            } else if (isSetCsid && !isSetComment) {
                this.withChangeSetId(csid);
            } else if (isSetCsid) {
                BooleanQuery bq = new BooleanQuery(true);
                BooleanQuery changeSetQuery = this.buildChangeSetQuery(csid);
                changeSetQuery.setBoost(5.0f);
                bq.add((Query)changeSetQuery, BooleanClause.Occur.SHOULD);
                bq.add((Query)this.buildCommentQuery(comment, allowNonPhraseCommentMatches), BooleanClause.Occur.SHOULD);
                this.query.add((Query)bq, BooleanClause.Occur.MUST);
            } else {
                this.query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            }
            return this;
        }

        public QueryBuilder boostByRecency() {
            BooleanQuery bq = new BooleanQuery(true);
            bq.add((Query)new RecencyBoostingQuery((Query)this.query, 10.0f, "lastUpdateHours"), BooleanClause.Occur.MUST);
            this.query = bq;
            return this;
        }

        public QueryBuilder withRepoConstraints(RepositoryConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Query build() {
            if (this.constraints == null) return super.build();
            if (this.constraints.getReps().size() == 0) {
                return super.build();
            }
            HashSet<String> excludedReps = new HashSet<String>();
            HashSet<String> includedReps = new HashSet<String>();
            for (RepositoryConstraints.RepositoryConstraint constraint : this.constraints.getConstraints()) {
                if (constraint.isExcludeWholeRepository()) {
                    excludedReps.add(constraint.getRepository());
                    continue;
                }
                if (constraint.isIncludeWholeRepository()) {
                    includedReps.add(constraint.getRepository());
                    continue;
                }
                excludedReps.clear();
                includedReps.clear();
                break;
            }
            if (includedReps.size() > 0 || excludedReps.size() > 0) {
                if (includedReps.size() < excludedReps.size()) {
                    if (includedReps.size() == 0) {
                        this.notFromTheseRepos(excludedReps);
                        this.addAuthorClause(this.getQuery());
                        return super.build();
                    }
                    this.fromTheseRepos(includedReps);
                    this.addAuthorClauseWithExclusions(this.getQuery());
                    return super.build();
                }
                if (excludedReps.size() == 0) {
                    this.fromTheseRepos(includedReps);
                    this.addAuthorClauseWithExclusions(this.getQuery());
                    return super.build();
                }
                this.notFromTheseRepos(excludedReps);
                this.addAuthorClauseWithExclusions(this.getQuery());
                return super.build();
            }
            BooleanQuery repoConstraints = new BooleanQuery(true);
            for (RepositoryConstraints.RepositoryConstraint constraint : this.constraints.getConstraints()) {
                if (constraint.isExcludeWholeRepository()) continue;
                BooleanQuery perRepoConstraint = new BooleanQuery(true);
                perRepoConstraint.add((Query)new TermQuery(new Term("rep", constraint.getRepository())), BooleanClause.Occur.MUST);
                if (!(this.changesetCommentsOnly || constraint.getCommitters().isEmpty() && constraint.getPaths().isEmpty())) {
                    BooleanQuery pathOrCommitterConstraints = new BooleanQuery(true);
                    for (Path path : constraint.getPaths()) {
                        pathOrCommitterConstraints.add((Query)new TermQuery(new Term("path", path.getPath())), BooleanClause.Occur.SHOULD);
                    }
                    for (String committer : constraint.getCommitters()) {
                        QueryBuilder.addTermClause(pathOrCommitterConstraints, committer, "author", BooleanClause.Occur.SHOULD, true);
                    }
                    perRepoConstraint.add((Query)pathOrCommitterConstraints, BooleanClause.Occur.MUST);
                }
                repoConstraints.add((Query)perRepoConstraint, BooleanClause.Occur.SHOULD);
            }
            if (this.changesetCommentsOnly && !this.constraints.getUsers().isEmpty()) {
                this.addAuthorClauseWithExclusions(repoConstraints);
                return super.build();
            }
            this.query.add((Query)repoConstraints, BooleanClause.Occur.MUST);
            return super.build();
        }

        private void addAuthorClauseWithExclusions(BooleanQuery originalQuery) {
            if (this.changesetCommentsOnly && !this.constraints.getUsers().isEmpty()) {
                BooleanQuery changesetCommentAnyRepo = new BooleanQuery(true);
                BooleanQuery exclusions = new BooleanQuery(true);
                for (RepositoryConstraints.RepositoryConstraint constraint : this.constraints.getConstraints()) {
                    if (!constraint.isExcludeWholeRepository()) continue;
                    exclusions.add((Query)new TermQuery(new Term("rep", constraint.getRepository())), BooleanClause.Occur.SHOULD);
                }
                if (!exclusions.clauses().isEmpty()) {
                    changesetCommentAnyRepo.add((Query)exclusions, BooleanClause.Occur.MUST_NOT);
                }
                changesetCommentAnyRepo.add((Query)this.createAuthorQuery(), BooleanClause.Occur.MUST);
                this.query = new BooleanQuery(true);
                BooleanQuery mustQuery = new BooleanQuery(true);
                mustQuery.add((Query)originalQuery, BooleanClause.Occur.SHOULD);
                mustQuery.add((Query)changesetCommentAnyRepo, BooleanClause.Occur.SHOULD);
                this.query.add((Query)mustQuery, BooleanClause.Occur.MUST);
            }
        }

        private void addAuthorClause(BooleanQuery query) {
            if (this.changesetCommentsOnly && !this.constraints.getUsers().isEmpty()) {
                BooleanQuery userQuery = this.createAuthorQuery();
                query.add((Query)userQuery, BooleanClause.Occur.MUST);
            }
        }

        private BooleanQuery createAuthorQuery() {
            BooleanQuery userQuery = new BooleanQuery(true);
            for (String name : this.constraints.getUsers()) {
                QueryBuilder.addTermClause(userQuery, name, "cscommentauthor", BooleanClause.Occur.SHOULD, false);
            }
            return userQuery;
        }
    }
}

