/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.crucible.explorers.ChangeSetPair;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.AbstractChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.csindex.ChangesetIndexDateFormatter;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

public class ChangesetDocInfo
extends AbstractChangesetDocInfo {
    protected static final String DATE_DAY_OF_MONTH = "dDay";
    public static final String DATE_DAY_OF_WEEK = "dDayOfWeek";
    public static final String DATE_HOUR_OF_DAY = "dHourOfDay";
    public static final String DATE_YEAR_WEEK = "dYearWeek";
    public static final String DATE_YEAR_MONTH = "dYearMonth";
    protected static final String CROSSREPO_ID = "crossid";
    protected static final String FIRST_INDEXED_TIMESTAMP = "indexTimestamp";
    @FieldInfo
    private final Fieldable crossRepoId;
    @FieldInfo
    private final Fieldable dateDayOfMonth;
    @FieldInfo
    private final Fieldable dateYearMonth;
    @FieldInfo
    private final Fieldable dateYearWeek;
    @FieldInfo
    private final Fieldable dateDayOfWeek;
    @FieldInfo
    private final Fieldable dateHourOfDay;
    @FieldInfo
    private final List<Fieldable> paths;
    @FieldInfo
    private final Collection<Fieldable> parentPaths;
    @FieldInfo
    private final Collection<Fieldable> ancestorPaths;
    @FieldInfo
    private final Collection<Fieldable> fileNames;
    @FieldInfo
    private final Collection<Fieldable> extensions;
    @FieldInfo
    private final NumericField firstIndexed;
    public static final DocConverter<ChangesetDocInfo> CONVERTER_REP_CSID_ONLY = new DocConverter<ChangesetDocInfo>(){

        @Override
        public ChangesetDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, LuceneUtils.multipleFieldsSelector("rep", "csid"));
            return new ChangesetDocInfo(doc.getFieldable("csid"), doc.getFieldable("rep"));
        }
    };
    public static final DocConverter<String> CONVERTER_CSID_ONLY = new DocConverter<String>(){

        @Override
        public String convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, LuceneUtils.singleFieldSelector("csid"));
            return doc.getFieldable("csid").stringValue();
        }
    };
    public static final DocConverter<ChangesetDocInfo> CONVERTER = new DocConverter<ChangesetDocInfo>(){
        private final FieldSelector RESULT_SELECTOR = LuceneUtils.multipleFieldsSelector("csid", "rep", "comment", "author", "dTimeMillis");

        @Override
        public ChangesetDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.RESULT_SELECTOR);
            return ChangesetDocInfo.convertDocumentToChangesetDocInfo(doc);
        }
    };

    public ChangesetDocInfo(ChangesetDoc csDoc, boolean isUpdate) {
        this(csDoc, isUpdate ? 0L : System.currentTimeMillis());
    }

    @VisibleForTesting
    public ChangesetDocInfo(ChangesetDoc csDoc, long indexTimestamp) {
        super(CrossRepoDocInfo.DocType.CHANGESET, csDoc, new Date(csDoc.getDate()));
        Date date = new Date(csDoc.getDate());
        this.crossRepoId = new Field(CROSSREPO_ID, csDoc.getCrossRepoId(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        this.dateDayOfMonth = ChangesetDocInfo.makeDateDayOfMonthField(date);
        this.dateYearMonth = ChangesetDocInfo.makeDateYearMonthField(date);
        this.dateYearWeek = this.makeDateYearWeekField(date);
        this.dateDayOfWeek = this.makeDateDayOfWeekField(date);
        this.dateHourOfDay = this.makeDateHourOfDayField(date);
        HashSet parentPaths = Sets.newHashSet();
        HashSet fileNames = Sets.newHashSet();
        HashSet extensions = Sets.newHashSet();
        HashSet ancestorPaths = Sets.newHashSet();
        this.paths = ChangesetDocInfo.buildPathFields(csDoc, parentPaths, fileNames, extensions, ancestorPaths);
        this.parentPaths = Collections2.transform((Collection)parentPaths, (Function)Functions.compose((Function)new StringPathToFieldFunction("parentdir", false), (Function)new PathToStringFunction()));
        this.ancestorPaths = Collections2.transform((Collection)ancestorPaths, (Function)Functions.compose((Function)new StringPathToFieldFunction("pathcomponents", false), (Function)new PathToStringFunction()));
        this.fileNames = Collections2.transform((Collection)fileNames, (Function)new StringPathToFieldFunction("name", true));
        this.extensions = Collections2.transform((Collection)extensions, (Function)new StringPathToFieldFunction("xtn", true));
        this.firstIndexed = ChangesetDocInfo.makeFirstIndexedField(indexTimestamp);
    }

    private ChangesetDocInfo(Fieldable changesetId, Fieldable repository, Fieldable commitMessage, Fieldable author, Date eventDate) {
        super(CrossRepoDocInfo.DocType.CHANGESET, changesetId, repository, commitMessage, author, eventDate, null, null);
        this.dateDayOfMonth = null;
        this.dateYearMonth = null;
        this.dateYearWeek = null;
        this.dateDayOfWeek = null;
        this.dateHourOfDay = null;
        this.paths = null;
        this.parentPaths = null;
        this.ancestorPaths = null;
        this.fileNames = null;
        this.extensions = null;
        this.firstIndexed = null;
        this.crossRepoId = null;
    }

    private ChangesetDocInfo(Fieldable changesetId, Fieldable repository, Fieldable author, Date eventDate) {
        this(changesetId, repository, null, author, eventDate);
    }

    private ChangesetDocInfo(Fieldable changesetId, Fieldable repository) {
        this(changesetId, repository, null, null, null);
    }

    private static NumericField makeFirstIndexedField(long indexTimestamp) {
        return new NumericField(FIRST_INDEXED_TIMESTAMP, Field.Store.NO, true).setLongValue(indexTimestamp);
    }

    private Field makeDateHourOfDayField(Date date) {
        return new Field(DATE_HOUR_OF_DAY, dateFormatter.formatHourOfDay(date), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    private Field makeDateDayOfWeekField(Date date) {
        return new Field(DATE_DAY_OF_WEEK, dateFormatter.formatDayOfWeek(date), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    private Field makeDateYearWeekField(Date date) {
        return new Field(DATE_YEAR_WEEK, ChangesetIndexDateFormatter.formatYearWeek(date), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    private static Field makeDateYearMonthField(Date date) {
        return new Field(DATE_YEAR_MONTH, dateFormatter.formatYearMonth(date), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    private static Field makeDateDayOfMonthField(Date date) {
        return new Field(DATE_DAY_OF_MONTH, dateFormatter.formatDayOfMonth(date), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    @Override
    public Term getKeyTerm() {
        return new Term(this.crossRepoId.name(), this.crossRepoId.stringValue());
    }

    @Override
    public Analyzer getAnalyzer() {
        return LuceneUtils.createPerFieldAnalyzer(new FreeTextAnalyzer());
    }

    private static Field addPath(Path p2, Set<Path> parentPaths, Set<String> names, Set<String> extensions, Set<Path> ancestorPaths) {
        Field pathField = new Field("path", p2.getPath(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
        if (!p2.isRoot()) {
            parentPaths.add(p2.getParent());
            String name = p2.getName();
            names.add(name);
            String ext = p2.getExtension();
            if (ext != null) {
                extensions.add(ext);
            }
        }
        while (p2 != null && ancestorPaths.add(p2)) {
            p2 = p2.getParent();
        }
        return pathField;
    }

    public static List<Fieldable> buildPathFields(ChangesetDoc csDoc, Set<Path> parentPaths, Set<String> names, Set<String> extensions, Set<Path> ancestorPaths) {
        ImmutableList.Builder pathFields = ImmutableList.builder();
        boolean count = false;
        for (Path path : csDoc.getPaths()) {
            if (path == null) continue;
            pathFields.add((Object)ChangesetDocInfo.addPath(path, parentPaths, names, extensions, ancestorPaths));
        }
        return pathFields.build();
    }

    public static ChangesetDocInfo fromSearchHitRepCsidOnly(IndexSearcher searcher, ScoreDoc hit) throws IOException {
        return CONVERTER_REP_CSID_ONLY.convert(searcher, hit);
    }

    public static ChangesetDocInfo devSummary(IndexReader reader, int docid) throws IOException {
        Document doc = reader.document(docid, LuceneUtils.multipleFieldsSelector("rep", "csid", "author", "dTimeMillis"));
        return new ChangesetDocInfo(doc.getFieldable("csid"), doc.getFieldable("rep"), doc.getFieldable("author"), LuceneHelper.parseDate(doc.get("dTimeMillis")));
    }

    public static ChangesetDocInfo devDetails(IndexReader reader, int docid) throws IOException {
        Document doc = reader.document(docid, LuceneUtils.multipleFieldsSelector("rep", "csid", "author", "dTimeMillis", "comment"));
        return ChangesetDocInfo.convertDocumentToChangesetDocInfo(doc);
    }

    public static ChangeSetPair changesetId(IndexReader reader, int docid) throws IOException {
        Document doc = reader.document(docid, LuceneUtils.multipleFieldsSelector("rep", "csid"));
        return ChangeSetPair.newInstance(doc.getFieldable("rep").stringValue(), doc.getFieldable("csid").stringValue());
    }

    public static ChangesetDocInfo fromSearchHit(IndexSearcher searcher, ScoreDoc hit) throws IOException {
        return CONVERTER.convert(searcher, hit);
    }

    private static ChangesetDocInfo convertDocumentToChangesetDocInfo(Document doc) {
        return new ChangesetDocInfo(doc.getFieldable("csid"), doc.getFieldable("rep"), doc.getFieldable("comment"), doc.getFieldable("author"), LuceneHelper.parseDate(doc.get("dTimeMillis")));
    }

    private static class StringPathToFieldFunction
    implements Function<String, Fieldable> {
        private final String fieldName;
        private final boolean lowerCase;

        public StringPathToFieldFunction(String fieldName, boolean lowerCase) {
            this.fieldName = fieldName;
            this.lowerCase = lowerCase;
        }

        public Field apply(String input) {
            return new Field(this.fieldName, this.lowerCase ? input.toLowerCase(Locale.US) : input, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
        }
    }

    private static class PathToStringFunction
    implements Function<Path, String> {
        private PathToStringFunction() {
        }

        public String apply(Path input) {
            return input.getPath();
        }
    }
}

