/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.crossrepo.BatchableDoc;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4ChangeSet;
import com.cenqua.fisheye.rep.ChangeSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class ChangesetDoc
implements BatchableDoc {
    private final long date;
    private final String id;
    private final String repName;
    private final String crossRepoId;
    private final String comment;
    private final String author;
    private final Set<String> p4Fixes;
    private final Set<String> branches;
    private final Collection<Path> paths;

    public long getDate() {
        return this.date;
    }

    public String getId() {
        return this.id;
    }

    public String getRepName() {
        return this.repName;
    }

    public String getCrossRepoId() {
        return this.crossRepoId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getAuthor() {
        return this.author;
    }

    @Nonnull
    public Set<String> getP4Fixes() {
        return this.p4Fixes;
    }

    @Nonnull
    public Set<String> getBranches() {
        return this.branches;
    }

    @Nonnull
    public Collection<Path> getPaths() {
        return this.paths;
    }

    private ChangesetDoc(long date, String id, String repName, String crossRepoId, String comment, String author, Set<String> p4Fixes, Set<String> branches, Collection<Path> paths) {
        this.date = date;
        this.id = id;
        this.repName = repName;
        this.crossRepoId = crossRepoId;
        this.comment = comment;
        this.author = author;
        this.p4Fixes = p4Fixes;
        this.branches = null == branches ? Collections.emptySet() : branches;
        this.paths = paths;
    }

    @Nonnull
    private static Set<String> getP4Fixes(@Nonnull ChangeSet changeSet) {
        if (changeSet instanceof P4ChangeSet) {
            return ImmutableSet.copyOf(((P4ChangeSet)changeSet).getFixes());
        }
        return Collections.emptySet();
    }

    @Nonnull
    private static Collection<Path> getPaths(ChangeSet changeSet) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int count = 0;
        for (Path path : changeSet.getPaths()) {
            if (path == null) continue;
            if (++count > FishEyeSysProps.CHANGESET_PATHS_LIMIT) {
                Logs.APP_LOG.info((Object)("Changeset " + changeSet.getDisplayId() + ": indexed paths truncated at " + FishEyeSysProps.CHANGESET_PATHS_LIMIT));
                break;
            }
            builder.add((Object)path);
        }
        return builder.build();
    }

    public static ChangesetDoc fromChangeSet(ChangeSet changeSet) {
        Preconditions.checkNotNull((Object)changeSet);
        return new ChangesetDoc(changeSet.getDate(), changeSet.getId(), changeSet.getRepName(), changeSet.getCrossRepoId(), changeSet.getComment(), changeSet.getAuthor(), ChangesetDoc.getP4Fixes(changeSet), changeSet.getBranches(), ChangesetDoc.getPaths(changeSet));
    }

    @Override
    public int getWeight() {
        return (StringUtils.length((String)this.author) + StringUtils.length((String)this.comment) + StringUtils.length((String)this.crossRepoId)) / 100 + 1 + this.getPaths().size() + this.getBranches().size() / 25;
    }
}

