/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.cenqua.fisheye.crossrepo.AbstractChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetCommentDoc;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import java.io.IOException;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

public class ChangesetCommentDocInfo
extends AbstractChangesetDocInfo {
    protected static final String CS_COMMENT = "cscomment";
    protected static final String CS_COMMENT_ID = "cscommentid";
    protected static final String CS_COMMENT_AUTHOR = "cscommentauthor";
    @FieldInfo
    private final Fieldable changesetComment;
    @FieldInfo
    private final Fieldable changesetCommentId;
    @FieldInfo
    private final Fieldable changesetCommentAuthor;
    public static final DocConverter<ChangesetCommentDocInfo> ID_ONLY_CONVERTER = new DocConverter<ChangesetCommentDocInfo>(){
        private final FieldSelector SELECTOR = LuceneUtils.singleFieldSelector("cscommentid");

        @Override
        public ChangesetCommentDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.SELECTOR);
            return new ChangesetCommentDocInfo(doc.getFieldable(ChangesetCommentDocInfo.CS_COMMENT_ID), null, null);
        }
    };

    public ChangesetCommentDocInfo(ChangesetCommentDoc csCommentDoc) {
        super(CrossRepoDocInfo.DocType.COMMENT, csCommentDoc.getChangesetDoc(), new Date(csCommentDoc.getTimestamp()));
        this.changesetComment = new Field(CS_COMMENT, csCommentDoc.getMessage(), Field.Store.NO, Field.Index.ANALYZED);
        this.changesetCommentId = new Field(CS_COMMENT_ID, String.valueOf(csCommentDoc.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        this.changesetCommentAuthor = new Field(CS_COMMENT_AUTHOR, csCommentDoc.getAuthor(), Field.Store.NO, Field.Index.ANALYZED);
    }

    private ChangesetCommentDocInfo(Fieldable changesetCommentId, Fieldable changesetId, Fieldable repository) {
        super(CrossRepoDocInfo.DocType.COMMENT, changesetId, repository, null, null, null, null, null);
        this.changesetCommentId = changesetCommentId;
        this.changesetCommentAuthor = null;
        this.changesetComment = null;
    }

    public static String commentIdfromSearchHit(IndexSearcher searcher, ScoreDoc hit) throws IOException {
        return ID_ONLY_CONVERTER.convert(searcher, hit).getChangesetCommentId();
    }

    @Override
    public Term getKeyTerm() {
        return new Term(this.changesetCommentId.name(), this.changesetCommentId.stringValue());
    }

    @Override
    public Analyzer getAnalyzer() {
        return LuceneUtils.createPerFieldAnalyzer(new FreeTextAnalyzer());
    }

    public String getChangesetCommentId() {
        return this.changesetCommentId.stringValue();
    }
}

