/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fisheye.model.ChangesetComment;
import com.cenqua.fisheye.crossrepo.BatchableDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.rep.ChangeSet;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;

public class ChangesetCommentDoc
implements BatchableDoc {
    private final ChangesetDoc changesetDoc;
    private final ChangesetComment.Info commentInfo;

    public ChangesetDoc getChangesetDoc() {
        return this.changesetDoc;
    }

    public long getTimestamp() {
        return this.commentInfo.getTimestamp();
    }

    public String getMessage() {
        return this.commentInfo.getMessage();
    }

    public Integer getId() {
        return this.commentInfo.getId();
    }

    public String getAuthor() {
        return this.commentInfo.getAuthor();
    }

    private ChangesetCommentDoc(ChangesetDoc changesetDoc, ChangesetComment.Info info) {
        this.changesetDoc = changesetDoc;
        this.commentInfo = info;
    }

    public static ChangesetCommentDoc fromChangeSetComment(ChangeSet changeset, ChangesetComment.Info comment) {
        Preconditions.checkNotNull((Object)comment);
        return new ChangesetCommentDoc(ChangesetDoc.fromChangeSet(changeset), comment);
    }

    @Override
    public int getWeight() {
        return (int)((double)this.changesetDoc.getWeight() + (double)(StringUtils.length((String)this.getAuthor()) + StringUtils.length((String)this.getMessage())) / 100.0);
    }
}

