/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.spi.services.ChangesetMetricsService;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.csindex.ChangesetIndexDateFormatter;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class ChangesetCannedQueries {
    public static Query metricsServiceQuery(String repname, ChangesetMetricsService.QueryParameters params) {
        BooleanQuery bq = new BooleanQuery(true);
        LuceneHelper.addDateClause(bq, params.getMinDate(), params.getMaxDate());
        if (params.getHourOfDay() != null) {
            ChangesetCannedQueries.addTermClause(bq, ChangesetCannedQueries.padToTwoFigures(params.getHourOfDay().toString()), "dHourOfDay", true);
        }
        if (params.getDayOfWeek() != null) {
            bq.add((Query)new TermQuery(new Term("dDayOfWeek", ChangesetCannedQueries.toDayOfWeek(params.getDayOfWeek()))), BooleanClause.Occur.MUST);
        }
        if (params.getDayOfMonth() != null) {
            ChangesetCannedQueries.addTermClause(bq, ChangesetCannedQueries.padToTwoFigures(params.getDayOfMonth().toString()), "dDay", true);
        }
        ChangesetCannedQueries.addTermClause(bq, repname, "rep", false);
        ChangesetCannedQueries.addTermClause(bq, params.getCommitter(), "author", true);
        ChangesetCannedQueries.addTermClause(bq, params.getBranch(), "branch", true);
        ChangesetQueryBuilder.addPrefixClause(bq, params.getFileName(), "name", BooleanClause.Occur.MUST, true);
        ChangesetCannedQueries.addTermClause(bq, params.getFileExtension(), "xtn", true);
        ChangesetCannedQueries.addPathClause(bq, params.getPath());
        ChangesetQueryBuilder.addCommentClause(bq, params.getComment());
        return ChangesetCannedQueries.addChangesetDocTypeRestriction(ChangesetCannedQueries.matchAllIfNoCriteria(bq));
    }

    public static Pair<Query, Option<Predicate<ChangeSet>>> recentChangesQuery(Map<String, RecentChangesParams2> repsToSearch, RevisionCache revisionCache, Date minDate, Date maxDate) throws DbException {
        BooleanQuery crossRepoQuery = new BooleanQuery();
        Option changesetPredicate = Option.none();
        for (Map.Entry<String, RecentChangesParams2> e2 : repsToSearch.entrySet()) {
            String rep = e2.getKey();
            RecentChangesParams2 params = e2.getValue();
            BooleanQuery repoQuery = new BooleanQuery(true);
            BooleanQuery anyOf = new BooleanQuery(true);
            if (rep != null) {
                ChangesetCannedQueries.addTermClause(repoQuery, rep, "rep", false);
            }
            ChangesetCannedQueries.addPathClause(repoQuery, params.getBasePath());
            ChangesetCannedQueries.addCommitterClause(repoQuery, anyOf, params.getCompulsoryCommitter(), params.getAnyCommitters());
            ChangesetCannedQueries.addAnyOfPaths(anyOf, params);
            if (!Strings.isNullOrEmpty((String)params.getBranch())) {
                if (repsToSearch.size() == 1) {
                    if (revisionCache != null && revisionCache.getRepositoryType() == ScmType.GIT && revisionCache.getScanProperty(CommonProperties.GIT_CHANGESETS_TO_REINDEX.value, 0L) > 0L && (maxDate != null || params.getMaxReturn() > 100 || params.getSearchDirection() != 0)) {
                        changesetPredicate = Option.option(ChangesetCannedQueries.changesetInBranchPredicate(params.getBranch()));
                    } else {
                        ChangesetCannedQueries.addTermClause(repoQuery, params.getBranch(), "branch", true);
                    }
                } else {
                    Logs.APP_LOG.warn((Object)"Requested branch search for multiple repositories, ignoring");
                }
            }
            ChangesetQueryBuilder.addPrefixClause(repoQuery, params.getFileName(), "name", BooleanClause.Occur.MUST, true);
            ChangesetCannedQueries.addTermClause(repoQuery, params.getFileExtension(), "xtn", true);
            if (!Strings.isNullOrEmpty((String)params.getCommentSearchText()) && !Strings.isNullOrEmpty((String)params.getP4JobFixed())) {
                BooleanQuery commentOrJobFixed = new BooleanQuery();
                ChangesetQueryBuilder.addCommentClause(commentOrJobFixed, params.getCommentSearchText(), BooleanClause.Occur.SHOULD, false);
                ChangesetQueryBuilder.addTermClause(commentOrJobFixed, params.getP4JobFixed(), "p4.job", BooleanClause.Occur.SHOULD, true);
                commentOrJobFixed.setMinimumNumberShouldMatch(1);
                repoQuery.add((Query)commentOrJobFixed, BooleanClause.Occur.MUST);
            } else {
                ChangesetQueryBuilder.addCommentClause(repoQuery, params.getCommentSearchText());
                ChangesetCannedQueries.addTermClause(repoQuery, params.getP4JobFixed(), "p4.job", true);
            }
            if (!anyOf.clauses().isEmpty()) {
                repoQuery.add((Query)anyOf, BooleanClause.Occur.MUST);
            }
            Query finalRepoQuery = ChangesetCannedQueries.matchAllIfNoCriteria(repoQuery);
            crossRepoQuery.add(finalRepoQuery, BooleanClause.Occur.SHOULD);
        }
        Query resultQuery = ChangesetCannedQueries.addChangesetDocTypeRestriction((Query)crossRepoQuery);
        if (minDate != null || maxDate != null) {
            resultQuery = LuceneHelper.combineQueries(BooleanClause.Occur.MUST, resultQuery, ((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().inDateRange(minDate, maxDate)).build());
        }
        return Pair.pair((Object)resultQuery, (Object)changesetPredicate);
    }

    public static Query activityItemQuery(ActivityItemSearchParams params) {
        BooleanQuery bq = new BooleanQuery(true);
        LuceneHelper.addDateClause(bq, params.getMinDate(), params.getMaxDate());
        ChangesetCannedQueries.addTermClause(bq, params.getRepFilter(), "rep", false);
        ChangesetCannedQueries.addTermClause(bq, params.getBranch(), "branch", true);
        ChangesetQueryBuilder.addPrefixClause(bq, params.getFileName(), "name", BooleanClause.Occur.MUST, true);
        ChangesetCannedQueries.addTermClause(bq, params.getFileExtension(), "xtn", true);
        BooleanQuery anyOf = new BooleanQuery(true);
        ChangesetCannedQueries.addCommitterClause(bq, anyOf, params.getCompulsoryCommitter(), params.getCommitters());
        if (!params.getPaths().isEmpty() && !params.getPaths().contains(Path.ROOT)) {
            BooleanQuery paths = new BooleanQuery(true);
            for (Path path : params.getPaths()) {
                if (path == null || path.numComponents() <= 0) continue;
                paths.add((Query)new TermQuery(new Term("pathcomponents", path.getPath())), BooleanClause.Occur.SHOULD);
            }
            bq.add((Query)paths, BooleanClause.Occur.MUST);
        }
        if (anyOf.getClauses().length != 0) {
            bq.add((Query)anyOf, BooleanClause.Occur.MUST);
        }
        ChangesetQueryBuilder.addCommentClause(bq, params.getCommentSearchText());
        return ChangesetCannedQueries.addChangesetDocTypeRestriction(ChangesetCannedQueries.matchAllIfNoCriteria(bq));
    }

    public static Query comittersOnPathQuery(String rep, String branch, List<String> committers, Path path) {
        if (Strings.isNullOrEmpty((String)rep) && (committers == null || committers.size() == 0) && (path == null || path.isRoot())) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery bq = new BooleanQuery();
        if (!Strings.isNullOrEmpty((String)rep)) {
            ChangesetCannedQueries.addTermClause(bq, rep, "rep", false);
        }
        if (!Strings.isNullOrEmpty((String)branch)) {
            ChangesetCannedQueries.addTermClause(bq, branch, "branch", true);
        }
        if (committers != null && !committers.isEmpty()) {
            BooleanQuery bqCommmitters = new BooleanQuery();
            for (String committer : committers) {
                ChangesetQueryBuilder.addTermClause(bqCommmitters, committer, "author", BooleanClause.Occur.SHOULD, true);
            }
            bq.add((Query)bqCommmitters, BooleanClause.Occur.MUST);
        }
        if (path != null && !path.isRoot()) {
            ChangesetCannedQueries.addTermClause(bq, path.toString(), "pathcomponents", false);
        }
        return ChangesetCannedQueries.addChangesetDocTypeRestriction((Query)bq);
    }

    public static Query commiterMappingsQuery(Multimap<String, String> committerMappings) {
        BooleanQuery committerQuery = new BooleanQuery();
        for (Map.Entry entry : committerMappings.entries()) {
            committerQuery.add(((ChangesetQueryBuilder)ChangesetQueryBuilder.newBuilder((String)entry.getKey()).withCommitter((String)entry.getValue())).build(), BooleanClause.Occur.SHOULD);
        }
        return LuceneHelper.combineQueries(BooleanClause.Occur.MUST, new Query[]{committerQuery, ChangesetQueryBuilder.queryChangesetsDoctype()});
    }

    public static ChangesetQueryBuilder changesetsForIssueKeys(Iterable<String> issueKeys) {
        return ((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withAnyIssueKey(issueKeys);
    }

    private static void addPathClause(BooleanQuery bq, String path) {
        Path p2;
        if (path != null && (p2 = new Path(path)).numComponents() > 0) {
            ChangesetCannedQueries.addTermClause(bq, p2.toString(), "pathcomponents", false);
        }
    }

    private static String toDayOfWeek(Integer dayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.set(7, dayOfWeek);
        return ChangesetIndexDateFormatter.IndexedDateFormat.DAY_OF_WEEK.getDateFormat().format(cal.getTime());
    }

    private static String padToTwoFigures(String day) {
        if (day.length() == 1) {
            day = "0" + day;
        }
        return day;
    }

    private static void addPathClause(BooleanQuery bq, Path basePath) {
        if (!basePath.isRoot()) {
            bq.add((Query)new TermQuery(new Term("pathcomponents", basePath.getPath())), BooleanClause.Occur.MUST);
        }
    }

    private static void addCommitterClause(BooleanQuery bq, BooleanQuery anyOf, String committer, Collection<String> committers) {
        if (committer != null) {
            ChangesetCannedQueries.addTermClause(bq, committer, "author", true);
        } else {
            for (String commiter : committers) {
                ChangesetQueryBuilder.addTermClause(anyOf, commiter, "author", BooleanClause.Occur.SHOULD, true);
            }
        }
    }

    private static Query matchAllIfNoCriteria(BooleanQuery bq) {
        if (bq.clauses().isEmpty()) {
            return new MatchAllDocsQuery();
        }
        return bq;
    }

    private static void addAnyOfPaths(BooleanQuery anyOf, RecentChangesParams2 params) {
        if (!params.isAnyPathsContainsRoot()) {
            for (Path p2 : params.getAnyPaths()) {
                anyOf.add((Query)new TermQuery(new Term("pathcomponents", p2.getPath())), BooleanClause.Occur.SHOULD);
            }
        }
    }

    private static TermQuery addTermClause(BooleanQuery bq, String value, String field, boolean forceLowerCase) {
        return ChangesetQueryBuilder.addTermClause(bq, value, field, BooleanClause.Occur.MUST, forceLowerCase);
    }

    private static Query addChangesetDocTypeRestriction(Query q2) {
        BooleanQuery bq = new BooleanQuery();
        bq.add(q2, BooleanClause.Occur.MUST);
        bq.add((Query)ChangesetQueryBuilder.queryChangesetsDoctype(), BooleanClause.Occur.MUST);
        return bq;
    }

    private static Predicate<ChangeSet> changesetInBranchPredicate(final String branch) {
        return new Predicate<ChangeSet>(){

            public boolean apply(ChangeSet changeset) {
                return changeset.isInBranch(branch);
            }
        };
    }
}

