/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.cenqua.fisheye.crossrepo.AbstractRepositoryQueryBuilder;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.cenqua.fisheye.rep.BranchState;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class BranchQueryBuilder<T extends BranchQueryBuilder>
extends AbstractRepositoryQueryBuilder<T> {
    private Set<BranchState> excludedBranchStates = Sets.newHashSet((Object[])new BranchState[]{BranchState.REMOVED});

    public static BranchQueryBuilder<BranchQueryBuilder> newInstance() {
        return new BranchQueryBuilder<BranchQueryBuilder>();
    }

    private BranchQueryBuilder() {
        this.setDocType(BranchQueryBuilder.queryByDocType());
    }

    public static Query queryByDocType() {
        return new TermQuery(new Term("doctype", CrossRepoDocInfo.DocType.BRANCH.getId()));
    }

    public T withIssueKey(Iterable<String> issueKeys) {
        return this.withAnyStringInName(issueKeys);
    }

    public T withAnyStringInName(Iterable<String> strings) {
        BooleanQuery stringsQuery = new BooleanQuery();
        for (String string : strings) {
            PhraseQuery stringQuery = LuceneUtils.parsePhrase(string, "branch", new FreeTextAnalyzer());
            stringsQuery.add((Query)stringQuery, BooleanClause.Occur.SHOULD);
        }
        this.getQuery().add((Query)stringsQuery, BooleanClause.Occur.MUST);
        return (T)((BranchQueryBuilder)this.getThis());
    }

    public T withLastModified(Long min, Long max, boolean minInclusive, boolean maxInclusive) {
        if (min != null || max != null) {
            NumericRangeQuery rangeQuery = NumericRangeQuery.newLongRange((String)"lastModified", (Long)min, (Long)max, (boolean)minInclusive, (boolean)maxInclusive);
            this.getQuery().add((Query)rangeQuery, BooleanClause.Occur.MUST);
        }
        return (T)((BranchQueryBuilder)this.getThis());
    }

    public T withRepo(String repository) {
        if (repository != null) {
            this.getQuery().add((Query)new TermQuery(new Term("rep", repository)), BooleanClause.Occur.MUST);
        }
        return (T)((BranchQueryBuilder)this.getThis());
    }

    public T withPrefix(String queryString) {
        if (StringUtils.isNotBlank((String)queryString)) {
            this.getQuery().add(LuceneUtils.generatePrefixPhraseQuery(queryString, "branch", new FreeTextAnalyzer()), BooleanClause.Occur.MUST);
        }
        return (T)((BranchQueryBuilder)this.getThis());
    }

    public T exactMatch(String repo, String branch) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)branch), (Object)"exact match cannot match blank string");
        TermQuery exact = new TermQuery(BranchDocInfo.getKeyTerm(repo, branch));
        this.getQuery().add((Query)exact, BooleanClause.Occur.MUST);
        return (T)((BranchQueryBuilder)this.getThis());
    }

    public T inAnyState() {
        this.excludedBranchStates.clear();
        return (T)((BranchQueryBuilder)this.getThis());
    }

    public T updatedBetween(long min, long max) {
        this.query.add((Query)NumericRangeQuery.newLongRange((String)"lastIndexedTimestamp", (Long)min, (Long)max, (boolean)false, (boolean)true), BooleanClause.Occur.MUST);
        return (T)((BranchQueryBuilder)this.getThis());
    }

    @Override
    public Query build() {
        for (BranchState excludedState : this.excludedBranchStates) {
            this.query.add(new BooleanClause((Query)new TermQuery(new Term("branchState", excludedState.getValue())), BooleanClause.Occur.MUST_NOT));
        }
        return super.build();
    }
}

