/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.service.DocInfoManager;
import com.cenqua.fisheye.crossrepo.BranchDoc;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class BranchIndexer {
    private static final int BRANCH_BATCH_SIZE = 1000;
    private static final int LOG_BRANCH_LIMIT = 100;
    private final CrossRepLuceneIndex crossRepLuceneIndex;

    public BranchIndexer(CrossRepLuceneIndex crossRepLuceneIndex) {
        this.crossRepLuceneIndex = crossRepLuceneIndex;
    }

    public <C extends ChangeSet> void indexBranchesForChangeSetIds(Iterable<String> changeSetsIds, Iterable<Branch> branches, ChangeSetResolver<C> cache, RepositoryStatus status) {
        ImmutableSet csIds = ImmutableSet.copyOf(changeSetsIds);
        Iterable updatedBranches = Iterables.filter(branches, (Predicate)Predicates.and(Branch.NOT_REMOVED, (Predicate)Predicates.compose((Predicate)Predicates.in((Collection)csIds), Branch.TO_LATEST_CHANGESET_ID)));
        this.indexBranches(updatedBranches, cache, status);
    }

    public <C extends ChangeSet> void indexBranches(Iterable<Branch> branches, ChangeSetResolver<C> cache, RepositoryStatus status) {
        ImmutableSet branchesToIndex = ImmutableSet.copyOf(branches);
        Logs.APP_LOG.debug((Object)String.format("Indexing %s added branches: %s", branchesToIndex.size(), Iterables.limit(branches, (int)100)));
        BranchDocBatch batch = new BranchDocBatch();
        for (Branch branch : branchesToIndex) {
            status.throwOnStopRequested();
            ChangeSet lastChangesetOnBranch = null;
            if (branch.getLatestChangeSetId() != null) {
                lastChangesetOnBranch = cache.getChangeSet(branch.getLatestChangeSetId());
            }
            long timestamp = lastChangesetOnBranch == null ? 0L : lastChangesetOnBranch.getDate();
            batch.add(new BranchDoc(status.getRepositoryName(), branch.getLatestChangeSetId(), timestamp, branch.getName(), branch.getState(), branch.getLastIndexedTimestamp(), branch.getFirstIndexedTimestamp()));
            if (batch.getSize() < 1000) continue;
            this.sendAndClearBatch(batch, status);
        }
        if (null == status || !status.isStopRequested()) {
            this.sendAndClearBatch(batch, status);
        }
    }

    public void removeBranches(String repoName, Iterable<String> removedBranchNames) {
        ImmutableSet branchesToRemove = ImmutableSet.copyOf(removedBranchNames);
        Logs.APP_LOG.debug((Object)String.format("Indexing %s removed branches: %s", branchesToRemove.size(), Iterables.limit((Iterable)branchesToRemove, (int)100)));
        this.getCrossRepLuceneIndex().getConnection().withWriter(CrossRepLuceneIndexes.METADATA, new LuceneConnection.WriterAction<Void>((Set)branchesToRemove, repoName){
            final /* synthetic */ Set val$branchesToRemove;
            final /* synthetic */ String val$repoName;
            {
                this.val$branchesToRemove = set;
                this.val$repoName = string;
            }

            @Override
            public Void perform(IndexWriter writer) throws IOException, DbException {
                Term[] deletedTerms = (Term[])Iterables.toArray((Iterable)Iterables.transform((Iterable)this.val$branchesToRemove, (Function)new Function<String, Term>(){

                    public Term apply(String branchName) {
                        return BranchDocInfo.getKeyTerm(val$repoName, branchName);
                    }
                }), Term.class);
                writer.deleteDocuments(deletedTerms);
                return null;
            }
        });
    }

    public void removeAllBranches(final String repoName) {
        Logs.APP_LOG.debug((Object)("Removing all indexed branches for " + repoName));
        this.getCrossRepLuceneIndex().getConnection().withWriter(CrossRepLuceneIndexes.METADATA, new LuceneConnection.WriterAction<Void>(){

            @Override
            public Void perform(IndexWriter writer) throws IOException, DbException {
                writer.deleteDocuments(BranchQueryBuilder.newInstance().withRepo(repoName).build());
                return null;
            }
        });
    }

    private void sendAndClearBatch(BranchDocBatch batch, RepositoryStatus status) {
        if (batch.isEmpty()) {
            return;
        }
        Logs.APP_LOG.debug((Object)("Committing BranchDocBatch with " + batch.getSize() + " docs"));
        this.sendBatch(batch, status);
        batch.clear();
    }

    private CrossRepLuceneIndex getCrossRepLuceneIndex() {
        return this.crossRepLuceneIndex;
    }

    private void sendBatch(BranchDocBatch batch, RepositoryStatus status) {
        this.getCrossRepLuceneIndex().getConnection().withWriter(CrossRepLuceneIndexes.METADATA, new BranchDocBatchWriterAction(batch, status));
    }

    private static class BranchDocBatch
    implements Iterable<BranchDocInfo> {
        private final Map<String, BranchDoc> branchDocs = Maps.newHashMap();

        private BranchDocBatch() {
        }

        public void add(BranchDoc branchDoc) {
            this.branchDocs.put(branchDoc.getGlobalName(), branchDoc);
        }

        public int getSize() {
            return this.branchDocs.size();
        }

        public boolean isEmpty() {
            return this.branchDocs.isEmpty();
        }

        public void clear() {
            this.branchDocs.clear();
        }

        @Override
        public Iterator<BranchDocInfo> iterator() {
            return Iterators.transform(this.branchDocs.values().iterator(), (Function)new Function<BranchDoc, BranchDocInfo>(){

                public BranchDocInfo apply(@Nullable BranchDoc branchDoc) {
                    return BranchDocInfo.fromBranchDoc(branchDoc);
                }
            });
        }
    }

    private static class BranchDocBatchWriterAction
    implements LuceneConnection.WriterAction<Void> {
        private final BranchDocBatch batch;
        private final RepositoryStatus status;

        BranchDocBatchWriterAction(BranchDocBatch batch, RepositoryStatus status) {
            this.batch = batch;
            this.status = status;
        }

        @Override
        public Void perform(IndexWriter writer) throws IOException, DbException {
            DocInfoManager<BranchDocInfo> branchDao = new DocInfoManager<BranchDocInfo>(writer, null);
            try {
                for (BranchDocInfo branchDocInfo : this.batch) {
                    this.status.throwOnStopRequested();
                    branchDao.updateDoc(branchDocInfo);
                }
            }
            catch (IOException e2) {
                throw new DbException("Error indexing branches", e2);
            }
            finally {
                branchDao.closeReader();
            }
            return null;
        }
    }
}

