/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.cenqua.fisheye.crossrepo.BranchDoc;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.lucene.FreeTextAnalyzer;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

public class BranchDocInfo
extends CrossRepoDocInfo {
    public static final String FLD_BRANCH = "branch";
    private static final ImmutableMap<String, Analyzer> ANALYZER_MAP = ImmutableMap.of((Object)"branch", (Object)((Object)new FreeTextAnalyzer()));
    public static final String FLD_LAST_MODIFIED = "lastModified";
    public static final String FLD_LAST_CHANGESET_ID = "lastChangeSetId";
    public static final String FLD_BRANCH_STATE = "branchState";
    public static final String FLD_LAST_INDEXED_TIMESTAMP = "lastIndexedTimestamp";
    public static final String FLD_FIRST_INDEXED_TIMESTAMP = "firstIndexedTimestamp";
    @FieldInfo
    private final Fieldable key;
    @FieldInfo
    private final Fieldable branch;
    @FieldInfo
    private final NumericField lastModified;
    @FieldInfo
    private final Fieldable lastChangeSetId;
    @FieldInfo
    private final Fieldable branchState;
    @FieldInfo
    private final NumericField lastIndexedTimestamp;
    @FieldInfo
    private final NumericField firstIndexedTimestamp;
    public static final DocConverter<Long> LAST_MODIFIED_CONVERTER = new DocConverter<Long>(){
        private final FieldSelector LAST_MODIFIED_SELECTOR = LuceneUtils.singleFieldSelector("lastModified");

        @Override
        public Long convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.LAST_MODIFIED_SELECTOR);
            String fieldValue = doc.get(BranchDocInfo.FLD_LAST_MODIFIED);
            return fieldValue == null ? null : Long.valueOf(fieldValue);
        }
    };
    public static final DocConverter<BranchDocInfo> CONVERTER = new DocConverter<BranchDocInfo>(){

        @Override
        public BranchDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            return BranchDocInfo.fromDocumentToBranchDocInfo(searcher.doc(hit.doc));
        }
    };
    public static final Function<BranchDocInfo, String> TO_BRANCH_NAME = new Function<BranchDocInfo, String>(){

        public String apply(BranchDocInfo doc) {
            return doc.getBranch();
        }
    };

    protected BranchDocInfo(Fieldable repository, Fieldable branch, NumericField lastModified, Fieldable lastChangeSetId, Fieldable branchState, NumericField lastIndexedTimestamp, NumericField firstIndexedTimestamp) {
        super(CrossRepoDocInfo.DocType.BRANCH, repository);
        Term keyTerm = BranchDocInfo.getKeyTerm(repository.stringValue(), branch.stringValue());
        this.key = new Field(keyTerm.field(), keyTerm.text(), Field.Store.NO, Field.Index.NOT_ANALYZED);
        this.branch = branch;
        this.lastModified = lastModified;
        this.lastChangeSetId = lastChangeSetId;
        this.branchState = branchState;
        this.lastIndexedTimestamp = lastIndexedTimestamp;
        this.firstIndexedTimestamp = firstIndexedTimestamp;
    }

    public static BranchDocInfo fromBranchDoc(BranchDoc branchDoc) {
        Field branchField = new Field(FLD_BRANCH, branchDoc.getName(), Field.Store.YES, Field.Index.ANALYZED_NO_NORMS);
        NumericField lastModifiedField = BranchDocInfo.createLastModifiedField(branchDoc.getDate());
        String lastChangeSetId = branchDoc.getLastChangeSetId();
        Field lastChangsetField = lastChangeSetId != null ? new Field(FLD_LAST_CHANGESET_ID, lastChangeSetId, Field.Store.YES, Field.Index.NO) : null;
        NumericField lastIndexedTimestamp = new NumericField(FLD_LAST_INDEXED_TIMESTAMP, Field.Store.NO, true).setLongValue(branchDoc.getLastIndexedTimestamp());
        NumericField firstIndexedTimestamp = new NumericField(FLD_FIRST_INDEXED_TIMESTAMP, Field.Store.YES, false).setLongValue(branchDoc.getFirstIndexedTimestamp());
        Field branchStateField = branchDoc.getState() == null ? null : new Field(FLD_BRANCH_STATE, branchDoc.getState().getValue(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        return new BranchDocInfo(BranchDocInfo.makeRepositoryField(branchDoc.getRepName()), (Fieldable)branchField, lastModifiedField, (Fieldable)lastChangsetField, (Fieldable)branchStateField, lastIndexedTimestamp, firstIndexedTimestamp);
    }

    private static NumericField createLastModifiedField(long lastModified) {
        NumericField lastModifiedField = new NumericField(FLD_LAST_MODIFIED, Field.Store.YES, true);
        lastModifiedField.setLongValue(lastModified);
        return lastModifiedField;
    }

    public static Term getKeyTerm(String repository, String branchName) {
        return new Term("key", CrossRepoDocInfo.DocType.BRANCH.getId() + "_" + repository + "_" + branchName);
    }

    @Override
    public Term getKeyTerm() {
        return new Term(this.key.name(), this.key.stringValue());
    }

    @Override
    public Analyzer getAnalyzer() {
        return LuceneUtils.createPerFieldAnalyzer((Analyzer)new KeywordAnalyzer(), ANALYZER_MAP);
    }

    @Nullable
    public Long getLastModified() {
        return this.lastModified == null ? null : Long.valueOf(this.lastModified.getNumericValue().longValue());
    }

    public String getBranch() {
        return this.branch.stringValue();
    }

    @Nullable
    public String getLastChangeSetId() {
        return this.lastChangeSetId == null ? null : this.lastChangeSetId.stringValue();
    }

    @Nullable
    public Long getFirstIndexedTimestamp() {
        return this.firstIndexedTimestamp == null ? null : Long.valueOf(this.firstIndexedTimestamp.getNumericValue().longValue());
    }

    @Nullable
    public String getBranchState() {
        return this.branchState == null ? null : this.branchState.stringValue();
    }

    public static Function<ScoreDoc, BranchDocInfo> fromScoreDoc(final IndexSearcher indexSearcher) {
        return new Function<ScoreDoc, BranchDocInfo>(){

            public BranchDocInfo apply(@Nullable ScoreDoc scoreDoc) {
                try {
                    return scoreDoc != null ? BranchDocInfo.fromDocumentToBranchDocInfo(indexSearcher.doc(scoreDoc.doc)) : null;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        };
    }

    public static BranchDocInfo fromDocumentToBranchDocInfo(Document document) throws IOException {
        String lastModified = document.get(FLD_LAST_MODIFIED);
        String createTimestamp = document.get(FLD_FIRST_INDEXED_TIMESTAMP);
        return new BranchDocInfo(document.getFieldable("rep"), document.getFieldable(FLD_BRANCH), BranchDocInfo.createLastModifiedField(lastModified == null ? 0L : Long.parseLong(lastModified)), document.getFieldable(FLD_LAST_CHANGESET_ID), document.getFieldable(FLD_BRANCH_STATE), null, createTimestamp == null ? null : new NumericField(FLD_FIRST_INDEXED_TIMESTAMP).setLongValue(Long.parseLong(createTimestamp)));
    }
}

