/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.cenqua.fisheye.crossrepo.AbstractRepositoryQueryBuilder;
import com.cenqua.fisheye.crossrepo.AuthorDocInfo;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class AuthorQueryBuilder<T extends AuthorQueryBuilder>
extends AbstractRepositoryQueryBuilder<T> {
    public AuthorQueryBuilder() {
        this.setDocType((Query)new TermQuery(new Term("doctype", CrossRepoDocInfo.DocType.AUTHOR.getId())));
    }

    public T queryByAuthor(String userQuery) throws IOException {
        if (!Strings.isNullOrEmpty((String)userQuery)) {
            PhraseQuery phraseQuery = LuceneUtils.generatePhraseQuery(userQuery, "author", AuthorDocInfo.ANALYZER_MAP.get("author"));
            this.getQuery().add((Query)phraseQuery, BooleanClause.Occur.MUST);
        }
        return (T)((AuthorQueryBuilder)this.getThis());
    }

    public static AuthorQueryBuilder<AuthorQueryBuilder> newAuthorCrossRepoQueryBuilder() {
        return new AuthorQueryBuilder<AuthorQueryBuilder>();
    }
}

