/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.search.index.model.FieldInfo;
import com.atlassian.fecru.search.index.service.DocConverter;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.lucene.CharAnalyzer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

public class AuthorDocInfo
extends CrossRepoDocInfo {
    @FieldInfo
    private final Fieldable key;
    @FieldInfo
    private final Fieldable author;
    public static final String FLD_AUTHOR = "author";
    protected static final Map<String, Analyzer> ANALYZER_MAP = ImmutableMap.of((Object)"author", (Object)((Object)new CharAnalyzer()));
    public static final DocConverter<AuthorDocInfo> AUTHOR_CONVERTER = new DocConverter<AuthorDocInfo>(){
        private final FieldSelector RESULT_SELECTOR = LuceneUtils.multipleFieldsSelector("author", "rep");

        @Override
        public AuthorDocInfo convert(IndexSearcher searcher, ScoreDoc hit) throws IOException {
            Document doc = searcher.doc(hit.doc, this.RESULT_SELECTOR);
            return new AuthorDocInfo(doc.getFieldable(AuthorDocInfo.FLD_AUTHOR), doc.getFieldable("rep").stringValue());
        }
    };

    private AuthorDocInfo(Fieldable author, String repName) {
        super(CrossRepoDocInfo.DocType.AUTHOR, repName);
        this.author = author;
        this.key = new Field("key", this.makeCrossRepoAuthorId(author.stringValue()), Field.Store.NO, Field.Index.NOT_ANALYZED);
    }

    public AuthorDocInfo(String author, String repName) {
        this((Fieldable)new Field(FLD_AUTHOR, author, Field.Store.YES, Field.Index.ANALYZED_NO_NORMS), repName);
    }

    private String makeCrossRepoAuthorId(String author) {
        return this.doctype.stringValue() + "_" + this.repository.stringValue() + ":" + author;
    }

    @Override
    public Term getKeyTerm() {
        return new Term(this.key.name(), this.key.stringValue());
    }

    @Override
    public Analyzer getAnalyzer() {
        return LuceneUtils.createPerFieldAnalyzer((Analyzer)new KeywordAnalyzer(), ANALYZER_MAP);
    }

    public String getAuthor() {
        return this.author.stringValue();
    }

    public static AuthorDocInfo fromSearchHit(IndexSearcher searcher, ScoreDoc hit) throws IOException {
        return AUTHOR_CONVERTER.convert(searcher, hit);
    }

    public static TokenStream tokenStreamForAuthor(String text) {
        return ANALYZER_MAP.get(FLD_AUTHOR).tokenStream("", (Reader)new StringReader(text));
    }
}

