/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.cenqua.fisheye.logging.Logs;
import java.util.Collection;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public abstract class AbstractRepositoryQueryBuilder<T extends AbstractRepositoryQueryBuilder> {
    protected BooleanQuery query = new BooleanQuery(true);
    protected Query docType;

    public T optimalRepositoryQuery(Collection<String> includes, Collection<String> excludes) {
        if (includes.isEmpty()) {
            Logs.APP_LOG.debug((Object)"cross-repo search with no repos");
            this.getQuery().add(new BooleanClause((Query)new BooleanQuery(), BooleanClause.Occur.MUST));
        } else if (excludes.isEmpty()) {
            Logs.APP_LOG.debug((Object)"cross-repo search with no repo constraints");
        } else if (excludes.size() >= includes.size()) {
            Logs.APP_LOG.debug((Object)("positive cross-repo search, constrained to " + includes.size() + "  repos"));
            this.fromTheseRepos(includes);
        } else {
            Logs.APP_LOG.debug((Object)("negative cross-repo search, constrained to " + excludes.size() + "  repos"));
            this.notFromTheseRepos(excludes);
        }
        return this.getThis();
    }

    public T fromTheseRepos(Collection<String> include) {
        return this.limitRepos(include, BooleanClause.Occur.MUST);
    }

    protected T notFromTheseRepos(Collection<String> exclude) {
        return this.limitRepos(exclude, BooleanClause.Occur.MUST_NOT);
    }

    private T limitRepos(Collection<String> reposNames, BooleanClause.Occur occur) {
        if (reposNames.isEmpty()) {
            throw new IllegalStateException("No repositories specified to constrain to");
        }
        BooleanQuery bq = new BooleanQuery(true);
        for (String rep : reposNames) {
            bq.add((Query)new TermQuery(new Term("rep", rep)), BooleanClause.Occur.SHOULD);
        }
        this.getQuery().add((Query)bq, occur);
        return this.getThis();
    }

    protected T getThis() {
        return (T)this;
    }

    protected BooleanQuery getQuery() {
        return this.query;
    }

    public Query build() {
        if (this.docType != null) {
            this.query.add(this.docType, BooleanClause.Occur.MUST);
        }
        return this.query;
    }

    protected void setDocType(Query docType) {
        if (this.docType != null) {
            throw new IllegalStateException("This builder has already had a type specified: " + docType.toString());
        }
        this.docType = docType;
    }

    public T byKeyTerm(Term keyTerm) {
        this.getQuery().add((Query)new TermQuery(keyTerm), BooleanClause.Occur.MUST);
        return this.getThis();
    }
}

