/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.crossrepo;

import com.atlassian.fecru.search.index.model.FieldInfo;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.CrossRepoDocInfo;
import com.cenqua.fisheye.csindex.ChangesetIndexDateFormatter;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;

public abstract class AbstractChangesetDocInfo
extends CrossRepoDocInfo {
    protected static final String CSID = "csid";
    public static final String AUTHOR = "author";
    protected static final String COMMENT = "comment";
    protected static final String FILE_EXTENSION = "xtn";
    protected static final String BRANCH = "branch";
    protected static final String FILE_NAME = "name";
    protected static final String PATH_COMPONENTS = "pathcomponents";
    protected static final String PARENT_DIR = "parentdir";
    protected static final String PATH = "path";
    protected static final String P4_JOB = "p4.job";
    protected static final ChangesetIndexDateFormatter dateFormatter = new ChangesetIndexDateFormatter();
    @FieldInfo
    protected final Fieldable changesetId;
    @FieldInfo
    protected final Fieldable commitMessage;
    @FieldInfo
    protected final Fieldable author;
    @FieldInfo
    protected final List<Fieldable> p4Jobs;
    @FieldInfo
    protected final List<Fieldable> branches;
    @FieldInfo
    protected final Fieldable timestampMs;
    @FieldInfo
    protected final NumericField lastUpdateHrs;

    protected AbstractChangesetDocInfo(CrossRepoDocInfo.DocType docType, Fieldable changesetId, Fieldable repository, Fieldable commitMessage, Fieldable author, Date eventDate, List<Fieldable> p4Jobs, List<Fieldable> branches) {
        super(docType, repository);
        this.changesetId = changesetId;
        this.commitMessage = commitMessage;
        this.author = author;
        this.p4Jobs = p4Jobs;
        this.branches = branches;
        this.timestampMs = null == eventDate ? null : new Field("dTimeMillis", dateFormatter.formatTimestamp(eventDate), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        this.lastUpdateHrs = null == eventDate ? null : LuceneHelper.lastModifiedField(eventDate);
    }

    protected AbstractChangesetDocInfo(CrossRepoDocInfo.DocType docType, ChangesetDoc csDoc, Date eventDate) {
        this(docType, AbstractChangesetDocInfo.makeCsIdField(csDoc), AbstractChangesetDocInfo.makeRepositoryField(csDoc.getRepName()), AbstractChangesetDocInfo.makeCommitMessageField(csDoc), AbstractChangesetDocInfo.makeAuthorField(csDoc), eventDate, AbstractChangesetDocInfo.makeP4JobsField(csDoc), AbstractChangesetDocInfo.makeBranchesField(csDoc));
    }

    private static List<Fieldable> makeBranchesField(ChangesetDoc csDoc) {
        ImmutableList.Builder branches = ImmutableList.builder();
        for (String branch : csDoc.getBranches()) {
            branches.add((Object)new Field(BRANCH, branch.toLowerCase(Locale.US), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        return branches.build();
    }

    private static List<Fieldable> makeP4JobsField(ChangesetDoc csDoc) {
        ImmutableList.Builder p4jobs = ImmutableList.builder();
        for (String fix : csDoc.getP4Fixes()) {
            p4jobs.add((Object)new Field(P4_JOB, fix.toLowerCase(Locale.US), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        return p4jobs.build();
    }

    private static Fieldable makeAuthorField(ChangesetDoc csDoc) {
        String changesetAuthor = csDoc.getAuthor() == null ? "no_author" : csDoc.getAuthor();
        return new Field(AUTHOR, changesetAuthor.toLowerCase(Locale.US), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    private static Fieldable makeCommitMessageField(ChangesetDoc csDoc) {
        return new Field(COMMENT, csDoc.getComment(), Field.Store.YES, Field.Index.ANALYZED);
    }

    private static Fieldable makeCsIdField(ChangesetDoc csDoc) {
        return new Field(CSID, csDoc.getId(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    @Override
    public String getRepository() {
        return this.repository.stringValue();
    }

    public String getChangesetId() {
        return this.changesetId.stringValue();
    }

    @Nullable
    public String getAuthor() {
        return this.author == null ? null : this.author.stringValue();
    }

    @Nullable
    public String getCommitMessage() {
        return this.commitMessage == null ? null : this.commitMessage.stringValue();
    }

    @Nullable
    public Date getTimestamp() {
        return this.timestampMs == null ? null : LuceneHelper.parseDate(this.timestampMs.stringValue());
    }
}

