/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.RegionList;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.util.AntGlob;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SyntaxDefinitions {
    private static final Pattern MAP_FILE_PATTERN = Pattern.compile("\"((?:\"|[^\"])*)\"\\s+(\\S+)(?:\\s+\"((?:\"|[^\"])*)?\")?");
    private static final String SYNTAX_DEF_MAP_FILE = "filename.map";
    private final Map<String, SyntaxDefinition> fileSyntaxDefMap = new HashMap<String, SyntaxDefinition>();
    private final Map<AntGlob, SyntaxDefinition> globSyntaxDefMap = new HashMap<AntGlob, SyntaxDefinition>();
    private final Map<String, String> syntaxTypes = new HashMap<String, String>();
    private final List<File> syntaxDefDirs;

    public SyntaxDefinitions(List<File> syntaxDefDirs) {
        this.syntaxDefDirs = syntaxDefDirs;
        this.loadFileMappings();
    }

    private void loadFileMappings() {
        for (File dir : this.syntaxDefDirs) {
            File syntaxDefMapFile = new File(dir, SYNTAX_DEF_MAP_FILE);
            if (!syntaxDefMapFile.isFile()) continue;
            this.loadFileMappings(syntaxDefMapFile);
        }
    }

    private void loadFileMappings(File syntaxDefMapFile) {
        try {
            LineNumberReader in = new LineNumberReader(new BufferedReader(new FileReader(syntaxDefMapFile)));
            String line = in.readLine();
            while (line != null) {
                if (!this.parseMappingLine(line)) {
                    Logs.APP_LOG.warn((Object)("Error parsing " + syntaxDefMapFile + ":" + in.getLineNumber() + ": skipped."));
                }
                line = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException e2) {
            Logs.APP_LOG.warn((Object)("File not found: " + e2.getMessage()));
            Logs.APP_LOG.warn((Object)"No syntax mappings loaded");
        }
        catch (IOException e3) {
            Logs.APP_LOG.warn((Object)("Error reading file: " + syntaxDefMapFile));
        }
    }

    protected boolean parseMappingLine(String line) {
        String trimmed = line.trim();
        if (trimmed.length() == 0 || trimmed.startsWith("#")) {
            return true;
        }
        Matcher m2 = MAP_FILE_PATTERN.matcher(trimmed);
        if (m2.matches()) {
            AntGlob glob = new AntGlob(m2.group(1));
            String defName = m2.group(2);
            SyntaxDefinition sd = this.getByFileName(defName);
            if (sd != null) {
                if (!this.globSyntaxDefMap.containsKey(glob)) {
                    this.globSyntaxDefMap.put(glob, sd);
                }
                String description = null;
                if (m2.groupCount() == 3) {
                    description = m2.group(3);
                }
                String match = m2.group(1);
                String extension = match.substring(match.lastIndexOf(".") + 1);
                if (!Strings.isNullOrEmpty((String)description)) {
                    this.syntaxTypes.put(description, extension);
                }
            }
            return true;
        }
        return false;
    }

    public SyntaxDefinition getSyntaxDefinitionForFile(String filename) {
        for (AntGlob glob : this.globSyntaxDefMap.keySet()) {
            if (!glob.matches(filename)) continue;
            return this.globSyntaxDefMap.get(glob);
        }
        return SyntaxDefinition.PASS_THRU;
    }

    public ParseResult getRegionsForFile(String filename, CharSequence input) {
        SyntaxDefinition sd = this.getSyntaxDefinitionForFile(filename);
        Logs.APP_LOG.debug((Object)("mapped " + filename + " to " + sd.getName()));
        RegionList regions = new RegionList();
        InputState inputstate = new InputState(input, filename);
        sd.generateRegions(inputstate, regions);
        return new ParseResult(regions, sd, inputstate.getParserOverflowOccured());
    }

    public Map<String, String> getSyntaxTypes() {
        return this.syntaxTypes;
    }

    public SyntaxDefinition getByFileName(String fileName) {
        SyntaxDefinition sd = this.fileSyntaxDefMap.get(fileName);
        if (sd == null) {
            for (File dir : this.syntaxDefDirs) {
                File syntaxDefFile = new File(dir, fileName);
                if (!syntaxDefFile.isFile() || (sd = this.loadSyntaxDef(fileName, syntaxDefFile)) == null) continue;
                Logs.APP_LOG.debug((Object)("Loaded syntax definition '" + fileName + "'"));
                this.fileSyntaxDefMap.put(fileName, sd);
                break;
            }
        }
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyntaxDefinition loadSyntaxDef(String defName, File syntaxDefFile) {
        FileReader in;
        SyntaxDefinition sd;
        block5: {
            sd = null;
            LinkedList<String> errors = new LinkedList<String>();
            in = null;
            try {
                in = new FileReader(syntaxDefFile);
                sd = SyntaxDefinition.parse(in, errors);
                if (sd != null) break block5;
                Logs.APP_LOG.warn((Object)("Failed to parse '" + defName + "':"));
                for (String error : errors) {
                    Logs.APP_LOG.warn((Object)(defName + ":" + error));
                }
            }
            catch (IOException e2) {
                try {
                    Logs.APP_LOG.warn((Object)("Error reading syntax definition '" + defName + "': " + e2.getMessage()));
                }
                catch (Throwable throwable) {
                    IOHelper.close(in);
                    throw throwable;
                }
                IOHelper.close(in);
            }
        }
        IOHelper.close(in);
        return sd;
    }

    public static class ParseResult {
        private final RegionList regions;
        private final SyntaxDefinition syntaxDefinition;
        private final boolean parserOverflowOccured;

        public ParseResult(RegionList regions, SyntaxDefinition syntaxDefinition, boolean parserOverflowOccured) {
            this.regions = regions;
            this.syntaxDefinition = syntaxDefinition;
            this.parserOverflowOccured = parserOverflowOccured;
        }

        public RegionList getRegions() {
            return this.regions;
        }

        public SyntaxDefinition getSyntaxDefinition() {
            return this.syntaxDefinition;
        }

        public boolean isParserOverflowOccured() {
            return this.parserOverflowOccured;
        }
    }
}

