/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.fisheye.plugin.DelegatingFisheyePluginManager;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class SpringContext
implements ApplicationListener {
    private static ApplicationContext applicationContext;

    @Autowired
    public SpringContext(ApplicationContext applicationContext) {
        SpringContext.setApplicationContext(applicationContext);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext context = ((ContextRefreshedEvent)event).getApplicationContext();
            SpringContext.setApplicationContext(context);
            DelegatingFisheyePluginManager pluginManager = SpringContext.getComponentByClass(DelegatingFisheyePluginManager.class);
            pluginManager.onContextRefreshedEvent((ContextRefreshedEvent)event);
        } else if (event instanceof ContextClosedEvent) {
            DelegatingFisheyePluginManager pluginManager = SpringContext.getComponentByClass(DelegatingFisheyePluginManager.class);
            pluginManager.onContextClosedEvent((ContextClosedEvent)event);
            SpringContext.setApplicationContext(null);
        }
    }

    public static ApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            throw new ApplicationContextException("Application Context not initialised.");
        }
        return applicationContext;
    }

    public static boolean isSetup() {
        return applicationContext != null;
    }

    public static void setApplicationContext(ApplicationContext appContext) {
        applicationContext = appContext;
    }

    public static void autowireObject(Object o2) {
        SpringContext.getApplicationContext().getAutowireCapableBeanFactory().autowireBeanProperties(o2, 4, false);
    }

    public static <T> T createComponent(Class<T> clazz) {
        return (T)SpringContext.getApplicationContext().getAutowireCapableBeanFactory().createBean(clazz, 4, false);
    }

    public static <T> T createComponent(Class<T> clazz, int autoWireStrategy) {
        return (T)SpringContext.getApplicationContext().getAutowireCapableBeanFactory().createBean(clazz, autoWireStrategy, false);
    }

    public static <T> T getComponent(String name) {
        return (T)SpringContext.getApplicationContext().getBean(name);
    }

    public static <T> T getComponent(Class<T> clazz, String name) {
        return (T)SpringContext.getApplicationContext().getBean(name, clazz);
    }

    public static <T> T getComponentByClass(Class<T> moduleClass) {
        Map beans = SpringContext.getApplicationContext().getBeansOfType(moduleClass);
        if (beans.size() == 1) {
            return (T)beans.values().iterator().next();
        }
        throw new RuntimeException("Expected one bean of class " + moduleClass + " but found " + beans.size());
    }

    public static <T> Collection<T> getComponentsByClass(Class<T> moduleClass) {
        Map beans = SpringContext.getApplicationContext().getBeansOfType(moduleClass);
        return beans.values();
    }

    public static boolean isBeanPresent(String name) {
        return SpringContext.getApplicationContext().containsBean(name);
    }
}

