/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.applinks.host.util.InstanceNameGenerator;
import com.atlassian.crucible.activity.lucene.ReviewItemIndexer;
import com.atlassian.fecru.search.common.lucene.LuceneUtils;
import com.atlassian.fecru.user.UserProfileManager;
import com.atlassian.fecru.util.SafeSAXXMLReaderFactory;
import com.atlassian.fisheye.quartz.QuartzManager;
import com.atlassian.fugue.Option;
import com.atlassian.license.DefaultSIDManager;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.cenqua.crucible.hibernate.DBControlFactory;
import com.cenqua.crucible.hibernate.DBType;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeClassLoader;
import com.cenqua.fisheye.FishEyeCtl;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.RepositoryTypeComparator;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.Bind;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.ConfigUtil;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.config.SyntaxDefinitions;
import com.cenqua.fisheye.config1.Admins;
import com.cenqua.fisheye.config1.Ajp13ServerType;
import com.cenqua.fisheye.config1.AvatarType;
import com.cenqua.fisheye.config1.BackupType;
import com.cenqua.fisheye.config1.BuiltInConfigType;
import com.cenqua.fisheye.config1.CommitMessageSyntaxType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.ConnectionType;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.DatabaseType;
import com.cenqua.fisheye.config1.DriverSource;
import com.cenqua.fisheye.config1.GroupListType;
import com.cenqua.fisheye.config1.GroupType;
import com.cenqua.fisheye.config1.HttpServerType;
import com.cenqua.fisheye.config1.LicenseType;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.ReviewType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.config1.SignupType;
import com.cenqua.fisheye.config1.SslServerType;
import com.cenqua.fisheye.config1.SystemAdmins;
import com.cenqua.fisheye.config1.TextIndexerType;
import com.cenqua.fisheye.config1.ViewcvsUrlMapperType;
import com.cenqua.fisheye.config1.WatchType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.license.LicenseHolder;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.license.LicenseLoader;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.svn.util.SvnLoader;
import com.cenqua.fisheye.syntax.Linker;
import com.cenqua.fisheye.syntax.LinkerFactory;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.CustomFileNameMap;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.UrlUtils;
import com.cenqua.fisheye.util.XmlbeansUtil;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class RootConfig {
    public static final String DEFAULT_CONTROL_BIND = "127.0.0.1:8078";
    private File configFile = null;
    private ConfigDocument configDoc = null;
    private CustomFileNameMap customFileNameMap = null;
    private ViewCvsRemapper mViewCvsConfig = new ViewCvsRemapper();
    private LicenseInfo mLicense;
    private String mControlBind = "127.0.0.1:8078";
    private SyntaxDefinitions mSyntaxDefinitions;
    private UserManager mUserManager;
    private UserProfileManager mUserProfileManager;
    private TimeZone mTimeZone = TimeZone.getDefault();
    private String fallbackSiteUrl = null;
    private ResettableLazyReference<Linker> defaultLinker = new ResettableLazyReference<Linker>(){

        protected Linker create() throws Exception {
            return LinkerFactory.createDefaultRepositoryLinker(RootConfig.this.getConfig().getRepositoryDefaults().getLinker(), RootConfig.this.mSyntaxDefinitions);
        }
    };
    private CrossRepLuceneIndex crossRepLuceneIndex;
    private ReviewItemIndexer reviewItemIndexer;
    private final RepositoryRunPermits repoPermits = new RepositoryRunPermits(0);
    private AdminConfig adminConfig = new AdminConfig(this);
    private static final Pattern WEB_CONTEXT_CLEANER = Pattern.compile("^/*(.*)/*\\*?$");

    public void setConfig(ConfigDocument dummyConfig) {
        this.configDoc = dummyConfig;
    }

    public void load(File configFile) throws IOException, ConfigException {
        this.configFile = configFile.getAbsoluteFile();
        Logs.APP_LOG.info((Object)("loading config from file: " + configFile));
        LinkedList<XmlError> errors = new LinkedList<XmlError>();
        try {
            XmlOptions opts = new XmlOptions();
            opts.setErrorListener(errors);
            ConfigDocument doc = RootConfig.parseDocument(configFile, opts);
            if (!doc.validate(opts)) {
                Logs.APP_LOG.error((Object)("Errors parsing " + configFile + ":"));
                this.logXmlErrors(errors);
                throw new ConfigException("Error parsing config file (see logs): " + configFile);
            }
            this.load(doc);
        }
        catch (XmlException e2) {
            throw new ConfigException(e2);
        }
    }

    public void reload() {
        this.initTimezone(this.getConfig());
        this.reloadDefaultLinker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigDocument parseDocument(File configFile, XmlOptions opts) throws XmlException, IOException {
        try (FileInputStream in = new FileInputStream(configFile);){
            ConfigDocument configDocument = RootConfig.parseDocument(in, opts);
            return configDocument;
        }
    }

    public static ConfigDocument parseDocument(InputStream in, XmlOptions opts) throws XmlException, IOException {
        opts.setLoadLineNumbers();
        opts.setLoadSubstituteNamespaces(RootConfig.makeExplicitNamespaces());
        opts.setEntityResolver(new SafeSAXXMLReaderFactory().newNoOpEntityResolver());
        return ConfigDocument.Factory.parse(in, opts);
    }

    public static Map<String, String> makeExplicitNamespaces() {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("", ConfigDocument.type.getDocumentElementName().getNamespaceURI());
        return nsMap;
    }

    public ConfigDocument.Config getConfig() {
        return this.configDoc.getConfig();
    }

    public ConfigDocument getConfigDocument() {
        return this.configDoc;
    }

    public synchronized void saveConfig() throws IOException {
        this.cleanupAndUpgrade(this.getConfig());
        if (this.configFile != null && this.configFile.isFile()) {
            XmlOptions opts = new XmlOptions();
            opts.setSaveImplicitNamespaces(RootConfig.makeExplicitNamespaces());
            File backup = this.backupConfigFile();
            boolean savedProperly = false;
            try {
                this.configDoc.save(this.configFile, opts);
                savedProperly = true;
            }
            catch (IOException e2) {
                this.tryRestoreConfigFile(backup);
                throw e2;
            }
            finally {
                if (savedProperly) {
                    this.deleteConfigBackup(backup);
                }
            }
        } else {
            Logs.APP_LOG.warn((Object)"Couldn't save config file - not a file.");
        }
    }

    private void tryRestoreConfigFile(File configBackup) {
        boolean renameSuccessful = this.tryRenameRestore(configBackup);
        if (!renameSuccessful) {
            this.tryCopyRestore(configBackup);
        }
    }

    private boolean tryRenameRestore(File configBackup) {
        boolean result;
        try {
            String configFileAbsolutePath = this.configFile.getAbsolutePath();
            result = IOHelper.rename(configBackup, this.configFile);
            Logs.APP_LOG.info((Object)("restored backup config from " + configFileAbsolutePath));
        }
        catch (IOException e2) {
            result = false;
            Logs.APP_LOG.error((Object)("cannot rename backup config from " + configBackup.getAbsolutePath() + " to " + this.configFile.getAbsolutePath()));
        }
        return result;
    }

    private void deleteConfigBackup(File configBackup) {
        if (!configBackup.delete()) {
            Logs.APP_LOG.warn((Object)("could not delete backup config file " + configBackup.getAbsolutePath()));
        }
    }

    private void tryCopyRestore(File configBackup) {
        try {
            IOHelper.copy(configBackup, this.configFile);
            Logs.APP_LOG.info((Object)("restored backup config from " + configBackup.getAbsolutePath()));
            this.deleteConfigBackup(configBackup);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)("cannot copy backup config from " + configBackup.getAbsolutePath() + " to " + this.configFile.getAbsolutePath()));
        }
    }

    private File backupConfigFile() throws IOException {
        File backup = new File(AppConfig.getInstanceDir(), "config.bak").getAbsoluteFile();
        try {
            IOHelper.copy(this.configFile, backup);
        }
        catch (IOException e2) {
            String path = backup == null ? "" : backup.getAbsolutePath();
            Logs.APP_LOG.error((Object)("cannot create backup file " + path + ":" + e2));
            this.deleteConfigBackup(backup);
            throw e2;
        }
        return backup;
    }

    private void logXmlErrors(List<XmlError> errors) {
        for (XmlError error : errors) {
            String location = "";
            if (error.getSourceName() != null) {
                location = location + "in " + error.getSourceName() + " ";
            }
            int line = error.getLine();
            int col = error.getColumn();
            if (line != -1) {
                location = location + "at line " + line + (col == -1 ? ":" : col + ":") + " ";
            }
            Logs.APP_LOG.error((Object)(location + error.getMessage()));
        }
    }

    public void load(ConfigDocument doc) throws ConfigException, IOException {
        this.configDoc = doc;
        ConfigDocument.Config config = doc.getConfig();
        this.cleanupAndUpgrade(config);
        this.setupSID();
    }

    public void start() throws ConfigException, IOException, DbException {
        ConfigDocument.Config config = this.configDoc.getConfig();
        if (config.isSetAppHome()) {
            Logs.APP_LOG.warn((Object)"The <app-home> config element is deprecated (and ignored), please remove it");
        }
        if (!AppConfig.getAppHome().isDirectory()) {
            throw new ConfigException("Could not find application directory " + AppConfig.getAppHome());
        }
        if (!AppConfig.getInstanceDir().isDirectory()) {
            throw new ConfigException("Could not find instance directory " + AppConfig.getInstanceDir());
        }
        this.setupWinp();
        WebServerType webServer = this.configDoc.getConfig().getWebServer();
        if (!(webServer.isSetHttp() || webServer.isSetAjp13() || webServer.isSetSsl())) {
            throw new ConfigException("At least one of <http>, <ssl> or <ajp13> elements is required in a <webserver> element.");
        }
        try {
            new InstanceNameGenerator().generateInstanceName(this.getSiteURL());
        }
        catch (MalformedURLException e2) {
            String extraHint = this.getConfig().getWebServer().isSetSiteUrl() ? "Verify the site-url attribute of the <web-server> element in your config.xml file." : "Verify the <web-server> bind and proxy settings in your config.xml file.";
            throw new ConfigException("The site url is malformed: " + e2.getMessage() + ". " + extraHint, e2);
        }
        File tmpDir = AppConfig.getTempDir();
        tmpDir.mkdirs();
        this.cleanTmpDir();
        System.setProperty("java.io.tmpdir", tmpDir.getAbsolutePath());
        this.customFileNameMap = new CustomFileNameMap(this.handleFileWithoutExtensionAsText());
        this.customFileNameMap.loadConfig(AppConfig.getAppHome(), AppConfig.getInstanceDir());
        this.setupDBDriver();
        this.setSCMConfigInfo(config);
        this.mSyntaxDefinitions = this.makeSyntaxDefinitions();
        LuceneUtils.initBooleanQueryClauseCount();
        this.initCrossRepLuceneIndex();
        this.parseViewcvsMapper(config);
        this.mControlBind = config.getControlBind();
        this.initTimezone(config);
    }

    private void cleanTmpDir() {
        File tmpDir = AppConfig.getTempDir();
        IOHelper.deleteFiles(tmpDir, (FileFilter)new AndFileFilter(FileFileFilter.FILE, (IOFileFilter)new WildcardFileFilter("svn*", IOCase.INSENSITIVE)));
    }

    private void setupWinp() {
        File instanceLib = new File(AppConfig.getInstanceDir(), "lib");
        if (!instanceLib.exists()) {
            instanceLib.mkdirs();
        }
        System.setProperty("winp.folder.preferred", new File(instanceLib, "truncated").getAbsolutePath());
    }

    public void setupDBDriver() {
        DatabaseType databaseConfig;
        ConnectionType connectionConfig;
        ConfigDocument.Config config = this.configDoc.getConfig();
        if (config.isSetDatabase() && (connectionConfig = (databaseConfig = config.getDatabase()).getConnection()).isSetDriverSource()) {
            DriverSource.Enum driverSource = connectionConfig.getDriverSource();
            switch (driverSource.intValue()) {
                case 1: {
                    break;
                }
                case 2: {
                    RootConfig.addBundledDBDriver(FishEyeCtl.CLASSLOADER, DBType.getForDatabaseType(databaseConfig.getType()));
                }
            }
        }
    }

    public static void addBundledDBDriver(FishEyeClassLoader fcl, DBType dbType) {
        if (dbType != null) {
            try {
                dbType.addDriverJars(fcl, AppConfig.getBundledDriverDir());
            }
            catch (MalformedURLException e2) {
                Logs.APP_LOG.error((Object)("Unable to add bundled db driver for database type " + (Object)((Object)dbType) + " to configuration"));
            }
        }
    }

    private void setSCMConfigInfo(ConfigDocument.Config config) {
        SvnLoader.setup(config.getSvnConfig());
        if (config.isSetP4Config() && config.getP4Config().isSetP4Location()) {
            try {
                P4Exec.setupExecutable(config.getP4Config().getP4Location());
            }
            catch (ConfigException e2) {
                Logs.APP_LOG.error((Object)"Problem configuring P4 executable", (Throwable)e2);
            }
        }
    }

    private SyntaxDefinitions makeSyntaxDefinitions() {
        File defaultDir;
        LinkedList<File> dirs = new LinkedList<File>();
        File customDir = new File(AppConfig.getInstanceDir(), "syntax");
        if (customDir.equals(defaultDir = new File(AppConfig.getAppHome(), "syntax"))) {
            dirs.add(defaultDir);
        } else {
            dirs.add(customDir);
            dirs.add(defaultDir);
        }
        return new SyntaxDefinitions(dirs);
    }

    private void initTimezone(ConfigDocument.Config config) {
        this.mTimeZone = TimeZone.getDefault();
        if (config.isSetTimezone()) {
            String tzid = config.getTimezone();
            if (DateHelper.AVAILABLE_TIMEZONE_IDS.contains(tzid)) {
                this.mTimeZone = TimeZone.getTimeZone(tzid);
            } else {
                Logs.APP_LOG.debug((Object)("Configured TZ '" + tzid + "' not found, using default."));
            }
        } else {
            Logs.APP_LOG.debug((Object)"TZ not set, using system default.");
        }
        Logs.APP_LOG.debug((Object)("Server TZ = '" + this.mTimeZone.getID() + "'"));
    }

    public void refreshLicenses() {
        LicenseLoader loader = new LicenseLoader(this.getConfig());
        this.mLicense = loader.updateLicensesFromXml(this.mLicense);
        this.repoPermits.setNumPermits(this.mLicense.getMaxRepositories());
    }

    public void loadLicense() {
        LicenseLoader loader = new LicenseLoader(this.getConfig());
        this.mLicense = loader.loadAndValidate();
        this.repoPermits.setNumPermits(this.mLicense.getMaxRepositories());
    }

    public void obtainRunPermit(String repoName) throws LicensePolicyException {
        this.repoPermits.obtain(repoName);
    }

    public void releaseRunPermit(String repoName) {
        this.repoPermits.release(repoName);
    }

    @Deprecated
    public RepositoryManager getRepositoryManager() {
        return SpringContext.getComponentByClass(RepositoryManager.class);
    }

    public void startRepositories() {
        this.startRepositories(true);
    }

    public void startRepositories(boolean sync) {
        if (this.mLicense != null) {
            this.getRepositoryManager().runRepositories(sync);
        } else if (this.getAdminConfig().haveDoneInitialSetup()) {
            Logs.APP_LOG.warn((Object)"No license info available, not starting FishEye repositories.");
        }
    }

    public LicenseInfo getLicense() {
        return this.mLicense;
    }

    public boolean isFishEye() {
        return this.getLicense() != null && this.getLicense().isFishEye();
    }

    public boolean isCrucible() {
        return this.getLicense() != null && this.getLicense().isCrucible();
    }

    public boolean isCrucibleOnly() {
        return this.isCrucible() && !this.isFishEye();
    }

    public boolean isFishEyeOnly() {
        return this.isFishEye() && !this.isCrucible();
    }

    public File getConfigFile() {
        return this.configFile;
    }

    private void parseViewcvsMapper(ConfigDocument.Config config) {
        if (config.isSetViewcvsUrlMapper()) {
            ViewcvsUrlMapperType e2 = config.getViewcvsUrlMapper();
            if (e2.isSetDefaultrep()) {
                this.mViewCvsConfig.setDefault(e2.getDefaultrep());
            }
            for (ViewcvsUrlMapperType.Map mapping : e2.getMapArray()) {
                this.mViewCvsConfig.add(mapping.getRep(), mapping.getViewcvsname());
            }
        }
    }

    public SyntaxDefinitions getSyntaxDefinitions() {
        return this.mSyntaxDefinitions;
    }

    public void reloadDefaultLinker() {
        this.defaultLinker.reset();
    }

    public Linker getDefaultLinker() {
        return (Linker)this.defaultLinker.get();
    }

    public boolean isApiEnabled() {
        return true;
    }

    public CustomFileNameMap getRawMimeMap() {
        return this.customFileNameMap;
    }

    public boolean handleFileWithoutExtensionAsText() {
        if (!this.getConfig().isSetReview()) {
            return false;
        }
        ReviewType review = this.getConfig().getReview();
        return review.isSetFileWithoutExtensionAsText() && review.getFileWithoutExtensionAsText();
    }

    @Deprecated
    protected void cleanupAndUpgrade(ConfigDocument.Config config) {
        this.initConfigSecurity(config);
        this.initConfigSysAdmins(config);
        this.initConfigLicense(config);
        this.initConfigDefaults(config);
        this.initConfigRepositories(config);
        this.initConfigWebServer(config);
        this.initConfigCheckForUpdates(config);
        this.initConfigSnippet(config);
        this.initConfigLicenseEval(config);
        this.upgradeCrowdResyncGroups(config);
        this.removeRemoteApiOption(config);
    }

    private void removeRemoteApiOption(ConfigDocument.Config config) {
        if (config.isSetApi()) {
            config.unsetApi();
        }
    }

    private void upgradeCrowdResyncGroups(ConfigDocument.Config config) {
        CrowdAuthConfigType crowdAuth;
        SecurityType security;
        if (config.isSetSecurity() && (security = config.getSecurity()).isSetCrowd() && (crowdAuth = security.getCrowd()).isSetResyncGroups()) {
            GroupListType groupList = GroupListType.Factory.newInstance();
            groupList.setGroupArray(ConfigUtil.createGroupArray(crowdAuth.getResyncGroups()));
            crowdAuth.setResyncGroupsList(groupList);
            crowdAuth.unsetResyncGroups();
        }
    }

    private void initConfigLicenseEval(ConfigDocument.Config config) {
        LicenseType license;
        if (config.isSetLicense() && (license = config.getLicense()).isSetCrucible() && !license.isSetFisheye()) {
            try {
                LicenseHolder licenseHolder = LicenseHolder.makeFishEyeCrucibleLicense(null, license.getCrucible());
                if (licenseHolder.hasCrucible() && licenseHolder.getCrucibleLicense().isEvaluation()) {
                    license.setFisheye("Evaluation");
                }
            }
            catch (RuntimeException e2) {
                Logs.APP_LOG.warn((Object)"Failed to convert Crucible evaluation", (Throwable)e2);
            }
        }
    }

    private void initConfigSnippet(ConfigDocument.Config config) {
        if (!config.isSetSnippet()) {
            config.addNewSnippet();
        }
    }

    private void initConfigCheckForUpdates(ConfigDocument.Config config) {
        if (!config.isSetCheckForUpdates()) {
            config.addNewCheckForUpdates();
        }
    }

    private void initConfigSecurity(ConfigDocument.Config config) {
        AvatarType avatarType;
        SecurityType sec;
        if (!config.isSetSecurity()) {
            sec = config.addNewSecurity();
            sec.setAllowAnon(true);
        }
        if (!(sec = config.getSecurity()).isSetAvatar()) {
            sec.addNewAvatar();
        }
        if (!((avatarType = sec.getAvatar()).isSetDisabled() || avatarType.isSetInternal() || avatarType.isSetUrl())) {
            avatarType.addNewDisabled();
        }
        if (!sec.isSetBuiltIn()) {
            BuiltInConfigType bi = sec.addNewBuiltIn();
            XmlbeansUtil.placeOnNewLine(bi, 2);
            SignupType signup = bi.addNewSignup();
            XmlbeansUtil.placeOnNewLine(signup, 3);
            signup.setEnabled(true);
        }
    }

    private void initConfigSysAdmins(ConfigDocument.Config config) {
        SystemAdmins sysAdmins;
        Admins admins;
        SecurityType security = config.getSecurity();
        if (!security.isSetAdmins()) {
            security.addNewAdmins();
        }
        if (!(admins = security.getAdmins()).isSetSystemAdmins()) {
            admins.addNewSystemAdmins();
        }
        if ((sysAdmins = admins.getSystemAdmins()).getUserArray() == null) {
            sysAdmins.setUserArray(new String[0]);
        }
        if (sysAdmins.getUserArray() == null) {
            sysAdmins.setUserArray(new String[0]);
        }
    }

    private void initConfigLicense(ConfigDocument.Config config) {
        if (!config.isSetLicense()) {
            LicenseType node = config.addNewLicense();
            XmlbeansUtil.placeOnNewLine(node, 1);
        }
    }

    protected void initConfigDefaults(ConfigDocument.Config config) {
        RepSecurityType defSec;
        RepositoryDefaultsType defaults = config.getRepositoryDefaults();
        if (!defaults.isSetSecurity()) {
            defaults.addNewSecurity();
        }
        if (!defaults.isSetTextIndexer()) {
            TextIndexerType ti = defaults.addNewTextIndexer();
            ti.setEnabled(true);
        }
        if (!defaults.isSetWatches()) {
            WatchType wt = defaults.addNewWatches();
            wt.setEnabled(true);
        }
        if (!defaults.isSetCommitMessageSyntax()) {
            defaults.addNewCommitMessageSyntax().setSyntax(CommitMessageSyntaxType.Syntax.PLAIN);
        }
        if (!defaults.isSetChangesetDiscussions()) {
            defaults.addNewChangesetDiscussions().setEnabled(true);
        }
        if (!(defSec = defaults.getSecurity()).isSetAllowAnon()) {
            defSec.setAllowAnon(true);
        }
        if (!defSec.isSetRequiredGroups()) {
            defSec.addNewRequiredGroups();
        }
        if (!defSec.isSetAllowLoggedIn()) {
            boolean noRequiredGroups = defSec.getRequiredGroups().sizeOfGroupArray() == 0;
            defSec.setAllowLoggedIn(!defSec.getAllowAnon() && noRequiredGroups);
        }
        if (!defaults.isSetShowCheckoutUrl()) {
            defaults.setShowCheckoutUrl(true);
        }
    }

    protected void initConfigRepositories(ConfigDocument.Config config) {
        RepositoryType[] reps;
        RepositoryType[] unsorted = config.getRepositoryArray();
        Arrays.sort(unsorted, RepositoryTypeComparator.INSTANCE);
        config.setRepositoryArray(unsorted);
        for (RepositoryType rep : reps = config.getRepositoryArray()) {
            if (!rep.isSetSecurity()) {
                rep.addNewSecurity();
                XmlbeansUtil.placeOnNewLine(rep.getSecurity(), 6);
            }
            this.cleanAndUpgradeRepositoryPermissions(config.getRepositoryDefaults(), rep);
            if (rep.isSetSvn() && !rep.getSvn().isSetSymbolic()) {
                rep.getSvn().addNewSymbolic();
            }
            if (!rep.isSetGit() && !rep.isSetHg()) continue;
            String url = null;
            if (rep.isSetGit()) {
                url = rep.getGit().getLocation();
            } else if (rep.isSetHg()) {
                url = rep.getHg().getLocation();
            }
            if (Strings.isNullOrEmpty((String)url) || !UrlUtils.isUrl(url)) continue;
            UrlUtils.UrlDetails urlDetails = UrlUtils.parse(url);
            if (Strings.isNullOrEmpty((String)urlDetails.password)) continue;
            url = UrlUtils.addAuthentication(urlDetails.protocol + urlDetails.simpleUrl, urlDetails.username);
            String password = urlDetails.password;
            if (rep.isSetGit()) {
                rep.getGit().setLocation(url);
                if (rep.getGit().isSetPasswordAuth()) continue;
                rep.getGit().addNewPasswordAuth().setPassword(password);
                continue;
            }
            if (!rep.isSetHg()) continue;
            rep.getHg().setLocation(url);
            if (rep.getHg().isSetPasswordAuth()) continue;
            rep.getHg().addNewPasswordAuth().setPassword(password);
        }
    }

    private void cleanAndUpgradeRepositoryPermissions(RepositoryDefaultsType repositoryDefaults, RepositoryType rep) {
        RepSecurityType repSec = rep.getSecurity();
        if (!repSec.isSetRequiredGroups()) {
            repSec.addNewRequiredGroups();
        }
        if (!repSec.isSetUseDefaults()) {
            boolean useDefaults;
            boolean requiredGroupsAreSet;
            boolean anonAccessWasDelegatedToDefaults = !repSec.isSetAllowAnon();
            boolean defaultsAllowAnonAccess = repositoryDefaults.getSecurity().getAllowAnon();
            boolean bl = requiredGroupsAreSet = repSec.getRequiredGroups().getGroupArray().length > 0;
            if (anonAccessWasDelegatedToDefaults) {
                useDefaults = !requiredGroupsAreSet || defaultsAllowAnonAccess;
            } else if (repSec.getAllowAnon()) {
                useDefaults = false;
            } else if (requiredGroupsAreSet) {
                useDefaults = false;
            } else if (defaultsAllowAnonAccess) {
                useDefaults = false;
                if (repositoryDefaults.getSecurity().getRequiredGroups().sizeOfGroupArray() > 0) {
                    repSec.getRequiredGroups().setGroupArray(repositoryDefaults.getSecurity().getRequiredGroups().getGroupArray());
                } else {
                    repSec.setAllowLoggedIn(true);
                }
            } else {
                useDefaults = true;
            }
            repSec.setUseDefaults(useDefaults);
        }
        if (repSec.getUseDefaults()) {
            repSec.setAllowAnon(false);
            repSec.setAllowLoggedIn(false);
            repSec.getRequiredGroups().setGroupArray(new GroupType[0]);
        }
        if (repSec.getAllowAnon()) {
            repSec.setAllowLoggedIn(false);
            repSec.getRequiredGroups().setGroupArray(new GroupType[0]);
        } else {
            repSec.setAllowAnon(false);
        }
        if (repSec.getAllowLoggedIn()) {
            repSec.getRequiredGroups().setGroupArray(new GroupType[0]);
        } else {
            repSec.setAllowLoggedIn(false);
        }
    }

    public synchronized int addRepositoryType(RepositoryType repository) {
        int idx = this.findPosition(repository);
        this.getConfig().insertNewRepository(idx);
        this.getConfig().setRepositoryArray(idx, repository);
        return idx;
    }

    private int findPosition(RepositoryType repository) {
        RepositoryTypeComparator c2 = RepositoryTypeComparator.INSTANCE;
        RepositoryType[] reps = this.getConfig().getRepositoryArray();
        for (int i2 = 0; i2 < reps.length; ++i2) {
            if (c2.compare(repository, reps[i2]) >= 0) continue;
            return i2;
        }
        return reps.length;
    }

    public RepositoryType getRepositoryType(int idx) {
        return this.getConfig().getRepositoryArray(idx);
    }

    private void initConfigWebServer(ConfigDocument.Config config) {
        WebServerType ws = config.getWebServer();
        HttpServerType wsHttp = ws.getHttp();
        if (wsHttp != null && wsHttp.isSetContext()) {
            if (!ws.isSetContext()) {
                ws.setContext(wsHttp.getContext());
                wsHttp.unsetContext();
            } else {
                Logs.APP_LOG.warn((Object)"context ignored in <http> since it is set in <web-server>");
                wsHttp.unsetContext();
            }
        }
        if (wsHttp != null) {
            if (wsHttp.isSetMaxThreads()) {
                if (ws.isSetMaxThreads()) {
                    Logs.APP_LOG.warn((Object)"max-threads in <http> ignored since it is set in <web-server>");
                } else {
                    ws.setMaxThreads(wsHttp.getMaxThreads());
                }
                wsHttp.unsetMaxThreads();
            }
            if (wsHttp.isSetMinThreads()) {
                if (ws.isSetMinThreads()) {
                    Logs.APP_LOG.warn((Object)"min-threads in <http> ignored since it is set in <web-server>");
                } else {
                    ws.setMinThreads(wsHttp.getMinThreads());
                }
                wsHttp.unsetMinThreads();
            }
        }
        if (ws.isSetAjp13()) {
            Ajp13ServerType ajp13 = ws.getAjp13();
            if (ajp13.isSetMaxThreads()) {
                if (ws.isSetMaxThreads()) {
                    Logs.APP_LOG.warn((Object)"max-threads in <ajp13> ignored since it is set in <web-server>");
                } else {
                    ws.setMaxThreads(ajp13.getMaxThreads());
                }
                ajp13.unsetMaxThreads();
            }
            if (ajp13.isSetMinThreads()) {
                if (ws.isSetMinThreads()) {
                    Logs.APP_LOG.warn((Object)"min-threads in <ajp13> ignored since it is set in <web-server>");
                } else {
                    ws.setMinThreads(ajp13.getMinThreads());
                }
                ajp13.unsetMinThreads();
            }
        }
    }

    public ViewCvsRemapper getViewCvsRemapper() {
        return this.mViewCvsConfig;
    }

    public String getControlBind() {
        return this.mControlBind;
    }

    public AdminConfig getAdminConfig() {
        return this.adminConfig;
    }

    @Deprecated
    public UserManager getUserManager() {
        if (this.mUserManager == null) {
            this.mUserManager = SpringContext.getComponentByClass(UserManager.class);
        }
        return this.mUserManager;
    }

    public void setUserManager(UserManager userManager) {
        this.mUserManager = userManager;
    }

    @Deprecated
    public UserProfileManager getUserProfileManager() {
        if (this.mUserProfileManager == null) {
            this.mUserProfileManager = SpringContext.getComponentByClass(UserProfileManager.class);
        }
        return this.mUserProfileManager;
    }

    @Deprecated
    public WatchManager getWatchManager() {
        return SpringContext.getComponentByClass(WatchManager.class);
    }

    public TimeZone getTimezone() {
        return this.mTimeZone;
    }

    public void setTimezone(TimeZone timezone) {
        this.mTimeZone = timezone;
    }

    public String getProductName() {
        if (this.isCrucibleOnly()) {
            return "Crucible";
        }
        if (this.isFishEyeOnly()) {
            return "FishEye";
        }
        return "FishEye and Crucible";
    }

    public String getSiteURL() {
        return (String)this.getConfiguredSiteUrl().getOrElse((Supplier)new Supplier<String>(){

            public String get() {
                if (RootConfig.this.fallbackSiteUrl == null) {
                    WebServerType ws = RootConfig.this.getConfig().getWebServer();
                    RootConfig.this.fallbackSiteUrl = RootConfig.guessSiteUrl(ws);
                }
                return RootConfig.this.fallbackSiteUrl;
            }
        });
    }

    public Option<String> getConfiguredSiteUrl() {
        WebServerType ws;
        ConfigDocument.Config config = this.configDoc == null ? null : this.getConfig();
        WebServerType webServerType = ws = config == null ? null : config.getWebServer();
        if (ws != null && ws.isSetSiteUrl()) {
            String url = ws.getSiteUrl().trim();
            while (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            if (!Strings.isNullOrEmpty((String)url)) {
                return Option.some((Object)url);
            }
        }
        return Option.none();
    }

    public String getContextPath() {
        Matcher m2;
        String ctx = "";
        WebServerType ws = this.getConfig().getWebServer();
        if (ws.isSetContext() && (m2 = WEB_CONTEXT_CLEANER.matcher(ws.getContext())).matches()) {
            ctx = m2.group(1);
        }
        if (!Strings.isNullOrEmpty((String)ctx)) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    static String guessSiteUrl(WebServerType ws) {
        char lastc;
        Bind bind;
        String scheme = "http";
        String servername = null;
        int port = 80;
        if (ws.isSetHttp()) {
            HttpServerType http = ws.getHttp();
            scheme = http.isSetProxyScheme() ? http.getProxyScheme() : "http";
            bind = Bind.parse(http.getBind(), servername, port);
            servername = bind.getHost();
            port = bind.getPort();
            if (http.isSetProxyHost()) {
                servername = http.getProxyHost();
            }
            if (http.isSetProxyPort()) {
                port = http.getProxyPort().intValue();
            }
        } else if (ws.isSetSsl()) {
            SslServerType ssl = ws.getSsl();
            scheme = "https";
            bind = Bind.parse(ssl.getBind(), servername, port);
            servername = bind.getHost();
            port = bind.getPort();
        }
        if (servername == null) {
            servername = RootConfig.guessLocalhost();
        }
        StringBuilder url = new StringBuilder(48);
        url.append(scheme);
        url.append("://");
        url.append(servername);
        if (port > 0 && (scheme.equalsIgnoreCase("http") && port != 80 || scheme.equalsIgnoreCase("https") && port != 443)) {
            url.append(':');
            url.append(port);
        }
        if (ws.isSetContext()) {
            String ctx = ws.getContext();
            if (!ctx.startsWith("/")) {
                url.append("/");
            }
            url.append(ctx);
        }
        if ((lastc = url.charAt(url.length() - 1)) == '/') {
            url.deleteCharAt(url.length() - 1);
        }
        return url.toString();
    }

    @VisibleForTesting
    static String guessLocalhost() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            String host = localhost.getHostName().toLowerCase();
            if (host.equals("localhost")) {
                return localhost.getCanonicalHostName().toLowerCase();
            }
            return host;
        }
        catch (UnknownHostException ex) {
            Logs.APP_LOG.error((Object)"Exception determining host name", (Throwable)ex);
            return "localhost";
        }
    }

    public void fullShutdown() {
        this.closeDB();
        this.getRepositoryManager().fullShutdown();
    }

    public void shutDownRepositories() {
        this.getRepositoryManager().fullShutdown();
    }

    public void closeDB() {
        if (SpringContext.isSetup()) {
            try {
                DBControlFactory dbControlFactory;
                WatchManager watchManager;
                if (SpringContext.isBeanPresent("quartzManager")) {
                    QuartzManager quartzManager = (QuartzManager)SpringContext.getComponent("quartzManager");
                    quartzManager.pauseScheduler();
                }
                if (SpringContext.isBeanPresent("reviewItemIndexer")) {
                    ReviewItemIndexer indexer = this.getIndexer();
                    indexer.stop();
                }
                if (this.crossRepLuceneIndex != null) {
                    Logs.APP_LOG.info((Object)"Shutting down cross-repo lucene index");
                    this.crossRepLuceneIndex.close();
                }
                if ((watchManager = SpringContext.getComponent(WatchManager.class, "watchManager")) != null) {
                    watchManager.stop();
                }
                if (SpringContext.isBeanPresent("dbControlFactory") && (dbControlFactory = (DBControlFactory)SpringContext.getComponent("dbControlFactory")).getCurrentControl().isRunning()) {
                    dbControlFactory.getCurrentControl().stop();
                }
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)("problem closing db0: " + e2.getMessage()), (Throwable)e2);
            }
        }
    }

    private ReviewItemIndexer getIndexer() {
        if (this.reviewItemIndexer == null) {
            this.reviewItemIndexer = SpringContext.getComponent(ReviewItemIndexer.class, "reviewItemIndexer");
        }
        return this.reviewItemIndexer;
    }

    private void setupSID() throws ConfigException {
        try {
            LicenseType l2 = this.getConfig().getLicense();
            if (l2.isSetSID()) {
                return;
            }
            Logs.APP_LOG.debug((Object)"Setting SID on first-run.");
            DefaultSIDManager sidMgr = new DefaultSIDManager();
            String sid = sidMgr.generateSID();
            Logs.APP_LOG.debug((Object)("SID set to " + sid));
            l2.setSID(sid);
            this.saveConfig();
            Logs.APP_LOG.debug((Object)"SID saved to config.xml");
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"SID problem", (Throwable)e2);
            throw new ConfigException("Problem initializing config file.Please make sure this file is writable: " + this.configFile);
        }
    }

    public CrossRepLuceneIndex getCrossRepLuceneIndex() {
        return this.crossRepLuceneIndex;
    }

    public void initCrossRepLuceneIndex() throws DbException {
        this.crossRepLuceneIndex = new CrossRepLuceneIndex(AppConfig.getCacheDir());
    }

    public boolean isAnonAccessAllowed() {
        return this.configDoc.getConfig().getSecurity().getAllowAnon();
    }

    public boolean isCruAnonAccessAllowed() {
        return this.configDoc.getConfig().getSecurity().getAllowCruAnon();
    }

    public File getBackupDir() {
        String path;
        BackupType.Schedule schedule;
        ConfigDocument.Config cfg = this.getConfig();
        if (cfg.isSetBackup() && (schedule = cfg.getBackup().getSchedule()) != null && !Strings.isNullOrEmpty((String)(path = schedule.getPath()))) {
            return new File(path);
        }
        return new File(AppConfig.getInstanceDir(), "backup");
    }

    @VisibleForTesting
    public static class RepositoryRunPermits {
        private int permits;
        private final Set<String> permittedToRun = Sets.newHashSet();

        public RepositoryRunPermits(int permits) {
            this.permits = permits;
        }

        public synchronized void obtain(String name) throws LicensePolicyException {
            if (-1 == this.permits || this.permittedToRun.contains(name)) {
                return;
            }
            if (this.permittedToRun.size() < this.permits) {
                this.permittedToRun.add(name);
                return;
            }
            throw new LicensePolicyException("Cannot start repository " + name + ": your license " + (this.permits == 0 ? "does not allow any " : "only allows up to " + this.permits + " ") + "running " + ExpressionUtil.pluralise("repository.", "repositories.", this.permits));
        }

        public synchronized void release(String name) {
            this.permittedToRun.remove(name);
        }

        public synchronized void setNumPermits(int permits) {
            this.permits = permits;
            if (-1 == permits) {
                this.permittedToRun.clear();
            }
        }
    }

    public class ViewCvsRemapper {
        private final Map<String, String> mNameMap = new HashMap<String, String>();
        private String mDefault = null;

        public String getDefaultRepository() {
            if (this.mDefault != null) {
                return this.mDefault;
            }
            List<RepositoryHandle> reps = RootConfig.this.getRepositoryManager().getHandles();
            if (reps.isEmpty()) {
                return "UNKNOWN";
            }
            return reps.get(0).getName();
        }

        void setDefault(String aDefault) {
            this.mDefault = aDefault;
        }

        void add(String repname, String viewcvsName) {
            this.mNameMap.put(viewcvsName, repname);
        }

        public String map(String viewcvsName) {
            String name = this.mNameMap.get(viewcvsName);
            return name != null ? name : viewcvsName;
        }
    }
}

