/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.fecru.security.SshKeyManager;
import com.atlassian.fisheye.git.GitScmConfig;
import com.atlassian.fisheye.git.client.GitProcessFactory;
import com.atlassian.fisheye.hg.HgScmConfig;
import com.atlassian.fisheye.hg.client.HgProcessFactory;
import com.atlassian.fisheye.scmapi.ScmConfig;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.ObsoleteScmConfig;
import com.cenqua.fisheye.config.RepositoryConfigFactory;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.cvsrep.CvsScmConfig;
import com.cenqua.fisheye.perforce.P4ScmConfig;
import com.cenqua.fisheye.svn.SvnScmConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="configFactory")
public class RepositoryConfigFactoryImpl
implements RepositoryConfigFactory {
    private final SshKeyManager sshKeyManager;
    private final RootConfig rootConfig;
    private final GitProcessFactory gitProcessFactory;
    private final HgProcessFactory hgProcessFactory;

    @Autowired
    public RepositoryConfigFactoryImpl(RootConfig rootConfig, SshKeyManager sshKeyManager, GitProcessFactory gitProcessFactory, HgProcessFactory hgProcessFactory) {
        this.sshKeyManager = sshKeyManager;
        this.rootConfig = rootConfig;
        this.gitProcessFactory = gitProcessFactory;
        this.hgProcessFactory = hgProcessFactory;
    }

    @Override
    public RepositoryConfig createRepositoryConfig(RepositoryType repositoryDef, LicenseEnforcer licenseEnforcer) {
        ConfigException configException;
        ScmConfig scmConfig = null;
        String name = repositoryDef.getName();
        try {
            scmConfig = this.initScmConfig(repositoryDef, this.rootConfig, name);
            configException = scmConfig.getConfigException();
        }
        catch (ConfigException e2) {
            configException = e2;
        }
        return new RepositoryConfig(this.rootConfig, repositoryDef, scmConfig, licenseEnforcer, configException);
    }

    private ScmConfig initScmConfig(RepositoryType repositoryDef, RootConfig rootConfig, String name) throws ConfigException {
        ScmConfig scmConfig;
        if (repositoryDef.isSetCvs()) {
            scmConfig = new CvsScmConfig(name, rootConfig, repositoryDef.getCvs());
        } else if (repositoryDef.isSetSvn()) {
            scmConfig = new SvnScmConfig(name, rootConfig, repositoryDef.getSvn());
        } else if (repositoryDef.isSetPerforce()) {
            scmConfig = new P4ScmConfig(name, rootConfig, repositoryDef.getPerforce());
        } else if (repositoryDef.isSetGit()) {
            scmConfig = new GitScmConfig(name, rootConfig, repositoryDef.getGit(), this.sshKeyManager, this.gitProcessFactory);
        } else if (repositoryDef.isSetClearcase()) {
            scmConfig = new ObsoleteScmConfig(repositoryDef.getClearcase(), ScmType.CLEARCASE);
            repositoryDef.setEnabled(false);
        } else if (repositoryDef.isSetHg()) {
            scmConfig = new HgScmConfig(name, rootConfig, repositoryDef.getHg(), this.sshKeyManager, this.hgProcessFactory);
        } else {
            throw new ConfigException("Could not determine repository type for " + repositoryDef.getName());
        }
        return scmConfig;
    }
}

