/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.fecru.upgrade.BackgroundUpgradeTask;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.io.File;
import java.io.IOException;

public class RemoveObsoletePerRepoIndexesUpgradeTask
implements BackgroundUpgradeTask {
    @Override
    public void run() {
        File repositoriesDir = AppConfig.getRepositoriesDir();
        for (RepositoryHandle repositoryHandle : AppConfig.getsConfig().getRepositoryManager().getHandles()) {
            try {
                File repositoryDir = new File(repositoriesDir, repositoryHandle.getName());
                for (LuceneIndexes i2 : LuceneIndexes.obsoleteValues()) {
                    this.cleanIndex(i2.getIndex(), repositoryDir);
                }
            }
            catch (IOException e2) {
                Logs.APP_LOG.warn((Object)("Exception cleaning obsolete indexes for " + repositoriesDir), (Throwable)e2);
            }
        }
    }

    private void cleanIndex(int index, File repositoryDir) throws IOException {
        File indexDir = new File(repositoryDir, "idx" + index);
        if (indexDir.exists()) {
            Logs.APP_LOG.info((Object)("Deleting obsolete index directory " + indexDir.getCanonicalPath()));
            IOHelper.recursiveDelete(indexDir, 100, true);
        }
    }

    @Override
    public String getName() {
        return "Remove Obsolete Per Repo Lucene Indexes Upgrade Task";
    }
}

