/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.fecru.util.SafeSAXXMLReaderFactory;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepSecurityType;
import com.cenqua.fisheye.config1.RepositoryDefaultsType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.WebServerType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;

public class ParseUtil {
    public static RepositoryType parseRepository(String xml) throws XmlException {
        return ParseUtil.parseAsConfig(xml).getRepositoryArray(0);
    }

    public static RepositoryDefaultsType parseRepositoryDefaults(String xml) throws XmlException {
        return ParseUtil.parseAsConfig(xml).getRepositoryDefaults();
    }

    public static RepSecurityType parseRepositorySecurity(String xml) throws XmlException {
        return ParseUtil.parseAsConfig("<repository-defaults>" + xml + "</repository-defaults>").getRepositoryDefaults().getSecurity();
    }

    public static WebServerType parseWebServer(String xml) throws XmlException {
        return ParseUtil.parseAsConfig(xml).getWebServer();
    }

    public static ConfigDocument.Config parseAsConfig(String xml) throws XmlException {
        return ParseUtil.parseConfig(ParseUtil.wrapWithConfig(xml));
    }

    static ConfigDocument.Config parseConfig(String xml) throws XmlException {
        return ConfigDocument.Factory.parse(xml, ParseUtil.parseOpts()).getConfig();
    }

    private static String wrapWithConfig(String xml) {
        return "<config>" + xml + "</config>";
    }

    private static XmlOptions parseOpts() {
        XmlOptions opts = new XmlOptions();
        opts.setLoadSubstituteNamespaces(RootConfig.makeExplicitNamespaces());
        opts.setEntityResolver(new SafeSAXXMLReaderFactory().newNoOpEntityResolver());
        return opts;
    }
}

