/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.config;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.properties.RepositoryPropertyManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.event.RepositoryStoppedEvent;
import com.atlassian.fisheye.pipeline.ChangeSetEntry;
import com.atlassian.fisheye.pipeline.ChangeSetPipeline;
import com.atlassian.fisheye.pipeline.PhaseProcessor;
import com.atlassian.fisheye.pipeline.PipelinePhase;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.RepositoryModificationTracker;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RepositoryConfigFactory;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexerCache;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.PassivateManager;
import com.cenqua.fisheye.rep.PassivationStats;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.impl.DefaultLicenseEnforcer;
import com.cenqua.fisheye.rep.ping.PingManager;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.cenqua.fisheye.util.NamedExecution;
import com.cenqua.fisheye.util.StringComparator;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="repositoryManager")
@AvailableToPlugins(value=RepositoryManager.class)
public class DefaultRepositoryManager
implements RepositoryModificationTracker,
RepositoryManager {
    private final Object mLock = new Object();
    private PassivateManager passivateManager;
    private final Map<String, RepositoryHandle> mRepMap = new ConcurrentSkipListMap<String, RepositoryHandle>(StringComparator.IGNORE_CASE_INSTANCE);
    private ConfigDocument.Config mConfig;
    @Resource
    private RootConfig rootConfig;
    @Resource
    private EventPublisher eventPublisher;
    @Resource
    private ChangeSetPipeline changeSetPipeline;
    @Resource
    private EffectiveUserProvider effectiveUserProvider;
    @Resource
    private UserManager userManager;
    @Resource
    private RepositoryPropertyManager repositoryPropertyManager;
    @Resource
    private PathIndexerCache pathCrossRepoIndexerCache;
    @Resource
    private RepositoryConfigFactory repositoryConfigFactory;
    private IndexingContext indexingContext;
    private int clearCaseRepoCount;
    private final ConcurrentMap<String, AtomicLong> perRepoLastModified = new MapMaker().makeMap();
    private final AtomicLong globalLastModified = new AtomicLong();

    public DefaultRepositoryManager(RootConfig rootConfig) {
        this.rootConfig = rootConfig;
    }

    public DefaultRepositoryManager() {
        this(null);
    }

    @Override
    public RepositoryHandle getRepository(String name) {
        return this.mRepMap.get(name);
    }

    @Override
    public void fullShutdown() {
        if (this.passivateManager != null) {
            this.passivateManager.stopBackgroundThread();
        }
        if (this.changeSetPipeline != null && this.changeSetPipeline.isStarted()) {
            this.changeSetPipeline.shutdown();
        }
        for (RepositoryHandle rep : this.getHandles()) {
            Logs.APP_LOG.info((Object)("shutdown " + rep.getName()));
            rep.stop();
        }
        try {
            boolean stillStopping;
            int sleep = 100;
            int attempts = 0;
            do {
                if (++attempts > 20) {
                    this.issueShutdownWarning();
                    break;
                }
                Thread.sleep(sleep);
                sleep = Math.min(sleep * 2, 2000);
                stillStopping = false;
                for (RepositoryHandle rep : this.getHandles()) {
                    if (rep.isStopped()) continue;
                    stillStopping = true;
                }
            } while (stillStopping);
        }
        catch (InterruptedException e2) {
            Logs.APP_LOG.info((Object)"shutdown interrupted", (Throwable)e2);
        }
    }

    private void issueShutdownWarning() {
        Logs.APP_LOG.warn((Object)"Could not shutdown some repositories after 20 attempts");
        for (RepositoryHandle rep : this.getHandles()) {
            if (rep.isStopped()) continue;
            Logs.APP_LOG.warn((Object)("Still running: " + rep.getName()));
        }
    }

    @Override
    @PostConstruct
    public void init() throws ConfigException {
        this.eventPublisher.register((Object)this);
        ConfigDocument.Config config = this.rootConfig.getConfig();
        DefaultRepositoryManager.checkConfig(config);
        this.mConfig = config;
        this.indexingContext = new IndexingContext(this.rootConfig.getCrossRepLuceneIndex(), this.changeSetPipeline, this.eventPublisher, this.rootConfig.isCrucibleOnly(), this, new PathIndexer(this.rootConfig.getCrossRepLuceneIndex(), this.pathCrossRepoIndexerCache), new BranchIndexer(this.rootConfig.getCrossRepLuceneIndex()));
        this.passivateManager = new PassivateManager(this.repositoryPropertyManager);
        this.passivateManager.load();
        if (this.mConfig.isSetResources()) {
            PingManager.setThreadConfig(this.mConfig.getResources());
        }
        this.globalLastModified.set(AppConfig.START_TIME);
        this.reloadList();
        this.changeSetPipeline.registerPhaseProcessor(PipelinePhase.METADATA, new PhaseProcessor(){

            @Override
            public boolean processChangesetEntry(ChangeSetEntry entry) throws Exception {
                RepositoryHandle handle = DefaultRepositoryManager.this.getRepository(entry.getRepository());
                return handle.getCfg().getScmConfig().getProcessorForPhase(PipelinePhase.METADATA).processChangesetEntry(handle, entry);
            }
        }, FishEyeSysProps.PIPELINE_METADATA_THREAD_COUNT);
        this.changeSetPipeline.registerPhaseProcessor(PipelinePhase.INDEXING, new PhaseProcessor(){

            @Override
            public boolean processChangesetEntry(ChangeSetEntry entry) throws Exception {
                RepositoryHandle handle = DefaultRepositoryManager.this.getRepository(entry.getRepository());
                return handle.getCfg().getScmConfig().getProcessorForPhase(PipelinePhase.INDEXING).processChangesetEntry(handle, entry);
            }
        }, FishEyeSysProps.PIPELINE_INDEXING_THREAD_COUNT);
        this.changeSetPipeline.startup(this);
    }

    private static void checkConfig(ConfigDocument.Config config) throws ConfigException {
        RepositoryType[] reps = config.getRepositoryArray();
        HashSet<String> repnames = new HashSet<String>();
        for (RepositoryType rep : reps) {
            String name = rep.getName();
            if (repnames.contains(name)) {
                throw new ConfigException("Configuration contains duplicate <repository>, named: " + name);
            }
            repnames.add(name);
        }
    }

    @EventListener
    public void repositoryStopped(RepositoryStoppedEvent repositoryStoppedEvent) {
        this.rootConfig.releaseRunPermit(repositoryStoppedEvent.getRepositoryName());
    }

    @Override
    public List<RepositoryHandle> getHandles() {
        return new ArrayList<RepositoryHandle>(this.mRepMap.values());
    }

    @Override
    public int getNumberNotStopped() {
        int count = 0;
        for (RepositoryHandle handle : this.mRepMap.values()) {
            if (handle.isStopped()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isRepositoriesAllRunning() {
        for (RepositoryHandle handle : this.mRepMap.values()) {
            if (handle.isRunning()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNumberNotRunning() {
        int count = 0;
        for (RepositoryHandle handle : this.mRepMap.values()) {
            if (handle.isRunning()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Map<String, RepositoryHandle> getHandleMap() {
        return Collections.unmodifiableMap(this.mRepMap);
    }

    @Override
    public int getClearCaseRepoCount() {
        return this.clearCaseRepoCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reloadList() throws ConfigException {
        Object object = this.mLock;
        synchronized (object) {
            RepositoryType[] repEls;
            HashSet<String> existingNames = new HashSet<String>(this.mRepMap.keySet());
            int clearCaseCount = 0;
            for (RepositoryType repositoryDef : repEls = this.mConfig.getRepositoryArray()) {
                String name = repositoryDef.getName();
                if (repositoryDef.isSetClearcase()) {
                    ++clearCaseCount;
                }
                existingNames.remove(name);
                if (this.mRepMap.containsKey(name)) continue;
                RepositoryConfig config = this.createRepositoryConfig(repositoryDef);
                if (config.getConfigException() != null) {
                    Logs.APP_LOG.error((Object)"Configuration Problem", (Throwable)config.getConfigException());
                }
                RepositoryHandle handle = new RepositoryHandle(name, config, this.indexingContext, this.passivateManager);
                this.setModified(name, AppConfig.START_TIME);
                this.mRepMap.put(name, handle);
                if (!config.isEnabled()) continue;
                this.passivateManager.repositoryBecameRunnable(handle);
            }
            this.clearCaseRepoCount = clearCaseCount;
            this.mRepMap.keySet().removeAll(existingNames);
            this.perRepoLastModified.keySet().removeAll(existingNames);
            this.rootConfig.getCrossRepLuceneIndex().purgeOldReps(this.mRepMap.keySet());
        }
    }

    private RepositoryConfig parseRepositoryConfig(String repositoryName) throws ConfigException {
        RepositoryType repositoryDef = this.getRepositoryDefinition(repositoryName);
        return this.createRepositoryConfig(repositoryDef);
    }

    private RepositoryConfig createRepositoryConfig(RepositoryType repositoryDef) throws ConfigException {
        LicenseInfo license = this.rootConfig.getLicense();
        int maxCommitters = license == null ? 0 : license.getMaxCommitters();
        return this.repositoryConfigFactory.createRepositoryConfig(repositoryDef, new DefaultLicenseEnforcer(maxCommitters));
    }

    private RepositoryType getRepositoryDefinition(String repositoryName) throws ConfigException {
        RepositoryType[] repEls;
        for (RepositoryType repositoryType : repEls = this.mConfig.getRepositoryArray()) {
            String name = repositoryType.getName();
            if (!name.equalsIgnoreCase(repositoryName)) continue;
            return repositoryType;
        }
        throw new ConfigException("Unable to find repository " + repositoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runRepository(String name) throws RepositoryHandle.StateException, IOException, DbException, ConfigException, LicensePolicyException {
        this.rootConfig.obtainRunPermit(name);
        boolean attemptedRun = false;
        try {
            RepositoryConfig updatedConfig = this.parseRepositoryConfig(name);
            if (updatedConfig.getConfigException() != null) {
                throw updatedConfig.getConfigException();
            }
            RepositoryHandle handle = this.getRepository(name);
            boolean success = handle.run(updatedConfig);
            attemptedRun = true;
            boolean bl = success;
            return bl;
        }
        finally {
            if (!attemptedRun) {
                this.rootConfig.releaseRunPermit(name);
            }
        }
    }

    @Override
    public void testConnection(String name) throws ConfigException {
        RepositoryConfig config = this.parseRepositoryConfig(name);
        if (config.getConfigException() != null) {
            throw config.getConfigException();
        }
        config.testConnection();
    }

    @Override
    public final void visitAccessibleRepositories(StoppableVisitor<RepositoryHandle> visitor) {
        Principal principal = this.effectiveUserProvider.getEffectivePrincipal();
        for (RepositoryHandle repository : this.getHandles()) {
            if (this.userManager.hasPermissionToAccess(principal, repository) && !visitor.visit(repository)) break;
        }
    }

    @Override
    public void runRepositories() {
        this.runRepositories(true);
    }

    @Override
    public void runRepositories(boolean sync) {
        ExecutorService repoStartExecutor = Executors.newFixedThreadPool(PingManager.getInitialIndexingThreads(), new ConfigurableThreadFactory("RepoStarter-", true));
        ArrayList results = Lists.newArrayList();
        for (final RepositoryHandle rep : this.getHandles()) {
            if (!rep.getCfg().isEnabled()) continue;
            results.add(repoStartExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return new NamedExecution(rep.getName()).call(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            try {
                                return DefaultRepositoryManager.this.runRepository(rep.getName());
                            }
                            catch (Exception e2) {
                                Logs.APP_LOG.warn((Object)("Problem starting repository " + rep.getName()), (Throwable)e2);
                                return false;
                            }
                        }
                    });
                }
            }));
        }
        repoStartExecutor.shutdown();
        if (sync) {
            for (Future result : results) {
                try {
                    result.get();
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
                catch (ExecutionException e3) {
                    throw new RuntimeException(e3);
                }
            }
        }
    }

    @Override
    public void setModified(String repoName, long timestamp) {
        AtomicLong lastModified = (AtomicLong)this.perRepoLastModified.get(repoName);
        if (lastModified == null) {
            this.perRepoLastModified.putIfAbsent(repoName, new AtomicLong(timestamp));
        } else {
            lastModified.compareAndSet(lastModified.get(), timestamp);
        }
        long oldGlobalTimestamp = this.globalLastModified.get();
        if (oldGlobalTimestamp < timestamp) {
            this.globalLastModified.compareAndSet(oldGlobalTimestamp, timestamp);
        }
    }

    @Override
    public long getLastModified(String repoName) {
        AtomicLong lastModified = (AtomicLong)this.perRepoLastModified.get(repoName);
        if (lastModified != null) {
            return lastModified.get();
        }
        return -1L;
    }

    @Override
    public long getLastModified() {
        return this.globalLastModified.get();
    }

    @Override
    public PassivationStats getPassivationStats() {
        return this.passivateManager == null ? null : this.passivateManager.getPassivationStats();
    }
}

